/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggabstractextension.h"


#include "ierror.h"

#include "iggframe.h"
#include "iggmainwindow.h"

//
//  Templates
//
#include "iarraytemplate.h"


//
//  Helper class
//
iggExtensionFrameBook::iggExtensionFrameBook(iggFrameBase *parent) : iggFrameBook(parent,true)
{
	mInLoop = false;
}


void iggExtensionFrameBook::OpenPageByIndex(int index)
{
	int i;
	for(i=0; i<mPages.Size(); i++) if(mPages[i].Index == index)
	{
		this->OpenPage(i);
		break;
	}
}


void iggExtensionFrameBook::Detach()
{
	mInLoop = true;
}


void iggExtensionFrameBook::OnInt1Body(int i)
{
	if(!mInLoop && i>=0 && i<mPages.Size() && mPages[i].Index>=0)
	{
		mInLoop = true; // avoid loops
		this->GetMainWindow()->OpenBookPage(mPages[i].Index);
		mInLoop = false;
	}
}


//
//  Main class
//
iggAbstractExtension::iggAbstractExtension(iggMainWindow *mw, const iImage *icon, const iString &title, bool withbook) : iggFrame(mw?mw->GetShell():0,1), mIcon(icon), mTitle(title), mWithBook(withbook)
{
	IERROR_ASSERT_NULL_POINTER(mw);
	mMainWindow = mw;
	mBook = 0;
 
	mWasLaidOut = true;
}

	
iggAbstractExtension::~iggAbstractExtension()
{
}

void iggAbstractExtension::CompleteInitialization()
{
	if(mWithBook)
	{
		mBook = new iggExtensionFrameBook(this); IERROR_ASSERT_NULL_POINTER(mBook);
		this->AddLine(mBook);
	}

	this->CompleteInitializationBody();
}


void iggAbstractExtension::OpenBookPageByIndex(int index)
{
	if(mBook != 0) mBook->OpenPageByIndex(index);
}


void iggAbstractExtension::SetTabMode(int m)
{
	if(mBook != 0) mBook->SetTabMode(m);
}

