/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "itextbitmap.h"


#include "ierror.h"
#include "iviewmodule.h"

#include <vtkProperty2D.h>
#include <vtkRenderer.h>
#include <vtkScaledTextActor.h>
#include <vtkTextMapper.h>
#include <vtkTextProperty.h>
#include <vtkViewport.h>


iTextBitmap::iTextBitmap(const iRenderTool *rv) : iText(rv)
{
	mMapper = vtkTextMapper::New(); IERROR_ASSERT_NULL_POINTER(mMapper);
	mActor = vtkScaledTextActor::New(); IERROR_ASSERT_NULL_POINTER(mActor);
	mActor->SetMapper(mMapper);

	mMapper->GetTextProperty()->SetFontFamilyToArial();
	mMapper->GetTextProperty()->ShadowOn();
	mMapper->GetTextProperty()->SetJustificationToLeft(); 
	mMapper->GetTextProperty()->SetVerticalJustificationToBottom();
}


iTextBitmap::~iTextBitmap()
{
	mMapper->Delete();
	mActor->Delete();
}


void iTextBitmap::GetSize(vtkViewport *viewport, float s[2])
{
	mMapper->SetInput(mText.ToCharPointer());

	mMapper->GetTextProperty()->SetFontSize(mFontSize);
	if(mBold) mMapper->GetTextProperty()->BoldOn(); else mMapper->GetTextProperty()->BoldOff();

	double w = (float)mMapper->GetWidth(viewport);
	double h = (float)mMapper->GetHeight(viewport);
	viewport->DisplayToNormalizedDisplay(w,h);

	mSize[0] = s[0] = w; mSize[1] = s[1] = h;
}


void iTextBitmap::ReleaseGraphicsResources(vtkWindow *win)
{
	mActor->ReleaseGraphicsResources(win);
	this->iText::ReleaseGraphicsResources(win);
}


int iTextBitmap::RenderOverlay(vtkViewport* viewport)
{
	mActor->RenderOverlay(viewport);
	return 1;
}


int iTextBitmap::RenderOpaqueGeometry(vtkViewport* viewport)
{
	vtkCamera *cam = iPointerCast<vtkRenderer,vtkViewport>(viewport)->GetActiveCamera();
	if(cam == 0) return 0;

	int mag = this->GetRenderingMagnification();

	if(mag == 1)
	{
		this->SetActorPosition(viewport);

		mMapper->GetTextProperty()->SetColor(mColor.ToVTK());

		mActor->SetPosition(mActorPos[0],mActorPos[1]);
		mActor->SetPosition2(mSize[0],mSize[1]);
	}
	else
	{
		int winij[2];
		this->ComputePositionShiftsUnderMagnification(cam,winij,viewport);
		
		mActor->SetPosition(mag*mActorPos[0]-winij[0],mag*mActorPos[1]-winij[1]);
		mActor->SetPosition2(mag*mSize[0],mag*mSize[1]);

		mMapper->GetTextProperty()->SetFontSize(mag*mFontSize);
	}

	mActor->RenderOpaqueGeometry(viewport);
	
	return 1;
}
