/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "ireplicated.h"


#include "ierror.h"
#include "iviewobjectreplicator.h"


iReplicated::iReplicated(iViewObjectReplicator *replicator, bool data)
{
	int i;
	for(i=0; i<6; i++) mNumReplicas[i] = mOldNumReplicas[i] = 0;

	mReplicator = replicator;
	mIsDataReplicated = data;

	if(mReplicator != 0)
	{
		if(mIsDataReplicated) mReplicator->AddDataReplicated(this); else mReplicator->AddPropReplicated(this);
	}
}


iReplicated::~iReplicated()
{
	if(mReplicator != 0)
	{
		if(mIsDataReplicated) mReplicator->RemoveDataReplicated(this); else mReplicator->RemovePropReplicated(this);
	}
}


void iReplicated::SetNumReplicas(const int n[6])
{
	int i;
	bool work = false;

	for(i=0; i<6; i++)
	{
		if(n[i]>=0 && n[i]!=mNumReplicas[i])
		{
			work = true;
			mOldNumReplicas[i] = mNumReplicas[i];
			mNumReplicas[i] = n[i];
		}
	}

	if(work)
	{
		this->UpdateReplicas();
		for(i=0; i<6; i++) mOldNumReplicas[i] = mNumReplicas[i];
	}
}


void iReplicated::SetNumReplicas(int d, int n)
{
	if(n>=0 && d>=0 && d<6 && n!=mNumReplicas[d])
	{
		mOldNumReplicas[d] = mNumReplicas[d];
		mNumReplicas[d] = n;
		this->UpdateReplicas();
		mOldNumReplicas[d] = mNumReplicas[d];
	}
}


void iReplicated::UnReplicate()
{
	static int r[6] = { 0, 0, 0, 0, 0, 0 };

	this->SetNumReplicas(r);
}


void iReplicated::ReplicateAs(const iReplicated *other)
{
	this->SetNumReplicas(other->mNumReplicas);
}


