/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IPARALLELPIPELINE_H
#define IPARALLELPIPELINE_H


#include "igenericfilter.h"
#include "iviewobjectcomponent.h"
#include "iparallelworker.h"


#include "iarray.h"

template<class InputType> class iDataDistributor;
template<class Filter, class InputType> class iSerialPipeline;
class iAppendPolyDataFilter;

class vtkDataObject;
class vtkImageAppend;
class vtkImageData;
class vtkPolyData;


template<class Filter, class InputType, class OutputType>
class iParallelPipeline : public Filter, protected iViewObjectComponent, protected iParallelWorker
{

public:

	void FinishInitialization();

	virtual float GetMemorySize() const;

	virtual void Modified();
	virtual void Reconfigure();

protected:

	iParallelPipeline(int numInputs, iViewObject *vo);
	virtual ~iParallelPipeline();

	virtual int ExecuteStep(int step, iParallel::ProcessorInfo &p);

	virtual void ProduceOutput(InputType *input, OutputType *output); 

	virtual iSerialPipeline<Filter,InputType>* CreateSerialPipeline() = 0;
	virtual void Append() = 0;

	virtual iDataDistributor<InputType>* CreateDataDistributor() = 0;
	virtual InputType* CreateSerialInput();
	void ConfigurePipelines();
	void ResetPipelines();

	int mNumProcs;
	unsigned long mConfigureTime;
	bool mPolish;

	iDataDistributor<InputType> *mDistributor;

	iArray<InputType*> mWorkInputs;
	iArray<iSerialPipeline<Filter,InputType>*> mWorkPipelines;
};


//
//  Template with vtkPolyData as output
//
template<class Filter, class InputType>
class iParallelDataToPolyDataPipeline : public iParallelPipeline<Filter,InputType,vtkPolyData>
{

public:

	void SetPatchStitches(bool s);
	inline bool GetPatchStitches() const { return this->mPatchStitches; }

protected:

	iParallelDataToPolyDataPipeline(int numInputs, iViewObject *vo);
	virtual ~iParallelDataToPolyDataPipeline();

	virtual void Append();

	bool mPatchStitches;
	iAppendPolyDataFilter *mAppend;
};


//
//  template with vtkStructuredPoints as output
//
template<class Filter, class InputType>
class iParallelDataToGridDataPipeline : public iParallelPipeline<Filter,InputType,vtkStructuredPoints>
{

protected:

	iParallelDataToGridDataPipeline(int numInputs, iViewObject *vo);
	virtual ~iParallelDataToGridDataPipeline();

	virtual void Append();

	vtkImageAppend *mAppend;
};


//
//  Specific classes with vtkPolyData as output
//
class iParallelGridDataToPolyDataPipeline : public iParallelDataToPolyDataPipeline<iAbstractGridDataToPolyDataFilter,vtkImageData>
{

protected:

	iParallelGridDataToPolyDataPipeline(int numInputs, iViewObject *vo);
	virtual ~iParallelGridDataToPolyDataPipeline(){}

	virtual iDataDistributor<vtkImageData>* CreateDataDistributor();
};


class iParallelPolyDataToPolyDataPipeline : public iParallelDataToPolyDataPipeline<iAbstractPolyDataToPolyDataFilter,vtkPolyData>
{

protected:

	iParallelPolyDataToPolyDataPipeline(int numInputs, iViewObject *vo);
	virtual ~iParallelPolyDataToPolyDataPipeline(){}

	virtual iDataDistributor<vtkPolyData>* CreateDataDistributor();
};

//
//  Specific classes with vtkStructuredPoints as output
//
class iParallelGridDataToGridDataPipeline : public iParallelDataToGridDataPipeline<iAbstractGridDataToGridDataFilter,vtkImageData>
{

protected:

	iParallelGridDataToGridDataPipeline(int numInputs, iViewObject *vo);
	virtual ~iParallelGridDataToGridDataPipeline(){}

	virtual iDataDistributor<vtkImageData>* CreateDataDistributor();
};

#endif  // IPARALLELPIPELINE_H

