/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


//
//  A front-end for portable inheritance
//
#ifndef IGENERICFILTER_H
#define IGENERICFILTER_H


#include <vtkPolyDataSource.h>
#include <vtkPolyDataToPolyDataFilter.h>
#include <vtkStructuredPointsToPolyDataFilter.h>
#include <vtkStructuredPointsToStructuredPointsFilter.h>


#include "ivtk.h"

class iGridData;
class iPolyData;

class vtkDataObject;
class vtkDataSetAttributes;
class vtkFloatArray;


template<class Source, class OutputType>
class iGenericSource : public Source
{

protected:

	iGenericSource(){}
	virtual ~iGenericSource(){}

	virtual void ExecuteData(vtkDataObject *output);

	virtual void ProduceOutput(OutputType *output) = 0; // called to recompute the output
};


template<class Filter, class InputType, class OutputType>
class iGenericFilter : public Filter
{

#ifdef IVTK_4
public:
	virtual void ExecuteInformation();
#else
protected:
	virtual int ProcessRequest(vtkInformation*, vtkInformationVector**, vtkInformationVector*);
#endif

protected:

	iGenericFilter(int numInputs = 1);
	virtual ~iGenericFilter(){}

	virtual void ExecuteData(vtkDataObject *output);

	virtual void InitExecution(InputType *input, OutputType *output);  //  called if recomputing is needed
	virtual void ProduceOutput(InputType *input, OutputType *output) = 0; // called to recompute the output
	virtual void VerifyResults(InputType *input, OutputType *output);  //  called on every pipeline pass after Compute

	//
	//  Helper members for transforming scalars
	//
	bool ScalarsInit(vtkDataSetAttributes *data, vtkIdType nSizeOut = 0, int nDimOut = 0);
	void ScalarsDone(vtkDataSetAttributes *data);

	vtkFloatArray *wScalarArrIn, *wScalarArrOut;
	float *wScalarPtrIn, *wScalarPtrOut;
	int wScalarDimIn, wScalarDimOut;
};


template<class Filter>
class iGenericPolyDataToPolyDataFilter : public iGenericFilter<Filter,vtkPolyData,vtkPolyData>
{

protected:
	
	iGenericPolyDataToPolyDataFilter(int numInputs = 1) : iGenericFilter<Filter,vtkPolyData,vtkPolyData>(numInputs){}

	virtual void VerifyResults(vtkPolyData *input, vtkPolyData *output);
};


typedef iGenericSource<vtkPolyDataSource,vtkPolyData> iAbstractPolyDataSource;
typedef iGenericPolyDataToPolyDataFilter<vtkPolyDataToPolyDataFilter> iAbstractPolyDataToPolyDataFilter;
typedef iGenericFilter<vtkStructuredPointsToPolyDataFilter,vtkImageData,vtkPolyData> iAbstractGridDataToPolyDataFilter;
typedef iGenericFilter<vtkStructuredPointsToStructuredPointsFilter,vtkImageData,vtkStructuredPoints> iAbstractGridDataToGridDataFilter;

#endif // IGENERICFILTER_H
 
