/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Some useful error reporting macros and function(s)
//

#ifndef IERROR_H
#define IERROR_H


#include "iconsole.h"


#define IERROR_ASSERT_NULL_POINTER(_p_) { if((_p_) == 0) iConsole::Instance()->DisplayFatalErrorMessage("Null pointer.",__FILE__,__LINE__); }
#define IERROR_REPORT_OUT_OF_BOUNDS     { iConsole::Instance()->DisplayFatalErrorMessage("Array out of bounds.",__FILE__,__LINE__); }
#define IERROR_REPORT_FATAL_ERROR(m)    { iConsole::Instance()->DisplayFatalErrorMessage(m,__FILE__,__LINE__); }
#define IERROR_REPORT_ERROR(m)          { iConsole::Instance()->DisplayErrorMessage(m,__FILE__,__LINE__); }
#ifdef I_CHECK1
#define IERROR_REPORT_BUG               { iConsole::Instance()->DisplayErrorMessage("Bug detected.",__FILE__,__LINE__); }
#endif
#ifdef I_DEBUG
#define IERROR_BREAKPOINT               { iConsole::Instance()->BreakPoint(__FILE__,__LINE__); }
#endif
//
//  error-reporting dynamic_cast - make it a global function to reduce de-referencing
//
template<class O, class I>
inline O* iPointerCast(I* p)
{
	if(p == 0) return 0;
	O* tmp = dynamic_cast<O*>(p);
	if(tmp == 0) iConsole::Instance()->DisplayFatalErrorMessage("Invalid cast",__FILE__,__LINE__);
	return tmp;
}

#endif  // IERROR_H

