/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IDATAEXPLORER_H
#define IDATAEXPLORER_H


#include <vtkObject.h>
#include "iobject.h"
#include "idataconsumer.h"

class iDataType;
class iHistogram;
class iHistogramMaker;
class iGridDataConverter;


class iDataExplorer : public vtkObject, public iObject, public iDataConsumer
{

	friend class iExtensionFactory;

public:

	struct Info
	{
		float Maximum;
		float Minimum;
		float Median;
		float Average;
		float Dispersion;
		const iHistogram* Histogram;
		vtkIdType CellMin, CellMax;
		const iPosition *PosMin, *PosMax;
	};

	static iDataExplorer* New(iViewModule *vm);
	static const iObjectType& Type();

	//
	//  using a struct, only one Update is needed to bring everything up to date
	//
	const Info& GetInfo(bool rangeonly = false);

	void SetStretch(int v);
	void SetInputComponent(int c);
	inline int GetNumberOfInputComponents() const { return mNumComponents; }

protected:
	
	iDataExplorer(iViewModule *vm, const iDataInfo &info);
	virtual ~iDataExplorer();

	virtual void Execute();
	virtual void SyncWithDataBody(int, void *);

	virtual void PackStateBody(iString &) const {}
	virtual void UnPackStateBody(const iString &){}

	//
	//  Inherit the following functions to extend to other DataTypes
	//
	virtual iHistogramMaker* CreateHistogramMaker() const;
	virtual void SetInputComponentBody(int c);
	virtual void UpdateDataType();

	bool mComputeRangeOnly;
	int mComponent, mNumComponents;
	Info mInfo;
	iHistogramMaker *mHistogramMaker;
	iGridDataConverter *mDataConverter;
	unsigned long mMTime;
};

#endif  // IDATAEXPLORER_H


