/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ICUBEAXESACTOR_H
#define ICUBEAXESACTOR_H


#include <vtkCubeAxesActor2D.h>
#include "ioverlaybase.h"


class vtkViewport;


class iCubeAxesActor: public vtkCubeAxesActor2D, protected iOverlayBase
{

public:

	static iCubeAxesActor* New(const iRenderTool *rv);
	virtual int RenderOpaqueGeometry(vtkViewport *viewport);
	virtual int RenderOverlay(vtkViewport *viewport);

	virtual void SetFontSize(int s);
	inline int GetFontSize() const { return mFontSize; }

private:

	iCubeAxesActor(const iRenderTool *rv);

	int mFontSize;
	double mPos1X[3], mPos1Y[3], mPos1Z[3];
	double mPos2X[3], mPos2Y[3], mPos2Z[3];
};

#endif // ICUBEAXESACTOR_H
