/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ICAPTION_H
#define ICAPTION_H


#include <vtkCaptionActor2D.h>
#include "ioverlaybase.h"


class iActor;

class vtkActor2D;
class vtkPolyData;
class vtkPolyDataMapper2D;
class vtkTextMapper;


class iCaption: public vtkCaptionActor2D, protected iOverlayBase
{
	
public:
	
	static iCaption* New(const iRenderTool *rv);
	
	virtual int RenderOverlay(vtkViewport*);
	virtual int RenderOpaqueGeometry(vtkViewport*);
	virtual int RenderTranslucentGeometry(vtkViewport *){ return 0; }
	
	virtual void ReleaseGraphicsResources(vtkWindow *win);

	virtual void SetFontSize(int s);
	inline int GetFontSize(){ return mFontSize; }

	virtual void SetLeader3D(bool s){ mLeader3D = s; }
	inline bool GetLeader3D(){return mLeader3D; }

protected:
	
	iCaption(const iRenderTool *rv);
	virtual ~iCaption();
	
private:

	int mFontSize;
	float mUnmagx1[2], mUnmagx2[2];
	bool mLeader3D;
	//
	//  Need new border and leader since they are declared private in the parent class
	//
	vtkPolyData         *mBorderPolyData;
	vtkPolyDataMapper2D *mBorderMapper;
	vtkActor2D          *mBorderActor;
	
	// for 2D leader
	vtkPolyData         *mLeaderPolyData;
	vtkPolyDataMapper2D *mLeaderMapper2D;
	vtkActor2D          *mLeaderActor2D;

	// for 3D leader
	iActor            *mLeaderActor3D;

	vtkTextMapper *mTmpMapper;
};

#endif // ICAPTION_H
