/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#include "iversion.h"


//
//  IFrIT version
//
#define IVERSION_BASE		"3.0.0"

#define IVERSION_EXT_HART	"2.0.0"
#define IVERSION_EXT_MV		"1.0.0"

//
//  History
//
//  060608  Base-3.0.0b1  HART-2.0.0b1  MV-1.0.0b1  -- First beta release
//  060609  Base-3.0.0b2  HART-2.0.0b2  MV-1.0.0b2  -- Added special locations in CrossSectionViewObject
//  060622  Base-3.0.0b3  HART-2.0.0b3  MV-1.0.0b3  -- Added coordinate system switch for HART extension
//  060701  Base-3.0.0b4  HART-2.0.0b4  MV-1.0.0b4  -- Added abstract/generic filters for porting, cleaned up class names
//  060707  Base-3.0.0b5  HART-2.0.0b5  MV-1.0.0b5  -- Completed Script Debugger
//  060721  Base-3.0.0b6  HART-2.0.0b6  MV-1.0.0b6  -- Completed port to Qt4
//  060728  Base-3.0.0b7  HART-2.0.0b7  MV-1.0.0b7  -- Internal changes, docking fixed (?)
//  060815  Base-3.0.0b8  HART-2.0.0b8  MV-1.0.0b8  -- New icons, docking now really fixed, x-section in texture mode on multiple processors is fixed
//                                                     Includes 3D texture model for volume rendering and direct MPEG/AVI movie creation
//  060817  Base-3.0.0    HART-2.0.0    MV-1.0.0    -- First release: basic things seem to work now.
//


#if ISHELL_INCLUDED(ISHELL_QT)
#include <qglobal.h>
#endif


const iString iVersion::GetVersion()
{ 
	return IVERSION_BASE;
}


const iString iVersion::GetIncludedExtensions()
{ 
	iString tmp; 
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	tmp += iString("HART extension v") + IVERSION_EXT_HART +";";
#endif
#if IEXTENSION_INCLUDED(IEXTENSION_MV)
	tmp += iString("MultiView extension v") + IVERSION_EXT_MV +";";
#endif
	return tmp;
}


const iString iVersion::GetIncludedShells()
{ 
	iString tmp;
#if ISHELL_INCLUDED(ISHELL_CL)
	tmp += iString("Command-line shell") + ";";
#endif
#if ISHELL_INCLUDED(ISHELL_QT)
	tmp += iString("Qt-based GUI shell (Qt ") + QT_VERSION_STR + ");";
#endif
#if ISHELL_INCLUDED(ISHELL_FX)
	tmp += iString("FOX-based GUI shell") + ";";
#endif
	return tmp;
}
