/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*
Header file for classes that support GUI data structures. They are 
created to minimize interaction berween GUI and VTK. 
*/

#ifndef IPIECEWISEFUNCTION_H
#define IPIECEWISEFUNCTION_H

class vtkPiecewiseFunction;

class iPiecewiseFunction 
{
	
public:
	
	iPiecewiseFunction(float yleft=0.0, float yright=1.0);
	virtual ~iPiecewiseFunction();
	
	inline int iPiecewiseFunction::getFunctionN(){ return opan; }
	inline float* iPiecewiseFunction::getFunctionX(){ return opax; }
	inline float* iPiecewiseFunction::getFunctionY(){ return opay; }
	inline float iPiecewiseFunction::getFunctionMin(){ return opaymin; }
	inline float iPiecewiseFunction::getFunctionMax(){ return opaymax; }
	inline vtkPiecewiseFunction *getVTKFunction(){ return vtkof; }
	
	virtual void setFunctionLimits(float ymin, float ymax);
	virtual void addFunctionPoint(int n);
	virtual void addFunctionPoint(float x, float y);
	virtual void delFunctionPoint(int n);
	virtual void movFunctionPoint(int n, float x, float y);
	virtual void getFunctionPoint(int n, float &x, float &y);
	virtual int findFunctionPoint(float x, float y, float &d);
	virtual float getValue(float x);

	virtual void copy(iPiecewiseFunction *f);
	
protected:
	
	virtual void setVTKFunction();
	
private:
	
	float *opax, *opay;
	float opaymin, opaymax;
	int opan;
	vtkPiecewiseFunction *vtkof;
	
};

#endif // IPIECEWISEFUNCTION_H

