/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*
Header file for iXsection class
*/

#ifndef IXSECTION_H
#define IXSECTION_H


class vtkPolyDataMapper;
class vtkLODActor;
class vtkProperty;
class vtkProbeFilter;
class vtkPlaneSource;
class vtkTexture;
class vtkLookupTable;
class vtkCleanPolyData;

class iUniformMeshDataConverter;
class iOrthoSlicer;
class iOrthoPlane;
class iOrthoTexturePlane;

class hOrthoPlane;

#include "ivisualobject.h"
#include "icolor.h"


class iXsection : public iVisualObject 
{
	
	friend class iObjectFactory;

public:
	
	static iXsection* New(iVTK *m = 0);
	virtual ~iXsection();
	
	inline int getDir(){ return dir; }
	inline int getVar(){ return var; }
	inline double getPos(){ return pos; }
	inline int getPal(){ return pal; }
	inline void getDirVector(float *n){ n[0] = nvec[0]; n[1] = nvec[1]; n[2] = nvec[2]; }
	
	inline vtkLODActor* getXsection(){ return xsectionActor; }
	inline vtkPolyDataMapper* getMapper(){ return xsectionMapper; }
	inline iOrthoSlicer* getSlicer(){ return xsectionSlicer; }
	inline vtkLookupTable* getColorLookupTable(){ return colorLookupTable; }
	
	virtual void setDir(int d);
	virtual void setVar(int v);
	virtual bool setPos(double p, bool checkPosMax = true);
	virtual void setPal(int p);

	inline void setDirVector(float *n){ this->setDirVector(n[0],n[1],n[2]); }
	virtual void setDirVector(float n1, float n2, float n3);
	
	virtual void setAmbient(float v);
	virtual void setDiffuse(float v);
	virtual void setSpecular(float v);
	virtual void setSpecularPower(float v);
	
	virtual void show(bool s);
	virtual void reset();
	
	virtual void showClipPlane(bool){ }
	virtual void showColorBars(bool s);

	virtual void setMode(int m);
	inline int getMode(){ return mode; }

	virtual void forcePolygonalMode(bool s);

	virtual void setInterpolateData(bool s);
	inline bool getInterpolateData(){ return interpolateData; }

	virtual void packState(iString &s);
	virtual void unpackState(iString s);

	virtual float getMemorySize();

protected:
	
	iXsection(iVTK *m = 0);

	bool interpolateData;

	int var;
	int dir;
	double pos, posmax;
	int pal;
	vtkFloat nvec[3], *x0[4];
	int mode;
	//
	//  VTK stuff
	//
	vtkLODActor *xsectionActor;	
	vtkPolyDataMapper *xsectionMapper;
	vtkProperty *xsectionProperty;
	vtkProbeFilter *xsectionProbe;
	vtkPlaneSource *xsectionSource;
	vtkTexture *xsectionTexture;
	vtkLookupTable *colorLookupTable;

	iUniformMeshDataConverter *xsectionDataConverter;
	iOrthoSlicer *xsectionSlicer;
	iOrthoPlane *xsectionOrthoPlane;
	iOrthoTexturePlane *xsectionTextureConverter;
	
};

#endif // IXSECTION_H

