/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/**********************************************************************
*
*  Superclass for displaying text in VTK
*
***********************************************************************/


#ifndef ITEXT_H
#define ITEXT_H

#include <vtkProp.h>

#define ITEXT_BOTTOM	0
#define ITEXT_CENTER	1
#define ITEXT_TOP		2
#define ITEXT_LEFT		0
#define ITEXT_RIGHT		2


class iText: public vtkProp
{
	
public:
	
	static iText *New(){ return 0; }
	
	virtual int RenderOverlay(vtkViewport *v) = 0;
	virtual int RenderOpaqueGeometry(vtkViewport *v) = 0;
	virtual int RenderTranslucentGeometry(vtkViewport *){ return 0; }
	virtual void ReleaseGraphicsResources(vtkWindow *w);
	
	virtual void setColor(float r, float g, float b){ red = r; green = g; blue = b; }
	virtual void setFontSize(int s){ if(s>0 && s<99) fontSize = s; }
	virtual void setBold(bool s){ bold = s; }
	virtual void setHJustification(int s){ if(s>=-2 && s<=2) hJust = s; }
	virtual void setVJustification(int s){ if(s>=-2 && s<=2) vJust = s; }
	virtual void setPosition(float p[2]){ pos[0] = p[0]; pos[1] = p[1]; }
	virtual void setPosition(float p0, float p1){ pos[0] = p0; pos[1] = p1; }
	virtual void rotate(float a){ angle = a; }

	inline int getFontSize(){ return fontSize; }
	inline bool getBold(){ return bold; }
	inline float *getPosition(){ return pos; }
	inline float *getSize(){ return size; }

	virtual void getSize(vtkViewport *v, float s[2]) = 0;

	virtual void setText(char *t);

protected:
	
	iText();
	virtual ~iText();
	
	int fontSize;
	bool bold;
	int hJust, vJust;
	float pos[2];
	float angle;
	float red, green, blue;
	float size[2];

	int len;
	char* text;

};

#endif // ITEXT_H
