/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#ifndef ITENSOR_H
#define ITENSOR_H

class vtkPolyDataMapper;
class vtkLODActor;
class vtkActor;
class vtkProperty;
class vtkExtractVOI;
class vtkSphereSource;
class vtkTensorGlyph;

class iTensorDataConverter;
class iPolygonalDataExtender;


#include "ivisualobject.h"
#include "icolor.h"


class iTensor : public iVisualObject
{
	
	friend class iObjectFactory;

public:
	
	static iTensor* New(iVTK *m = 0);
	virtual ~iTensor();
	
	inline int getPal(){ return pal; }
	inline int getColorBy(){ return colorBy; }
	inline int getSampleRate(){ return sampleRate; }
	inline float getGlyphSize(){ return glyphSize; }
	inline iColor getColor(){ return color; }
	inline bool isScalingOn(){ return scalingOn; }

	inline vtkLODActor* getTensor(){ return tensorActor; }
	inline vtkPolyDataMapper* getMapper(){ return tensorMapper; }
	inline iPolygonalDataExtender* getExtender(){ return tensorExtender; }

	virtual void setPal(int p);
	virtual void setColorBy(int q);
	virtual void setSampleRate(int q);
	virtual void setGlyphSize(float q);
	virtual void setColor(iColor q);
	virtual void setScalingOn(bool s);

	virtual void setAmbient(float v);
	virtual void setDiffuse(float v);
	virtual void setSpecular(float v);
	virtual void setSpecularPower(float v);
	
	virtual void show(bool s);
	virtual void reset();
	
	virtual void showClipPlane(bool s);
	virtual void showColorBars(bool s);

	virtual void packState(iString &s);
	virtual void unpackState(iString s);

	virtual float getMemorySize();

	virtual void updatePipeline();

protected:
	
	iTensor(iVTK *m = 0);
	virtual void computeSpacing();

	iColor color;

	float curSpacing;
	bool scalingOn;
	int mode;
	int pal;
	float glyphSize;
	int colorBy;
	int sampleRate;
	//
	//  VTK stuff
	//
	vtkLODActor *tensorActor;	
	vtkPolyDataMapper *tensorMapper;
	vtkProperty *tensorProperty;
	vtkTensorGlyph *tensorGlyph;
	vtkExtractVOI *tensorFilter;
	vtkSphereSource *glyphSphere;

	iTensorDataConverter *tensorDataConverter;
	iPolygonalDataExtender *tensorExtender;
	
};

#endif // ITENSOR_H

