/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  This class is based on original vtkQGLRenderWindowInteractor class written by Manish P. Pagey [pagey@drcsdca.com ]
//

#ifndef IRENDERWINDOWINTERACTOR_H
#define IRENDERWINDOWINTERACTOR_H

#include <qobject.h>
#include <qtimer.h>

#include <vtkVersion.h>
#include <vtkRenderWindowInteractor.h>

class iRenderWindow;

// ------------------------------------------------------------
// :TRICKY: Fri Apr 21 22:19:27 2000 Pagey
// The Signal/Slot mechanism used by Qt requires that QObject 
// appear as the first class when using multiple inheritance. 
// Hence the order of the two classes QObject and vtkRenderWindowInteractor
// matters here. Be careful not to change it by accident. 
// ------------------------------------------------------------
class iRenderWindowInteractor : public QObject, public vtkRenderWindowInteractor
{

  Q_OBJECT 

public:

  static iRenderWindowInteractor *New(); 

  vtkTypeMacro(vtkRenderWindowInteractor,vtkObject);

  // Description:
  // Initializes the event handlers without an XtAppContext.  This is
  // good for when you don't have a user interface, but you still
  // want to have mouse interaction.
  virtual void Initialize();

  // Description:
  // This will start up the X event loop and never return. If you
  // call this method it will loop processing X events until the
  // application is exited.
  virtual void Start();
  
  // Description:
  // Enable/Disable interactions.  By default interactors are enabled when
  // initialized.  Initialize() must be called prior to enabling/disabling
  // interaction. These methods are used when a window/widget is being
  // shared by multiple renderers and interactors.  This allows a "modal"
  // display where one interactor is active when its data is to be displayed
  // and all other interactors associated with the widget are disabled
  // when their data is not displayed.
  virtual void Enable();
  virtual void Disable();

  // Description:
  // Timer methods must be overridden by platform dependent subclasses.
  // flag is passed to indicate if this is first timer set or an update
  // as Win32 uses repeating timers, whereas X uses One shot more timer
  // if flag==VTKXI_TIMER_FIRST Win32 and X should createtimer
  // otherwise Win32 should exit and X should perform AddTimeOut()
  virtual int CreateTimer(int); 
  virtual int DestroyTimer(); 

  // Description:
  // This function is called on 'q','e' keypress if exitmethod is not
  // specified and should be overidden by platform dependent subclasses
  // to provide a termination procedure if one is required.
  virtual void TerminateApp(void) { /* empty */ }

  virtual void UserCallback();

  // Description:
  // These methods correspond to the the Exit, User and Pick
  // callbacks. They allow for the Style to invoke them.
  //virtual void ExitCallback();
  //virtual void UserCallback();
  //virtual void StartPickCallback();
  //virtual void EndPickCallback();

  //
  //  New SetRenderWindow - needed to avoid dynamic casts
  //
  virtual void SetRenderWindow(iRenderWindow *win);

protected:

  iRenderWindowInteractor();
  ~iRenderWindowInteractor();
  //
  // Timer used during various mouse events to figure 
  // out mouse movements. 
  //
  QTimer *mTimer;

  //
  // User for switching to stereo mode.
  //
  int PositionBeforeStereo[2];
  //
  // Connect/disconnect all slots which allow events on the
  // render window to be passed to the interactor. 
  //
  void ConnectSlots();
  void DisconnectSlots();
  void ProcessSlotConnections(bool conn);

  iRenderWindow *my_render_win;

public slots:

  void MouseMove(const QMouseEvent *event);
  void LeftButtonPressed(const QMouseEvent *event);
  void LeftButtonReleased(const QMouseEvent *event);
  void MiddleButtonPressed(const QMouseEvent *event);
  void MiddleButtonReleased(const QMouseEvent *event);
  void RightButtonPressed(const QMouseEvent *event);
  void RightButtonReleased(const QMouseEvent *event);
  void KeyPressed(QKeyEvent *event);

private slots:

  void TimerFunc();

signals:

  void RenderWindowModified();

};

#endif //IRENDERWINDOWINTERACTOR_H
