/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*=========================================================================

  Ifrit data filter: takes StructuredPoints data of type float and converts them into
  StructuredPoints data of type char using lower and upper bounds.

=========================================================================*/

#ifndef IHISTOGRAMMAKER_H
#define IHISTOGRAMMAKER_H

class vtkFloatArray;

class iPiecewiseFunction;


#include <vtkDataSetSource.h>


class iHistogramMaker : public vtkDataSetSource
{
	
public:
	
	static iHistogramMaker *New();
	
	inline int getCurrentNumberOfBins(){ return nBinsPrev; }
	inline int getInputComponent(){ return component; }
	virtual int getEstimatedNumberOfBins();

	float getMinValue(){ return vMinPrev; }
	float getMaxValue(){ return vMaxPrev; }

	vtkIdType getMinCellIndex(){ return lMinPrev; }
	vtkIdType getMaxCellIndex(){ return lMaxPrev; }

	double* getMinCellPosition(){ return xMinPrev; }
	double* getMaxCellPosition(){ return xMaxPrev; }
	
	virtual iPiecewiseFunction *getHistogram(int nBins = 0, bool inLog = 0);
	virtual iPiecewiseFunction *getHistogram(int nBins, bool inLog, float vMin, float vMax);

	virtual void SetInput(vtkDataSet *input, int c);
	virtual void SetInputComponent(int c);
	virtual vtkDataSet* GetInput();

protected:
	
	virtual void ExecuteData(vtkDataObject *out);
	iHistogramMaker();
	virtual ~iHistogramMaker();

	iPiecewiseFunction *histo;
	int nBinsPrev;
	float vMinPrev, vMaxPrev;
	bool inLogPrev;

	//
	//  Properties of the Min and Max cells
	//
	vtkIdType lMinPrev, lMaxPrev;
	double xMinPrev[3], xMaxPrev[3];

	int component;
	//
	//  MTime for the last calculation of the histogram - need to keep track of it
	//  separately so that other changes to this class do not hide the change in the input data.
	//
	unsigned long myMTime;

};

#endif


