/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/

#include "iglobals.h"


void iDialogPopup::init()
{

    Text->setPaletteBackgroundColor(QColor(255,255,255));
    Text->setColor(QColor(0,0,0));
    Text->clear();
    
}


void iDialogPopup::showHelp(int v)
{
    static char *text[4] = { 
	"<b><font color=\"#0000FF\">Display mode</font></b><hr><b><font color=\"#0000FF\">Left button</font></b>: rotate the camera around its focal point.<br><b><font color=\"#0000FF\">[Ctrl]</font></b> key + <b><font color=\"#0000FF\">Left button</font></b>: rotate the camera around the Z-axis (axis perpendicular to the screen).<br><b><font color=\"#0000FF\">Middle button</font></b>: pan the camera .<br><b><font color=\"#0000FF\">Right button</font></b>: zoom the camera.<br><b><font color=\"#0000FF\">3</font></b> key: toggle into and out of stereo mode.<br><b><font color=\"#0000FF\">P</font></b> key: perform a pick operation.<br><b><font color=\"#0000FF\">R</font></b> key: reset the camera view along the current view direction.<br><b><font color=\"#0000FF\">S</font></b> key: modify the representation of all actors so that they are surfaces.<br><b><font color=\"#0000FF\">W</font></b> key: modify the representation of all actors so that they are wireframe.<br><b><font color=\"#0000FF\">U</font></b> key: dump the rendered image.<br><b><font color=\"#0000FF\">F</font></b> key: toggle the Full Screen mode on and off." ,
#ifndef I_VTK_VERSION_40
	"<b><font color=\"#0000FF\">Fly-by mode</font></b><hr><b><font color=\"#0000FF\">Left button</font></b>: forward motion.<br><b><font color=\"#0000FF\">Right button</font></b>: reverse motion.<br><b><font color=\"#0000FF\">[Shift]</font></b> key: accelerator in mouse and key modes.<br><b><font color=\"#0000FF\">[Ctrl]+[Shift]</font></b> keys: causes sidestep instead of steering.<br><b><font color=\"#0000FF\">+/-</font></b> keys: increase/deacrease normal speed.<br><b><font color=\"#0000FF\">U</font></b> key: dump the rendered image.",
#else
	"<b><font color=\"#0000FF\">Fly-by mode</font></b><hr><b><font color=\"#0000FF\">Left button</font></b>: forward motion.<br><b><font color=\"#0000FF\">Right button</font></b>: reverse motion.<br><b><font color=\"#0000FF\">Arrow</font></b> keys: steering (alternative to moving the mouse).<br><b><font color=\"#0000FF\">L</font></b> key: azimuthal scan.<br><b><font color=\"#0000FF\">[Ctrl]</font></b> key: causes sidestep instead of steering.<br><b><font color=\"#0000FF\">[Shift]</font></b> key: accelerator in mouse and key modes.<br><b><font color=\"#0000FF\">[Ctrl]+[Shift]</font></b> keys: roll in mouse and key modes.<br><b><font color=\"#0000FF\">U</font></b> key: dump the rendered image.",
#endif
	"<b><font color=\"#0000FF\">Measuring box mode</font></b><hr><b><font color=\"#0000FF\">Left button</font></b>: rotate the measuring box around its origin.<br><b><font color=\"#0000FF\">Middle button</font></b>: translate the measuring box in/out of screen.<br><b><font color=\"#0000FF\">Right button</font></b>: translate the measuring box along scene axes.<br><b><font color=\"#0000FF\">A/Z</font></b> keys: scale the measuring box down/up.<br><b><font color=\"#0000FF\">S/X</font></b> keys: adjust box opacity.<br><b><font color=\"#0000FF\">F</font></b> key: shift the camera focal point to the box center.<br><b><font color=\"#0000FF\">U</font></b> key: dump the rendered image.",
	"<b><font color=\"#0000FF\">Camera path mode</font></b><hr><b><font color=\"#0000FF\">Left button</font></b>: move a handle or the whole path.<br><b><font color=\"#0000FF\">Middle button</font></b>: move the path; +[Ctrl]: spin the path.<br><b><font color=\"#0000FF\">Right button</font></b>: scale the path.<br><b>Note:</b> if you seem unable to grab the line, change the number of steps slightly." };

    if(v>=0 && v<4) Text->setText(QString(text[v]));

}


