/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IVISUALOBJECTOBSERVER_H
#define IVISUALOBJECTOBSERVER_H

class vtkObject;

#include <vtkCommand.h>


#define IOBJECTTYPE_NONE	0
#define IOBJECTTYPE_SURF	1
#define IOBJECTTYPE_XSEC	2
#define IOBJECTTYPE_VOLV	3
#define IOBJECTTYPE_PART	4
#define IOBJECTTYPE_VECT	5
#define IOBJECTTYPE_TENS	6
#define IOBJECTTYPE_MARK	7

#define IDATATYPE_NONE	0
#define IDATATYPE_MESH	1
#define IDATATYPE_PART	2
#define IDATATYPE_VECT	3
#define IDATATYPE_TENS	4

//
//  This observer does not execute anything - it is just a place holder for object info
//
class iVisualObjectObserver : public vtkCommand
{

public:
	
	static iVisualObjectObserver *New();

	virtual void Execute(vtkObject *, unsigned long, void *){}

	inline int getObjectType(){ return objectType; }
	inline int getDataType(){ return dataType; }
	inline float getUserValue(){ return userValue; }
	virtual void setTypes(int object, int data);
	virtual void setUserValue(float val);

protected:

	iVisualObjectObserver();

private:

	int objectType, dataType;
	float userValue;
	bool typesSet;

};


#endif // IVISUALOBJECTTYPEOBSERVER_H

