/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/**********************************************************************
*
*  Class for displaying vector (3D) text in VTK
*
***********************************************************************/


#ifndef ITEXTACTOR_H
#define ITEXTACTOR_H

class vtkProp;


#include "itextbitmap.h"
#include "itextvector.h"

#define ITEXT_BITMAP	0
#define ITEXT_VECTOR	1

#define __ITEXTACTOR_MAX		2


class iTextActor: public vtkProp 
{
	
public:
	
	static iTextActor *New(){ return new iTextActor; }
	
	inline int RenderOverlay(vtkViewport *v){ return itext[fontType]->RenderOverlay(v); }
	inline int RenderOpaqueGeometry(vtkViewport *v){ return itext[fontType]->RenderOpaqueGeometry(v); }
	
	inline void ReleaseGraphicsResources(vtkWindow *w);

	inline void getSize(vtkViewport *v, float s[2]){ itext[fontType]->getSize(v,s); }
	inline void getSize(float s[2]){ s[0] = itext[fontType]->getSize()[0]; s[1] = itext[fontType]->getSize()[1]; }

	inline void setFontType(int s){ if(s>=0 && s<__ITEXTACTOR_MAX) fontType = s; }
	inline int getFontType(){ return fontType; }

	virtual void setColor(float r, float g, float b){ for(int i=0; i<__ITEXTACTOR_MAX; i++) itext[i]->setColor(r,g,b); }
	virtual void setFontSize(int s){ for(int i=0; i<__ITEXTACTOR_MAX; i++) itext[i]->setFontSize(s); }
	virtual void setBold(bool s){ for(int i=0; i<__ITEXTACTOR_MAX; i++) itext[i]->setBold(s); }
	virtual void setHJustification(int s){ for(int i=0; i<__ITEXTACTOR_MAX; i++) itext[i]->setHJustification(s); }
	virtual void setVJustification(int s){ for(int i=0; i<__ITEXTACTOR_MAX; i++) itext[i]->setVJustification(s); }
	virtual void setPosition(float p[2]){ for(int i=0; i<__ITEXTACTOR_MAX; i++) itext[i]->setPosition(p); }
	virtual void setPosition(float p0, float p1){ for(int i=0; i<__ITEXTACTOR_MAX; i++) itext[i]->setPosition(p0,p1); }
	virtual void rotate(float a){ for(int i=0; i<__ITEXTACTOR_MAX; i++) itext[i]->rotate(a); }

	inline int getFontSize(){ return itext[0]->getFontSize(); }
	inline bool getBold(){ return itext[0]->getBold(); }
	inline float *getPosition(){ return itext[0]->getPosition(); }

	virtual void setText(char *t){ for(int i=0; i<__ITEXTACTOR_MAX; i++) itext[i]->setText(t);} 

protected:
	
	iTextActor();
	~iTextActor();
	
private:

	int fontType;

	iText *itext[__ITEXTACTOR_MAX];

};

#endif // ITEXTACTOR_H
