/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IMARKER_H
#define IMARKER_H


class vtkPolyData;
class vtkPolyDataMapper;
class iScaledLODActor;

class iCaption;

#include "ivisualobject.h"
#include "icolor.h"
#include "istring.h"


class iMarker : public iVisualObject 
{
	
	friend class iObjectFactory;

public:
	
	static iMarker* New(iVTK *m = 0);
	virtual ~iMarker();
	
	inline vtkPolyData* getMarkerObject(){ return markerObject; }
	inline iCaption* getMarkerCaption(){ return markerCaption; }

	virtual void setPosition(double *x);
	virtual double* getPosition();

	virtual void setAmbient(float v);
	virtual void setDiffuse(float v);
	virtual void setSpecular(float v);
	virtual void setSpecularPower(float v);

	inline int getMode(){ return mode; }
	inline char * getModeAsString(){ return modeName[mode]; }
	inline iColor getColor(){ return color; }
	inline iColor getTextColor(){ return textColor; }
	inline iString getCaption(){ return caption; }
	inline float getSize(){ return size; }
	inline float getOpacity(){ return opa; }
	inline bool isColorAutomatic(){ return colorAuto; }
	inline bool isCaptionShown(){ return showCaption; }

	virtual void setMode(int m);
	virtual void setColor(iColor c);
	virtual void setTextColor(iColor c, bool withAuto = true);
	virtual void setCaption(const iString &s);
	virtual void setSize(float s);
	virtual void setOpacity(float s);
	virtual void setShowCaption(bool s);
	
	virtual void setFontSize(int s);

	virtual void show(bool s);
	virtual bool isVisible();
	
	virtual void showClipPlane(bool){ }
	virtual void showColorBars(bool){ }
	virtual void reset(){}
	virtual float getMemorySize(){ return 0.0; }

	virtual void packState(iString &s);
	virtual void unpackState(iString s);

protected:
	
	iMarker(iVTK *m = 0);

	static char* modeName[7];
	
	//
	//  VTK stuff
	//
	iScaledLODActor *markerActor;	
	vtkPolyDataMapper *markerMapper;
	vtkPolyData *markerObject;
	iCaption *markerCaption;

	double pos[3];
	int mode;
	float size, opa;
	iColor color, textColor;
	iString caption;
	bool colorAuto, showCaption;

};

#endif // IMARKER_H

