/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iglobals.h"
#include "idialogeventrecorder.h"

#include "iqtdefs.h"
#include "ivtk.h"
#include "ivtkwindow.h"
#include "ienvironment.h"


#include <qapplication.h>
#include <qcheckbox.h>
#include <qfiledialog.h>
#include <qlcdnumber.h>
#include <qlineedit.h>
#include <qpixmap.h>
#include <qtoolbutton.h>


#ifndef I_VTK_VERSION_40
#include <iinteractoreventrecorder.h>
#endif


QPixmap image(char *);


void iDialogEventRecorder::init()
{

    RecordToolButton->setPixmap(image("er_rec.png"));
    PlayToolButton->setPixmap(image("er_play.png"));
    RewindToolButton->setPixmap(image("er_rew.png"));
    StopToolButton->setPixmap(image("er_stop.png"));
	
    RecordToolButton->setEnabled(false);
    PlayToolButton->setEnabled(false);
    RewindToolButton->setEnabled(false);
    StopToolButton->setEnabled(false);
	
	currentFileName = "";
	mode = 0;

}


void iDialogEventRecorder::destroy()
{
}


void iDialogEventRecorder::setFile()
{
#ifndef I_VTK_VERSION_40

	QString s1 = currentFileName;
	if(s1.isEmpty()) s1 = iEnvironment::getInstance()->get_IFRIT_RECORD_DIR();
    QString s = QFileDialog::getSaveFileName(s1,
		"IFRIT event record (*.ier)",
		this,
		"open IFRIT event record",
		"Choose a file" );

	if(!s.isEmpty()) setFile(s);
#endif
}


void iDialogEventRecorder::setFile(QString s)
{
#ifndef I_VTK_VERSION_40
	
	if(s.isEmpty()) return;

	QFile f(s);
	if(f.exists() && f.open(IO_ReadWrite))
	{
		//
		//  Opened for playing/recording
		//
		SetFileLineEdit->setText(s);
		f.close();
		iVTKWindow::getCurrentWindow()->getEventRecorder()->SetFileName(s.latin1());		

		PlayToolButton->setEnabled(true);
		RecordToolButton->setEnabled(true);
		
	}
	else if(f.open(IO_WriteOnly))
	{
		//
		//  Opened for recording
		//
		SetFileLineEdit->setText(s);
		f.close();
		iVTKWindow::getCurrentWindow()->getEventRecorder()->SetFileName(s.latin1());		
		
		PlayToolButton->setEnabled(false);
		RecordToolButton->setEnabled(true);
		
	}
#endif
}


void iDialogEventRecorder::dumpImages(bool vtkNotUsed(s))
{
#ifndef I_VTK_VERSION_40
#endif
}


void iDialogEventRecorder::play(bool s)
{
#ifndef I_VTK_VERSION_40
	if(iVTKWindow::getCurrentWindow()->getEventRecorder()!=0 && s)
	{
	    PlayToolButton->setPixmap(image("er_playon.png"));
	    PlayToolButton->repaint();
		RecordToolButton->setEnabled(false);
		RewindToolButton->setEnabled(false);
		StopToolButton->setEnabled(true);

		mode = 1;
		iVTKWindow::getCurrentWindow()->getEventRecorder()->Play();

		mode = 0;
		RecordToolButton->setEnabled(true);
		RewindToolButton->setEnabled(true);
		StopToolButton->setEnabled(false);
		CALL_FUNCTION1(PlayToolButton,setOn,false);
	    PlayToolButton->setPixmap(image("er_play.png"));
	}

	if(!s) CALL_FUNCTION1(PlayToolButton,setOn,true);
#endif
}


void iDialogEventRecorder::record(bool s)
{
#ifndef I_VTK_VERSION_40
	if(iVTKWindow::getCurrentWindow()->getEventRecorder()!=0 && s)
	{
		RecordToolButton->setPixmap(image("er_recon.png"));
		PlayToolButton->setEnabled(false);
		StopToolButton->setEnabled(true);

		mode = 2;
		iVTKWindow::getCurrentWindow()->getEventRecorder()->Record();
	}

	if(!s) CALL_FUNCTION1(RecordToolButton,setOn,true);
#endif
}


void iDialogEventRecorder::rewind()
{
#ifndef I_VTK_VERSION_40
	if(iVTKWindow::getCurrentWindow()->getEventRecorder() != 0)
	{
		CurrentFrameLCD->display(0);
		iVTKWindow::getCurrentWindow()->getEventRecorder()->Rewind();
		RewindToolButton->setEnabled(false);
	}
#endif
}


void iDialogEventRecorder::stop()
{
#ifndef I_VTK_VERSION_40
	if(iVTKWindow::getCurrentWindow()->getEventRecorder() != 0)
	{
		//
		//  Stop if playing
		//
		if(mode == 2)
		{
			PlayToolButton->setEnabled(true);
			RewindToolButton->setEnabled(true);
			CALL_FUNCTION1(RecordToolButton,setOn,false);
			RecordToolButton->setPixmap(image("er_rec.png"));
		}
		mode = 0;
		StopToolButton->setEnabled(false);
		iVTKWindow::getCurrentWindow()->getEventRecorder()->Stop();
	}
#endif
}


void iDialogEventRecorder::show()
{
#ifndef I_VTK_VERSION_40
	if(iVTKWindow::getCurrentWindow()->getEventRecorder() != 0)
	{
		setFile(QString(iVTKWindow::getCurrentWindow()->getEventRecorder()->GetFileName()));
		QDialog::show();
	}
#endif
}


void iDialogEventRecorder::updateInteraction()
{

	if(mode == 0) return;

	switch(mode)
	{
	case 1:
		{
			CurrentFrameLCD->display(CurrentFrameLCD->value()+1);
			if(DumpImageCheckBox->isChecked()) iVTKWindow::getCurrentWindow()->dumpImage(1);
			break;
		}
	case 2:
		{
			CurrentFrameLCD->display(CurrentFrameLCD->value()+1);
			break;
		}
	}
	qApp->flush();
//	qApp->processEvents();

}

