/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qimage.h>
#include <qpixmap.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qtextedit.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qapplication.h>
#include <qaccel.h>
#include <qtextstream.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qwhatsthis.h>
#include <qprogressbar.h>

#include "ifpinterface.h"
#include "radiofreqdlg.h"
#include "revision.h"
#include "ifp_gui.h"

ifp_gui::ifp_gui()
      : QMainWindow( 0, "ifpgui", WDestructiveClose ),
      m_view( new ifpGUIView( this ))
   {
   QPixmap openIcon, saveIcon, printIcon;
   bool autoConvert;
   int  viewAlignment, menu_id;

   //resize( 640, 480 );
   setIcon(QPixmap::fromMimeSource("music.png"));
   file = new QPopupMenu( this );
   menuBar()->insertItem( tr("&File"), file );

   menu_id = file->insertItem(QPixmap::fromMimeSource("newfolder.png"),
                              tr("&New Folder"), this, SLOT(create_directory()), CTRL+Key_N);
   menu_id = file->insertItem(QPixmap::fromMimeSource("delete.png"),
                              tr("&Delete"), this, SLOT(delete_file()), Key_Delete);
   menu_id = file->insertItem(QPixmap::fromMimeSource("rename.png"),
                              tr("&Rename"), this, SLOT(rename_file()), Key_F2);
   menu_id = file->insertItem(QPixmap::fromMimeSource("properties.png"),
                              tr("&Properties"), this, SLOT(file_properties()));
   file->insertSeparator();
   file->insertItem(tr("E&xit"), qApp, SLOT(closeAllWindows()), ALT+Key_X);

   view = new QPopupMenu( this );
   menuBar()->insertItem( tr("&View"), view );
   horizontalMenuID = view->insertItem(QPixmap::fromMimeSource("view_left_right.png"),
                                       tr("Align &Left-Right"), this, SLOT(align_horizontal()));
   verticalMenuID   = view->insertItem(QPixmap::fromMimeSource("view_top_bottom.png"),
                                       tr("Align &Top-Bottom"), this, SLOT(align_vertical()));
   viewAlignment    = m_view->guiSettings->getViewAlignment();
   if (viewAlignment == Qt::Vertical)
      {
      align_vertical();
      }
   else
      {
      align_horizontal();
      }

   options = new QPopupMenu( this );
   menuBar()->insertItem( tr("&Tools"), options );
   options->insertItem(tr("&Upload Playlist"), this, SLOT(uploadPlayList()), CTRL+Key_U);
   autoConvertMenuID = options->insertItem(
                       tr("&Auto-Convert REC files to MP3"),
                       this,
                       SLOT(auto_convert()),
                       CTRL+Key_A);
   autoConvert = m_view->guiSettings->getAutoConvertREC();
   options->setItemChecked(autoConvertMenuID, autoConvert);
   options->insertItem(tr("&Tuner Settings"), this, SLOT(show_radiofreq_info()), CTRL+Key_T);
   options->insertSeparator();
   options->insertItem(tr("&Upgrade Firmware"), this, SLOT(updateFirware()));

   menuBar()->insertSeparator();

   help = new QPopupMenu( this );
   menuBar()->insertItem( tr("&Help"), help );

   help->insertItem(tr("&iFP Info"), this, SLOT(show_ifp_info()), CTRL+Key_F);
   help->insertSeparator();
   help->insertItem( tr("&About"), this, SLOT(about()), Key_F1 );
   help->insertItem( tr("About &Qt"), this, SLOT(aboutQt()) );
   help->insertSeparator();
   help->insertItem( tr("What's &This"), this, SLOT(whatsThis()), SHIFT+Key_F1 );

   // make m_view the central widget
   setCentralWidget(m_view);

   connect_timer = new QTimer(this);
   connect(connect_timer, SIGNAL(timeout()), this, SLOT(ifpConnect()));
   connect_timer->start(5000); // check every 5 seconds
   statusBar()->message( tr("Ready"), 2000 );
   }


ifp_gui::~ifp_gui()
   {
   }

void ifp_gui::ifpConnect()
   {
   int ret;

   if (ifp_dh == NULL)
      {
      statusBar()->message(tr("Not Connected - Try unplugging iRiver and reconnecting.  Then, double-click the root ('\\') directory in the iRiver Filesystem panel."), 3000);
      }
   else
      {
      if (m_view->isProcessing() == FALSE)
         {
         ret = m_view->updateStatus();
         if (ret >= 0)
            statusBar()->message(tr("iRiver Connected"), 10000);
         connect_timer->start(5000); // check every 5 seconds
         }
      else
         {
         connect_timer->start(500); // check every 1/2 seconds
         }
      }
   }


void ifp_gui::closeEvent( QCloseEvent* ce )
   {
   ce->accept();
   return;
   }

void ifp_gui::uploadPlayList()
   {
   m_view->uploadPlaylist();
   }

void ifp_gui::show_ifp_info()
   {
   char info_str[500];
   QString libLoaded, Message;

   if (ifp_dh == NULL)
      {
      showInfoMsgBox(tr("iFP GUI Device Info - Error"), tr(iFPNotConnectedMsg));
      return;
      }
   if (usingLibrary)
      libLoaded = tr("Using ") + ifpLibraryVersion;
   else
      {
      libLoaded  = tr("Using static ifp functions (ifplib not available).\r\n");
      libLoaded += tr("  static ifp functions equivelant to %1").arg(LibRevision);
      }
   ifpgui_ifp_device_info(&ifp_dev, info_str, 500);
   Message = tr(info_str) + "\n\n" + tr(libLoaded);
   showInfoMsgBox(tr("iFP GUI Device Info"), Message);
   }

void ifp_gui::show_radiofreq_info()
   {
   RadioFreqWindow *rfdialog;

   rfdialog = new RadioFreqWindow();
   rfdialog->setModal(TRUE);
   rfdialog->exec();
   delete rfdialog;
   }

void ifp_gui::about()
   {
   char info_str[500];
   QString msg;
   QString libLoaded;

   msg  = tr("This application can be used to interface\n");
   msg += tr("with an iRiver iFP device.\n\n");
   msg += tr("Revision: ") + AppRevision + "\n\n";
   msg += tr("please send feedback to ifpgui@gmail.com.\n\n\n");
   if (ifp_dh == NULL)
      {
      msg += tr("iFP Device Not Connected.");
      }
   else
      {
      ifpgui_ifp_device_info(&ifp_dev, info_str, 500);
      msg += QString(info_str);
      if (usingLibrary)
         libLoaded = tr("Using ") + ifpLibraryVersion;
      else
         {
         libLoaded  = tr("Using static ifp functions (ifplib not available).\r\n");
         libLoaded += tr("  static ifp functions equivelant to ") + LibRevision;
         }
      msg += "\n\n";
      msg += libLoaded;
      }
   showInfoMsgBox(tr("iFP GUI Application"), msg);
   }


void ifp_gui::aboutQt()
   {
   QMessageBox::aboutQt(this, tr("iFP GUI Application"));
   }


void ifp_gui::auto_convert()
   {
   bool autoConvert;

   autoConvert = m_view->guiSettings->getAutoConvertREC();
   autoConvert = !autoConvert;
   options->setItemChecked(autoConvertMenuID, autoConvert);
   m_view->guiSettings->setAutoConvertREC(autoConvert);
   }

void ifp_gui::create_directory(void)
   {
   m_view->create_directory();
   }

void ifp_gui::rename_file(void)
   {
   m_view->rename_file();
   }

void ifp_gui::delete_file(void)
   {
   m_view->delete_file();
   }

void ifp_gui::file_properties(void)
   {
   m_view->file_properties();
   }

void ifp_gui::align_horizontal(void)
   {
   m_view->align_horizontal();
   view->setItemChecked(horizontalMenuID, TRUE);
   view->setItemChecked(verticalMenuID, FALSE);
   m_view->guiSettings->setViewAlignment(Qt::Horizontal);
   }

void ifp_gui::align_vertical(void)
   {
   m_view->align_vertical();
   view->setItemChecked(horizontalMenuID, FALSE);
   view->setItemChecked(verticalMenuID, TRUE);
   m_view->guiSettings->setViewAlignment(Qt::Vertical);
   }

void ifp_gui::updateFirware(void)
   {
   m_view->UpdateFirware();
   }

