/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import com.sun.xml.rpc.client.ClientTransportFactory;
import com.sun.xml.rpc.client.StubBase;
import com.sun.xml.rpc.client.StubBase20;
import com.sun.xml.rpc.client.dii.CallInvokerImpl;
import com.sun.xml.rpc.client.dispatch.DispatchImpl;
import com.sun.xml.rpc.client.local.LocalClientTransportFactory;
import com.sun.xml.rpc.spi.runtime.Handler;
import com.sun.xml.rpc.spi.runtime.Tie;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.rmi.Remote;
import javax.xml.rpc.Dispatch;
import javax.xml.rpc.Stub;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;
import testutil.HTTPResponseInfo;

public class ClientServerTestUtil {
    private boolean local = ClientServerTestUtil.useLocal();

    public static boolean useLocal() {
        return Boolean.getBoolean("uselocal");
    }

    public void setTransport(StubBase stubBase, String string, String string2) throws Exception {
        this.setTransport(stubBase, string, string2, null);
    }

    public void setTransport(StubBase20 stubBase20, String string, String string2) throws Exception {
        this.setTransport(stubBase20, string, string2, null);
    }

    public void setTransport(String string, String string2) throws Exception {
        this.setTransport(string, string2, null);
    }

    public void setTransport(String string, String string2, OutputStream outputStream) throws Exception {
        if (!this.local) {
            return;
        }
        Tie tie = (Tie)Class.forName(string).newInstance();
        Remote remote = (Remote)Class.forName(string2).newInstance();
        tie.setTarget(remote);
        CallInvokerImpl.setDefaultTransportFactory((ClientTransportFactory)new LocalClientTransportFactory((Handler)tie, outputStream));
    }

    public void setTransport(Dispatch dispatch, String string, String string2, OutputStream outputStream) throws Exception {
        if (!this.local) {
            return;
        }
        Tie tie = (Tie)Class.forName(string).newInstance();
        Remote remote = (Remote)Class.forName(string2).newInstance();
        tie.setTarget(remote);
        DispatchImpl.setDefaultTransportFactory((ClientTransportFactory)new LocalClientTransportFactory((Handler)tie, outputStream));
    }

    public void setTransport(Object object, String string, String string2, OutputStream outputStream) throws Exception {
        if (!this.local) {
            return;
        }
        System.out.println("configuring local client transport on stub " + object);
        Tie tie = (Tie)Class.forName(string).newInstance();
        Remote remote = (Remote)Class.forName(string2).newInstance();
        tie.setTarget(remote);
        if (object instanceof StubBase) {
            ((StubBase)object)._setTransportFactory((ClientTransportFactory)new LocalClientTransportFactory((Handler)tie, outputStream));
        } else if (object instanceof StubBase20) {
            ((StubBase20)object)._setTransportFactory((ClientTransportFactory)new LocalClientTransportFactory((Handler)tie, outputStream));
        } else {
            System.out.println("*** Unknown Stub ***");
        }
    }

    public static HTTPResponseInfo sendPOSTRequest(String string, String string2) throws Exception {
        InputStream inputStream;
        byte[] byArray = string2.getBytes();
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("HTTP-Version", "HTTP/1.1");
        httpURLConnection.setRequestProperty("Content-Type", "text/xml");
        httpURLConnection.setRequestProperty("SOAPAction", "\"\"");
        httpURLConnection.setRequestProperty("Content-Length", String.valueOf(byArray.length));
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(byArray);
        boolean bl = true;
        int n = httpURLConnection.getResponseCode();
        if (n == 200) {
            bl = false;
        }
        String string3 = httpURLConnection.getResponseMessage();
        String string4 = null;
        InputStream inputStream2 = inputStream = !bl ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
        if (inputStream != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            String string5 = bufferedReader.readLine();
            while (string5 != null) {
                stringBuffer.append(string5);
                string5 = bufferedReader.readLine();
            }
            string4 = stringBuffer.toString();
        }
        httpURLConnection.disconnect();
        return new HTTPResponseInfo(n, string3, string4);
    }

    public static HTTPResponseInfo sendPOSTRequest(Stub stub, String string) throws Exception {
        String string2 = (String)stub._getProperty("javax.xml.rpc.service.endpoint.address");
        return ClientServerTestUtil.sendPOSTRequest(string2, string);
    }

    public static SOAPMessage makeSaajRequest(Stub stub, InputStream inputStream) throws Exception {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPConnectionFactory sOAPConnectionFactory = SOAPConnectionFactory.newInstance();
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.addHeader("Content-Type", "text/xml");
        SOAPMessage sOAPMessage = messageFactory.createMessage(mimeHeaders, inputStream);
        String string = (String)stub._getProperty("javax.xml.rpc.service.endpoint.address");
        URL uRL = new URL(string);
        return sOAPConnectionFactory.createConnection().call(sOAPMessage, (Object)uRL);
    }
}

