/*
 * SpanDSP - a series of DSP components for telephony
 *
 * complex_dds.c
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2003 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: complex_dds.c,v 1.13 2006/03/27 13:35:13 steveu Exp $
 */

/*! \file */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <inttypes.h>
#include <math.h>

#include "spandsp/telephony.h"
#include "spandsp/complex.h"
#include "spandsp/dds.h"

#define SLENK	    11
#define SINELEN     (1 << SLENK)

/* Precreating this table allows it to be in const memory, which might
   have some performance advantage. */
static const float sine_table[SINELEN] =
{
     0.00000000,
     0.00306796,
     0.00613588,
     0.00920375,
     0.01227154,
     0.01533921,
     0.01840673,
     0.02147408,
     0.02454123,
     0.02760815,
     0.03067480,
     0.03374117,
     0.03680722,
     0.03987293,
     0.04293826,
     0.04600318,
     0.04906767,
     0.05213170,
     0.05519524,
     0.05825826,
     0.06132074,
     0.06438263,
     0.06744392,
     0.07050457,
     0.07356456,
     0.07662386,
     0.07968244,
     0.08274026,
     0.08579731,
     0.08885355,
     0.09190896,
     0.09496350,
     0.09801714,
     0.10106986,
     0.10412163,
     0.10717242,
     0.11022221,
     0.11327095,
     0.11631863,
     0.11936521,
     0.12241068,
     0.12545498,
     0.12849811,
     0.13154003,
     0.13458071,
     0.13762012,
     0.14065824,
     0.14369503,
     0.14673047,
     0.14976453,
     0.15279719,
     0.15582840,
     0.15885814,
     0.16188639,
     0.16491312,
     0.16793829,
     0.17096189,
     0.17398387,
     0.17700422,
     0.18002290,
     0.18303989,
     0.18605515,
     0.18906866,
     0.19208040,
     0.19509032,
     0.19809841,
     0.20110463,
     0.20410897,
     0.20711138,
     0.21011184,
     0.21311032,
     0.21610680,
     0.21910124,
     0.22209362,
     0.22508391,
     0.22807208,
     0.23105811,
     0.23404196,
     0.23702361,
     0.24000302,
     0.24298018,
     0.24595505,
     0.24892761,
     0.25189782,
     0.25486566,
     0.25783110,
     0.26079412,
     0.26375468,
     0.26671276,
     0.26966833,
     0.27262136,
     0.27557182,
     0.27851969,
     0.28146494,
     0.28440754,
     0.28734746,
     0.29028468,
     0.29321916,
     0.29615089,
     0.29907983,
     0.30200595,
     0.30492923,
     0.30784964,
     0.31076715,
     0.31368174,
     0.31659338,
     0.31950203,
     0.32240768,
     0.32531029,
     0.32820984,
     0.33110631,
     0.33399965,
     0.33688985,
     0.33977688,
     0.34266072,
     0.34554132,
     0.34841868,
     0.35129276,
     0.35416353,
     0.35703096,
     0.35989504,
     0.36275572,
     0.36561300,
     0.36846683,
     0.37131719,
     0.37416406,
     0.37700741,
     0.37984721,
     0.38268343,
     0.38551605,
     0.38834505,
     0.39117038,
     0.39399204,
     0.39680999,
     0.39962420,
     0.40243465,
     0.40524131,
     0.40804416,
     0.41084317,
     0.41363831,
     0.41642956,
     0.41921689,
     0.42200027,
     0.42477968,
     0.42755509,
     0.43032648,
     0.43309382,
     0.43585708,
     0.43861624,
     0.44137127,
     0.44412214,
     0.44686884,
     0.44961133,
     0.45234959,
     0.45508359,
     0.45781330,
     0.46053871,
     0.46325978,
     0.46597650,
     0.46868882,
     0.47139674,
     0.47410021,
     0.47679923,
     0.47949376,
     0.48218377,
     0.48486925,
     0.48755016,
     0.49022648,
     0.49289819,
     0.49556526,
     0.49822767,
     0.50088538,
     0.50353838,
     0.50618665,
     0.50883014,
     0.51146885,
     0.51410274,
     0.51673180,
     0.51935599,
     0.52197529,
     0.52458968,
     0.52719913,
     0.52980362,
     0.53240313,
     0.53499762,
     0.53758708,
     0.54017147,
     0.54275078,
     0.54532499,
     0.54789406,
     0.55045797,
     0.55301671,
     0.55557023,
     0.55811853,
     0.56066158,
     0.56319934,
     0.56573181,
     0.56825895,
     0.57078075,
     0.57329717,
     0.57580819,
     0.57831380,
     0.58081396,
     0.58330865,
     0.58579786,
     0.58828155,
     0.59075970,
     0.59323230,
     0.59569930,
     0.59816071,
     0.60061648,
     0.60306660,
     0.60551104,
     0.60794978,
     0.61038281,
     0.61281008,
     0.61523159,
     0.61764731,
     0.62005721,
     0.62246128,
     0.62485949,
     0.62725182,
     0.62963824,
     0.63201874,
     0.63439328,
     0.63676186,
     0.63912444,
     0.64148101,
     0.64383154,
     0.64617601,
     0.64851440,
     0.65084668,
     0.65317284,
     0.65549285,
     0.65780669,
     0.66011434,
     0.66241578,
     0.66471098,
     0.66699992,
     0.66928259,
     0.67155895,
     0.67382900,
     0.67609270,
     0.67835004,
     0.68060100,
     0.68284555,
     0.68508367,
     0.68731534,
     0.68954054,
     0.69175926,
     0.69397146,
     0.69617713,
     0.69837625,
     0.70056879,
     0.70275474,
     0.70493408,
     0.70710678,
     0.70927283,
     0.71143220,
     0.71358487,
     0.71573083,
     0.71787005,
     0.72000251,
     0.72212819,
     0.72424708,
     0.72635916,
     0.72846439,
     0.73056277,
     0.73265427,
     0.73473888,
     0.73681657,
     0.73888732,
     0.74095113,
     0.74300795,
     0.74505779,
     0.74710061,
     0.74913639,
     0.75116513,
     0.75318680,
     0.75520138,
     0.75720885,
     0.75920919,
     0.76120239,
     0.76318842,
     0.76516727,
     0.76713891,
     0.76910334,
     0.77106052,
     0.77301045,
     0.77495311,
     0.77688847,
     0.77881651,
     0.78073723,
     0.78265060,
     0.78455660,
     0.78645521,
     0.78834643,
     0.79023022,
     0.79210658,
     0.79397548,
     0.79583690,
     0.79769084,
     0.79953727,
     0.80137617,
     0.80320753,
     0.80503133,
     0.80684755,
     0.80865618,
     0.81045720,
     0.81225059,
     0.81403633,
     0.81581441,
     0.81758481,
     0.81934752,
     0.82110251,
     0.82284978,
     0.82458930,
     0.82632106,
     0.82804505,
     0.82976123,
     0.83146961,
     0.83317016,
     0.83486287,
     0.83654773,
     0.83822471,
     0.83989379,
     0.84155498,
     0.84320824,
     0.84485357,
     0.84649094,
     0.84812034,
     0.84974177,
     0.85135519,
     0.85296060,
     0.85455799,
     0.85614733,
     0.85772861,
     0.85930182,
     0.86086694,
     0.86242396,
     0.86397286,
     0.86551362,
     0.86704625,
     0.86857071,
     0.87008699,
     0.87159509,
     0.87309498,
     0.87458665,
     0.87607009,
     0.87754529,
     0.87901223,
     0.88047089,
     0.88192126,
     0.88336334,
     0.88479710,
     0.88622253,
     0.88763962,
     0.88904836,
     0.89044872,
     0.89184071,
     0.89322430,
     0.89459949,
     0.89596625,
     0.89732458,
     0.89867447,
     0.90001589,
     0.90134885,
     0.90267332,
     0.90398929,
     0.90529676,
     0.90659570,
     0.90788612,
     0.90916798,
     0.91044129,
     0.91170603,
     0.91296219,
     0.91420976,
     0.91544872,
     0.91667906,
     0.91790078,
     0.91911385,
     0.92031828,
     0.92151404,
     0.92270113,
     0.92387953,
     0.92504924,
     0.92621024,
     0.92736253,
     0.92850608,
     0.92964090,
     0.93076696,
     0.93188427,
     0.93299280,
     0.93409255,
     0.93518351,
     0.93626567,
     0.93733901,
     0.93840353,
     0.93945922,
     0.94050607,
     0.94154407,
     0.94257320,
     0.94359346,
     0.94460484,
     0.94560733,
     0.94660091,
     0.94758559,
     0.94856135,
     0.94952818,
     0.95048607,
     0.95143502,
     0.95237501,
     0.95330604,
     0.95422810,
     0.95514117,
     0.95604525,
     0.95694034,
     0.95782641,
     0.95870347,
     0.95957151,
     0.96043052,
     0.96128049,
     0.96212140,
     0.96295327,
     0.96377607,
     0.96458979,
     0.96539444,
     0.96619000,
     0.96697647,
     0.96775384,
     0.96852209,
     0.96928124,
     0.97003125,
     0.97077214,
     0.97150389,
     0.97222650,
     0.97293995,
     0.97364425,
     0.97433938,
     0.97502535,
     0.97570213,
     0.97636973,
     0.97702814,
     0.97767736,
     0.97831737,
     0.97894818,
     0.97956977,
     0.98018214,
     0.98078528,
     0.98137919,
     0.98196387,
     0.98253930,
     0.98310549,
     0.98366242,
     0.98421009,
     0.98474850,
     0.98527764,
     0.98579751,
     0.98630810,
     0.98680940,
     0.98730142,
     0.98778414,
     0.98825757,
     0.98872169,
     0.98917651,
     0.98962202,
     0.99005821,
     0.99048508,
     0.99090264,
     0.99131086,
     0.99170975,
     0.99209931,
     0.99247953,
     0.99285041,
     0.99321195,
     0.99356414,
     0.99390697,
     0.99424045,
     0.99456457,
     0.99487933,
     0.99518473,
     0.99548076,
     0.99576741,
     0.99604470,
     0.99631261,
     0.99657115,
     0.99682030,
     0.99706007,
     0.99729046,
     0.99751146,
     0.99772307,
     0.99792529,
     0.99811811,
     0.99830154,
     0.99847558,
     0.99864022,
     0.99879546,
     0.99894129,
     0.99907773,
     0.99920476,
     0.99932238,
     0.99943060,
     0.99952942,
     0.99961882,
     0.99969882,
     0.99976941,
     0.99983058,
     0.99988235,
     0.99992470,
     0.99995764,
     0.99998118,
     0.99999529,
     1.00000000,
     0.99999529,
     0.99998118,
     0.99995764,
     0.99992470,
     0.99988235,
     0.99983058,
     0.99976941,
     0.99969882,
     0.99961882,
     0.99952942,
     0.99943060,
     0.99932238,
     0.99920476,
     0.99907773,
     0.99894129,
     0.99879546,
     0.99864022,
     0.99847558,
     0.99830154,
     0.99811811,
     0.99792529,
     0.99772307,
     0.99751146,
     0.99729046,
     0.99706007,
     0.99682030,
     0.99657115,
     0.99631261,
     0.99604470,
     0.99576741,
     0.99548076,
     0.99518473,
     0.99487933,
     0.99456457,
     0.99424045,
     0.99390697,
     0.99356414,
     0.99321195,
     0.99285041,
     0.99247953,
     0.99209931,
     0.99170975,
     0.99131086,
     0.99090264,
     0.99048508,
     0.99005821,
     0.98962202,
     0.98917651,
     0.98872169,
     0.98825757,
     0.98778414,
     0.98730142,
     0.98680940,
     0.98630810,
     0.98579751,
     0.98527764,
     0.98474850,
     0.98421009,
     0.98366242,
     0.98310549,
     0.98253930,
     0.98196387,
     0.98137919,
     0.98078528,
     0.98018214,
     0.97956977,
     0.97894818,
     0.97831737,
     0.97767736,
     0.97702814,
     0.97636973,
     0.97570213,
     0.97502535,
     0.97433938,
     0.97364425,
     0.97293995,
     0.97222650,
     0.97150389,
     0.97077214,
     0.97003125,
     0.96928124,
     0.96852209,
     0.96775384,
     0.96697647,
     0.96619000,
     0.96539444,
     0.96458979,
     0.96377607,
     0.96295327,
     0.96212140,
     0.96128049,
     0.96043052,
     0.95957151,
     0.95870347,
     0.95782641,
     0.95694034,
     0.95604525,
     0.95514117,
     0.95422810,
     0.95330604,
     0.95237501,
     0.95143502,
     0.95048607,
     0.94952818,
     0.94856135,
     0.94758559,
     0.94660091,
     0.94560733,
     0.94460484,
     0.94359346,
     0.94257320,
     0.94154407,
     0.94050607,
     0.93945922,
     0.93840353,
     0.93733901,
     0.93626567,
     0.93518351,
     0.93409255,
     0.93299280,
     0.93188427,
     0.93076696,
     0.92964090,
     0.92850608,
     0.92736253,
     0.92621024,
     0.92504924,
     0.92387953,
     0.92270113,
     0.92151404,
     0.92031828,
     0.91911385,
     0.91790078,
     0.91667906,
     0.91544872,
     0.91420976,
     0.91296219,
     0.91170603,
     0.91044129,
     0.90916798,
     0.90788612,
     0.90659570,
     0.90529676,
     0.90398929,
     0.90267332,
     0.90134885,
     0.90001589,
     0.89867447,
     0.89732458,
     0.89596625,
     0.89459949,
     0.89322430,
     0.89184071,
     0.89044872,
     0.88904836,
     0.88763962,
     0.88622253,
     0.88479710,
     0.88336334,
     0.88192126,
     0.88047089,
     0.87901223,
     0.87754529,
     0.87607009,
     0.87458665,
     0.87309498,
     0.87159509,
     0.87008699,
     0.86857071,
     0.86704625,
     0.86551362,
     0.86397286,
     0.86242396,
     0.86086694,
     0.85930182,
     0.85772861,
     0.85614733,
     0.85455799,
     0.85296060,
     0.85135519,
     0.84974177,
     0.84812034,
     0.84649094,
     0.84485357,
     0.84320824,
     0.84155498,
     0.83989379,
     0.83822471,
     0.83654773,
     0.83486287,
     0.83317016,
     0.83146961,
     0.82976123,
     0.82804505,
     0.82632106,
     0.82458930,
     0.82284978,
     0.82110251,
     0.81934752,
     0.81758481,
     0.81581441,
     0.81403633,
     0.81225059,
     0.81045720,
     0.80865618,
     0.80684755,
     0.80503133,
     0.80320753,
     0.80137617,
     0.79953727,
     0.79769084,
     0.79583690,
     0.79397548,
     0.79210658,
     0.79023022,
     0.78834643,
     0.78645521,
     0.78455660,
     0.78265060,
     0.78073723,
     0.77881651,
     0.77688847,
     0.77495311,
     0.77301045,
     0.77106052,
     0.76910334,
     0.76713891,
     0.76516727,
     0.76318842,
     0.76120239,
     0.75920919,
     0.75720885,
     0.75520138,
     0.75318680,
     0.75116513,
     0.74913639,
     0.74710061,
     0.74505779,
     0.74300795,
     0.74095113,
     0.73888732,
     0.73681657,
     0.73473888,
     0.73265427,
     0.73056277,
     0.72846439,
     0.72635916,
     0.72424708,
     0.72212819,
     0.72000251,
     0.71787005,
     0.71573083,
     0.71358487,
     0.71143220,
     0.70927283,
     0.70710678,
     0.70493408,
     0.70275474,
     0.70056879,
     0.69837625,
     0.69617713,
     0.69397146,
     0.69175926,
     0.68954054,
     0.68731534,
     0.68508367,
     0.68284555,
     0.68060100,
     0.67835004,
     0.67609270,
     0.67382900,
     0.67155895,
     0.66928259,
     0.66699992,
     0.66471098,
     0.66241578,
     0.66011434,
     0.65780669,
     0.65549285,
     0.65317284,
     0.65084668,
     0.64851440,
     0.64617601,
     0.64383154,
     0.64148101,
     0.63912444,
     0.63676186,
     0.63439328,
     0.63201874,
     0.62963824,
     0.62725182,
     0.62485949,
     0.62246128,
     0.62005721,
     0.61764731,
     0.61523159,
     0.61281008,
     0.61038281,
     0.60794978,
     0.60551104,
     0.60306660,
     0.60061648,
     0.59816071,
     0.59569930,
     0.59323230,
     0.59075970,
     0.58828155,
     0.58579786,
     0.58330865,
     0.58081396,
     0.57831380,
     0.57580819,
     0.57329717,
     0.57078075,
     0.56825895,
     0.56573181,
     0.56319934,
     0.56066158,
     0.55811853,
     0.55557023,
     0.55301671,
     0.55045797,
     0.54789406,
     0.54532499,
     0.54275078,
     0.54017147,
     0.53758708,
     0.53499762,
     0.53240313,
     0.52980362,
     0.52719913,
     0.52458968,
     0.52197529,
     0.51935599,
     0.51673180,
     0.51410274,
     0.51146885,
     0.50883014,
     0.50618665,
     0.50353838,
     0.50088538,
     0.49822767,
     0.49556526,
     0.49289819,
     0.49022648,
     0.48755016,
     0.48486925,
     0.48218377,
     0.47949376,
     0.47679923,
     0.47410021,
     0.47139674,
     0.46868882,
     0.46597650,
     0.46325978,
     0.46053871,
     0.45781330,
     0.45508359,
     0.45234959,
     0.44961133,
     0.44686884,
     0.44412214,
     0.44137127,
     0.43861624,
     0.43585708,
     0.43309382,
     0.43032648,
     0.42755509,
     0.42477968,
     0.42200027,
     0.41921689,
     0.41642956,
     0.41363831,
     0.41084317,
     0.40804416,
     0.40524131,
     0.40243465,
     0.39962420,
     0.39680999,
     0.39399204,
     0.39117038,
     0.38834505,
     0.38551605,
     0.38268343,
     0.37984721,
     0.37700741,
     0.37416406,
     0.37131719,
     0.36846683,
     0.36561300,
     0.36275572,
     0.35989504,
     0.35703096,
     0.35416353,
     0.35129276,
     0.34841868,
     0.34554132,
     0.34266072,
     0.33977688,
     0.33688985,
     0.33399965,
     0.33110631,
     0.32820984,
     0.32531029,
     0.32240768,
     0.31950203,
     0.31659338,
     0.31368174,
     0.31076715,
     0.30784964,
     0.30492923,
     0.30200595,
     0.29907983,
     0.29615089,
     0.29321916,
     0.29028468,
     0.28734746,
     0.28440754,
     0.28146494,
     0.27851969,
     0.27557182,
     0.27262136,
     0.26966833,
     0.26671276,
     0.26375468,
     0.26079412,
     0.25783110,
     0.25486566,
     0.25189782,
     0.24892761,
     0.24595505,
     0.24298018,
     0.24000302,
     0.23702361,
     0.23404196,
     0.23105811,
     0.22807208,
     0.22508391,
     0.22209362,
     0.21910124,
     0.21610680,
     0.21311032,
     0.21011184,
     0.20711138,
     0.20410897,
     0.20110463,
     0.19809841,
     0.19509032,
     0.19208040,
     0.18906866,
     0.18605515,
     0.18303989,
     0.18002290,
     0.17700422,
     0.17398387,
     0.17096189,
     0.16793829,
     0.16491312,
     0.16188639,
     0.15885814,
     0.15582840,
     0.15279719,
     0.14976453,
     0.14673047,
     0.14369503,
     0.14065824,
     0.13762012,
     0.13458071,
     0.13154003,
     0.12849811,
     0.12545498,
     0.12241068,
     0.11936521,
     0.11631863,
     0.11327095,
     0.11022221,
     0.10717242,
     0.10412163,
     0.10106986,
     0.09801714,
     0.09496350,
     0.09190896,
     0.08885355,
     0.08579731,
     0.08274026,
     0.07968244,
     0.07662386,
     0.07356456,
     0.07050457,
     0.06744392,
     0.06438263,
     0.06132074,
     0.05825826,
     0.05519524,
     0.05213170,
     0.04906767,
     0.04600318,
     0.04293826,
     0.03987293,
     0.03680722,
     0.03374117,
     0.03067480,
     0.02760815,
     0.02454123,
     0.02147408,
     0.01840673,
     0.01533921,
     0.01227154,
     0.00920375,
     0.00613588,
     0.00306796,
     0.00000000,
    -0.00306796,
    -0.00613588,
    -0.00920375,
    -0.01227154,
    -0.01533921,
    -0.01840673,
    -0.02147408,
    -0.02454123,
    -0.02760815,
    -0.03067480,
    -0.03374117,
    -0.03680722,
    -0.03987293,
    -0.04293826,
    -0.04600318,
    -0.04906767,
    -0.05213170,
    -0.05519524,
    -0.05825826,
    -0.06132074,
    -0.06438263,
    -0.06744392,
    -0.07050457,
    -0.07356456,
    -0.07662386,
    -0.07968244,
    -0.08274026,
    -0.08579731,
    -0.08885355,
    -0.09190896,
    -0.09496350,
    -0.09801714,
    -0.10106986,
    -0.10412163,
    -0.10717242,
    -0.11022221,
    -0.11327095,
    -0.11631863,
    -0.11936521,
    -0.12241068,
    -0.12545498,
    -0.12849811,
    -0.13154003,
    -0.13458071,
    -0.13762012,
    -0.14065824,
    -0.14369503,
    -0.14673047,
    -0.14976453,
    -0.15279719,
    -0.15582840,
    -0.15885814,
    -0.16188639,
    -0.16491312,
    -0.16793829,
    -0.17096189,
    -0.17398387,
    -0.17700422,
    -0.18002290,
    -0.18303989,
    -0.18605515,
    -0.18906866,
    -0.19208040,
    -0.19509032,
    -0.19809841,
    -0.20110463,
    -0.20410897,
    -0.20711138,
    -0.21011184,
    -0.21311032,
    -0.21610680,
    -0.21910124,
    -0.22209362,
    -0.22508391,
    -0.22807208,
    -0.23105811,
    -0.23404196,
    -0.23702361,
    -0.24000302,
    -0.24298018,
    -0.24595505,
    -0.24892761,
    -0.25189782,
    -0.25486566,
    -0.25783110,
    -0.26079412,
    -0.26375468,
    -0.26671276,
    -0.26966833,
    -0.27262136,
    -0.27557182,
    -0.27851969,
    -0.28146494,
    -0.28440754,
    -0.28734746,
    -0.29028468,
    -0.29321916,
    -0.29615089,
    -0.29907983,
    -0.30200595,
    -0.30492923,
    -0.30784964,
    -0.31076715,
    -0.31368174,
    -0.31659338,
    -0.31950203,
    -0.32240768,
    -0.32531029,
    -0.32820984,
    -0.33110631,
    -0.33399965,
    -0.33688985,
    -0.33977688,
    -0.34266072,
    -0.34554132,
    -0.34841868,
    -0.35129276,
    -0.35416353,
    -0.35703096,
    -0.35989504,
    -0.36275572,
    -0.36561300,
    -0.36846683,
    -0.37131719,
    -0.37416406,
    -0.37700741,
    -0.37984721,
    -0.38268343,
    -0.38551605,
    -0.38834505,
    -0.39117038,
    -0.39399204,
    -0.39680999,
    -0.39962420,
    -0.40243465,
    -0.40524131,
    -0.40804416,
    -0.41084317,
    -0.41363831,
    -0.41642956,
    -0.41921689,
    -0.42200027,
    -0.42477968,
    -0.42755509,
    -0.43032648,
    -0.43309382,
    -0.43585708,
    -0.43861624,
    -0.44137127,
    -0.44412214,
    -0.44686884,
    -0.44961133,
    -0.45234959,
    -0.45508359,
    -0.45781330,
    -0.46053871,
    -0.46325978,
    -0.46597650,
    -0.46868882,
    -0.47139674,
    -0.47410021,
    -0.47679923,
    -0.47949376,
    -0.48218377,
    -0.48486925,
    -0.48755016,
    -0.49022648,
    -0.49289819,
    -0.49556526,
    -0.49822767,
    -0.50088538,
    -0.50353838,
    -0.50618665,
    -0.50883014,
    -0.51146885,
    -0.51410274,
    -0.51673180,
    -0.51935599,
    -0.52197529,
    -0.52458968,
    -0.52719913,
    -0.52980362,
    -0.53240313,
    -0.53499762,
    -0.53758708,
    -0.54017147,
    -0.54275078,
    -0.54532499,
    -0.54789406,
    -0.55045797,
    -0.55301671,
    -0.55557023,
    -0.55811853,
    -0.56066158,
    -0.56319934,
    -0.56573181,
    -0.56825895,
    -0.57078075,
    -0.57329717,
    -0.57580819,
    -0.57831380,
    -0.58081396,
    -0.58330865,
    -0.58579786,
    -0.58828155,
    -0.59075970,
    -0.59323230,
    -0.59569930,
    -0.59816071,
    -0.60061648,
    -0.60306660,
    -0.60551104,
    -0.60794978,
    -0.61038281,
    -0.61281008,
    -0.61523159,
    -0.61764731,
    -0.62005721,
    -0.62246128,
    -0.62485949,
    -0.62725182,
    -0.62963824,
    -0.63201874,
    -0.63439328,
    -0.63676186,
    -0.63912444,
    -0.64148101,
    -0.64383154,
    -0.64617601,
    -0.64851440,
    -0.65084668,
    -0.65317284,
    -0.65549285,
    -0.65780669,
    -0.66011434,
    -0.66241578,
    -0.66471098,
    -0.66699992,
    -0.66928259,
    -0.67155895,
    -0.67382900,
    -0.67609270,
    -0.67835004,
    -0.68060100,
    -0.68284555,
    -0.68508367,
    -0.68731534,
    -0.68954054,
    -0.69175926,
    -0.69397146,
    -0.69617713,
    -0.69837625,
    -0.70056879,
    -0.70275474,
    -0.70493408,
    -0.70710678,
    -0.70927283,
    -0.71143220,
    -0.71358487,
    -0.71573083,
    -0.71787005,
    -0.72000251,
    -0.72212819,
    -0.72424708,
    -0.72635916,
    -0.72846439,
    -0.73056277,
    -0.73265427,
    -0.73473888,
    -0.73681657,
    -0.73888732,
    -0.74095113,
    -0.74300795,
    -0.74505779,
    -0.74710061,
    -0.74913639,
    -0.75116513,
    -0.75318680,
    -0.75520138,
    -0.75720885,
    -0.75920919,
    -0.76120239,
    -0.76318842,
    -0.76516727,
    -0.76713891,
    -0.76910334,
    -0.77106052,
    -0.77301045,
    -0.77495311,
    -0.77688847,
    -0.77881651,
    -0.78073723,
    -0.78265060,
    -0.78455660,
    -0.78645521,
    -0.78834643,
    -0.79023022,
    -0.79210658,
    -0.79397548,
    -0.79583690,
    -0.79769084,
    -0.79953727,
    -0.80137617,
    -0.80320753,
    -0.80503133,
    -0.80684755,
    -0.80865618,
    -0.81045720,
    -0.81225059,
    -0.81403633,
    -0.81581441,
    -0.81758481,
    -0.81934752,
    -0.82110251,
    -0.82284978,
    -0.82458930,
    -0.82632106,
    -0.82804505,
    -0.82976123,
    -0.83146961,
    -0.83317016,
    -0.83486287,
    -0.83654773,
    -0.83822471,
    -0.83989379,
    -0.84155498,
    -0.84320824,
    -0.84485357,
    -0.84649094,
    -0.84812034,
    -0.84974177,
    -0.85135519,
    -0.85296060,
    -0.85455799,
    -0.85614733,
    -0.85772861,
    -0.85930182,
    -0.86086694,
    -0.86242396,
    -0.86397286,
    -0.86551362,
    -0.86704625,
    -0.86857071,
    -0.87008699,
    -0.87159509,
    -0.87309498,
    -0.87458665,
    -0.87607009,
    -0.87754529,
    -0.87901223,
    -0.88047089,
    -0.88192126,
    -0.88336334,
    -0.88479710,
    -0.88622253,
    -0.88763962,
    -0.88904836,
    -0.89044872,
    -0.89184071,
    -0.89322430,
    -0.89459949,
    -0.89596625,
    -0.89732458,
    -0.89867447,
    -0.90001589,
    -0.90134885,
    -0.90267332,
    -0.90398929,
    -0.90529676,
    -0.90659570,
    -0.90788612,
    -0.90916798,
    -0.91044129,
    -0.91170603,
    -0.91296219,
    -0.91420976,
    -0.91544872,
    -0.91667906,
    -0.91790078,
    -0.91911385,
    -0.92031828,
    -0.92151404,
    -0.92270113,
    -0.92387953,
    -0.92504924,
    -0.92621024,
    -0.92736253,
    -0.92850608,
    -0.92964090,
    -0.93076696,
    -0.93188427,
    -0.93299280,
    -0.93409255,
    -0.93518351,
    -0.93626567,
    -0.93733901,
    -0.93840353,
    -0.93945922,
    -0.94050607,
    -0.94154407,
    -0.94257320,
    -0.94359346,
    -0.94460484,
    -0.94560733,
    -0.94660091,
    -0.94758559,
    -0.94856135,
    -0.94952818,
    -0.95048607,
    -0.95143502,
    -0.95237501,
    -0.95330604,
    -0.95422810,
    -0.95514117,
    -0.95604525,
    -0.95694034,
    -0.95782641,
    -0.95870347,
    -0.95957151,
    -0.96043052,
    -0.96128049,
    -0.96212140,
    -0.96295327,
    -0.96377607,
    -0.96458979,
    -0.96539444,
    -0.96619000,
    -0.96697647,
    -0.96775384,
    -0.96852209,
    -0.96928124,
    -0.97003125,
    -0.97077214,
    -0.97150389,
    -0.97222650,
    -0.97293995,
    -0.97364425,
    -0.97433938,
    -0.97502535,
    -0.97570213,
    -0.97636973,
    -0.97702814,
    -0.97767736,
    -0.97831737,
    -0.97894818,
    -0.97956977,
    -0.98018214,
    -0.98078528,
    -0.98137919,
    -0.98196387,
    -0.98253930,
    -0.98310549,
    -0.98366242,
    -0.98421009,
    -0.98474850,
    -0.98527764,
    -0.98579751,
    -0.98630810,
    -0.98680940,
    -0.98730142,
    -0.98778414,
    -0.98825757,
    -0.98872169,
    -0.98917651,
    -0.98962202,
    -0.99005821,
    -0.99048508,
    -0.99090264,
    -0.99131086,
    -0.99170975,
    -0.99209931,
    -0.99247953,
    -0.99285041,
    -0.99321195,
    -0.99356414,
    -0.99390697,
    -0.99424045,
    -0.99456457,
    -0.99487933,
    -0.99518473,
    -0.99548076,
    -0.99576741,
    -0.99604470,
    -0.99631261,
    -0.99657115,
    -0.99682030,
    -0.99706007,
    -0.99729046,
    -0.99751146,
    -0.99772307,
    -0.99792529,
    -0.99811811,
    -0.99830154,
    -0.99847558,
    -0.99864022,
    -0.99879546,
    -0.99894129,
    -0.99907773,
    -0.99920476,
    -0.99932238,
    -0.99943060,
    -0.99952942,
    -0.99961882,
    -0.99969882,
    -0.99976941,
    -0.99983058,
    -0.99988235,
    -0.99992470,
    -0.99995764,
    -0.99998118,
    -0.99999529,
    -1.00000000,
    -0.99999529,
    -0.99998118,
    -0.99995764,
    -0.99992470,
    -0.99988235,
    -0.99983058,
    -0.99976941,
    -0.99969882,
    -0.99961882,
    -0.99952942,
    -0.99943060,
    -0.99932238,
    -0.99920476,
    -0.99907773,
    -0.99894129,
    -0.99879546,
    -0.99864022,
    -0.99847558,
    -0.99830154,
    -0.99811811,
    -0.99792529,
    -0.99772307,
    -0.99751146,
    -0.99729046,
    -0.99706007,
    -0.99682030,
    -0.99657115,
    -0.99631261,
    -0.99604470,
    -0.99576741,
    -0.99548076,
    -0.99518473,
    -0.99487933,
    -0.99456457,
    -0.99424045,
    -0.99390697,
    -0.99356414,
    -0.99321195,
    -0.99285041,
    -0.99247953,
    -0.99209931,
    -0.99170975,
    -0.99131086,
    -0.99090264,
    -0.99048508,
    -0.99005821,
    -0.98962202,
    -0.98917651,
    -0.98872169,
    -0.98825757,
    -0.98778414,
    -0.98730142,
    -0.98680940,
    -0.98630810,
    -0.98579751,
    -0.98527764,
    -0.98474850,
    -0.98421009,
    -0.98366242,
    -0.98310549,
    -0.98253930,
    -0.98196387,
    -0.98137919,
    -0.98078528,
    -0.98018214,
    -0.97956977,
    -0.97894818,
    -0.97831737,
    -0.97767736,
    -0.97702814,
    -0.97636973,
    -0.97570213,
    -0.97502535,
    -0.97433938,
    -0.97364425,
    -0.97293995,
    -0.97222650,
    -0.97150389,
    -0.97077214,
    -0.97003125,
    -0.96928124,
    -0.96852209,
    -0.96775384,
    -0.96697647,
    -0.96619000,
    -0.96539444,
    -0.96458979,
    -0.96377607,
    -0.96295327,
    -0.96212140,
    -0.96128049,
    -0.96043052,
    -0.95957151,
    -0.95870347,
    -0.95782641,
    -0.95694034,
    -0.95604525,
    -0.95514117,
    -0.95422810,
    -0.95330604,
    -0.95237501,
    -0.95143502,
    -0.95048607,
    -0.94952818,
    -0.94856135,
    -0.94758559,
    -0.94660091,
    -0.94560733,
    -0.94460484,
    -0.94359346,
    -0.94257320,
    -0.94154407,
    -0.94050607,
    -0.93945922,
    -0.93840353,
    -0.93733901,
    -0.93626567,
    -0.93518351,
    -0.93409255,
    -0.93299280,
    -0.93188427,
    -0.93076696,
    -0.92964090,
    -0.92850608,
    -0.92736253,
    -0.92621024,
    -0.92504924,
    -0.92387953,
    -0.92270113,
    -0.92151404,
    -0.92031828,
    -0.91911385,
    -0.91790078,
    -0.91667906,
    -0.91544872,
    -0.91420976,
    -0.91296219,
    -0.91170603,
    -0.91044129,
    -0.90916798,
    -0.90788612,
    -0.90659570,
    -0.90529676,
    -0.90398929,
    -0.90267332,
    -0.90134885,
    -0.90001589,
    -0.89867447,
    -0.89732458,
    -0.89596625,
    -0.89459949,
    -0.89322430,
    -0.89184071,
    -0.89044872,
    -0.88904836,
    -0.88763962,
    -0.88622253,
    -0.88479710,
    -0.88336334,
    -0.88192126,
    -0.88047089,
    -0.87901223,
    -0.87754529,
    -0.87607009,
    -0.87458665,
    -0.87309498,
    -0.87159509,
    -0.87008699,
    -0.86857071,
    -0.86704625,
    -0.86551362,
    -0.86397286,
    -0.86242396,
    -0.86086694,
    -0.85930182,
    -0.85772861,
    -0.85614733,
    -0.85455799,
    -0.85296060,
    -0.85135519,
    -0.84974177,
    -0.84812034,
    -0.84649094,
    -0.84485357,
    -0.84320824,
    -0.84155498,
    -0.83989379,
    -0.83822471,
    -0.83654773,
    -0.83486287,
    -0.83317016,
    -0.83146961,
    -0.82976123,
    -0.82804505,
    -0.82632106,
    -0.82458930,
    -0.82284978,
    -0.82110251,
    -0.81934752,
    -0.81758481,
    -0.81581441,
    -0.81403633,
    -0.81225059,
    -0.81045720,
    -0.80865618,
    -0.80684755,
    -0.80503133,
    -0.80320753,
    -0.80137617,
    -0.79953727,
    -0.79769084,
    -0.79583690,
    -0.79397548,
    -0.79210658,
    -0.79023022,
    -0.78834643,
    -0.78645521,
    -0.78455660,
    -0.78265060,
    -0.78073723,
    -0.77881651,
    -0.77688847,
    -0.77495311,
    -0.77301045,
    -0.77106052,
    -0.76910334,
    -0.76713891,
    -0.76516727,
    -0.76318842,
    -0.76120239,
    -0.75920919,
    -0.75720885,
    -0.75520138,
    -0.75318680,
    -0.75116513,
    -0.74913639,
    -0.74710061,
    -0.74505779,
    -0.74300795,
    -0.74095113,
    -0.73888732,
    -0.73681657,
    -0.73473888,
    -0.73265427,
    -0.73056277,
    -0.72846439,
    -0.72635916,
    -0.72424708,
    -0.72212819,
    -0.72000251,
    -0.71787005,
    -0.71573083,
    -0.71358487,
    -0.71143220,
    -0.70927283,
    -0.70710678,
    -0.70493408,
    -0.70275474,
    -0.70056879,
    -0.69837625,
    -0.69617713,
    -0.69397146,
    -0.69175926,
    -0.68954054,
    -0.68731534,
    -0.68508367,
    -0.68284555,
    -0.68060100,
    -0.67835004,
    -0.67609270,
    -0.67382900,
    -0.67155895,
    -0.66928259,
    -0.66699992,
    -0.66471098,
    -0.66241578,
    -0.66011434,
    -0.65780669,
    -0.65549285,
    -0.65317284,
    -0.65084668,
    -0.64851440,
    -0.64617601,
    -0.64383154,
    -0.64148101,
    -0.63912444,
    -0.63676186,
    -0.63439328,
    -0.63201874,
    -0.62963824,
    -0.62725182,
    -0.62485949,
    -0.62246128,
    -0.62005721,
    -0.61764731,
    -0.61523159,
    -0.61281008,
    -0.61038281,
    -0.60794978,
    -0.60551104,
    -0.60306660,
    -0.60061648,
    -0.59816071,
    -0.59569930,
    -0.59323230,
    -0.59075970,
    -0.58828155,
    -0.58579786,
    -0.58330865,
    -0.58081396,
    -0.57831380,
    -0.57580819,
    -0.57329717,
    -0.57078075,
    -0.56825895,
    -0.56573181,
    -0.56319934,
    -0.56066158,
    -0.55811853,
    -0.55557023,
    -0.55301671,
    -0.55045797,
    -0.54789406,
    -0.54532499,
    -0.54275078,
    -0.54017147,
    -0.53758708,
    -0.53499762,
    -0.53240313,
    -0.52980362,
    -0.52719913,
    -0.52458968,
    -0.52197529,
    -0.51935599,
    -0.51673180,
    -0.51410274,
    -0.51146885,
    -0.50883014,
    -0.50618665,
    -0.50353838,
    -0.50088538,
    -0.49822767,
    -0.49556526,
    -0.49289819,
    -0.49022648,
    -0.48755016,
    -0.48486925,
    -0.48218377,
    -0.47949376,
    -0.47679923,
    -0.47410021,
    -0.47139674,
    -0.46868882,
    -0.46597650,
    -0.46325978,
    -0.46053871,
    -0.45781330,
    -0.45508359,
    -0.45234959,
    -0.44961133,
    -0.44686884,
    -0.44412214,
    -0.44137127,
    -0.43861624,
    -0.43585708,
    -0.43309382,
    -0.43032648,
    -0.42755509,
    -0.42477968,
    -0.42200027,
    -0.41921689,
    -0.41642956,
    -0.41363831,
    -0.41084317,
    -0.40804416,
    -0.40524131,
    -0.40243465,
    -0.39962420,
    -0.39680999,
    -0.39399204,
    -0.39117038,
    -0.38834505,
    -0.38551605,
    -0.38268343,
    -0.37984721,
    -0.37700741,
    -0.37416406,
    -0.37131719,
    -0.36846683,
    -0.36561300,
    -0.36275572,
    -0.35989504,
    -0.35703096,
    -0.35416353,
    -0.35129276,
    -0.34841868,
    -0.34554132,
    -0.34266072,
    -0.33977688,
    -0.33688985,
    -0.33399965,
    -0.33110631,
    -0.32820984,
    -0.32531029,
    -0.32240768,
    -0.31950203,
    -0.31659338,
    -0.31368174,
    -0.31076715,
    -0.30784964,
    -0.30492923,
    -0.30200595,
    -0.29907983,
    -0.29615089,
    -0.29321916,
    -0.29028468,
    -0.28734746,
    -0.28440754,
    -0.28146494,
    -0.27851969,
    -0.27557182,
    -0.27262136,
    -0.26966833,
    -0.26671276,
    -0.26375468,
    -0.26079412,
    -0.25783110,
    -0.25486566,
    -0.25189782,
    -0.24892761,
    -0.24595505,
    -0.24298018,
    -0.24000302,
    -0.23702361,
    -0.23404196,
    -0.23105811,
    -0.22807208,
    -0.22508391,
    -0.22209362,
    -0.21910124,
    -0.21610680,
    -0.21311032,
    -0.21011184,
    -0.20711138,
    -0.20410897,
    -0.20110463,
    -0.19809841,
    -0.19509032,
    -0.19208040,
    -0.18906866,
    -0.18605515,
    -0.18303989,
    -0.18002290,
    -0.17700422,
    -0.17398387,
    -0.17096189,
    -0.16793829,
    -0.16491312,
    -0.16188639,
    -0.15885814,
    -0.15582840,
    -0.15279719,
    -0.14976453,
    -0.14673047,
    -0.14369503,
    -0.14065824,
    -0.13762012,
    -0.13458071,
    -0.13154003,
    -0.12849811,
    -0.12545498,
    -0.12241068,
    -0.11936521,
    -0.11631863,
    -0.11327095,
    -0.11022221,
    -0.10717242,
    -0.10412163,
    -0.10106986,
    -0.09801714,
    -0.09496350,
    -0.09190896,
    -0.08885355,
    -0.08579731,
    -0.08274026,
    -0.07968244,
    -0.07662386,
    -0.07356456,
    -0.07050457,
    -0.06744392,
    -0.06438263,
    -0.06132074,
    -0.05825826,
    -0.05519524,
    -0.05213170,
    -0.04906767,
    -0.04600318,
    -0.04293826,
    -0.03987293,
    -0.03680722,
    -0.03374117,
    -0.03067480,
    -0.02760815,
    -0.02454123,
    -0.02147408,
    -0.01840673,
    -0.01533921,
    -0.01227154,
    -0.00920375,
    -0.00613588,
    -0.00306796,
};

int32_t dds_phase_ratef(float frequency)
{
    return (int32_t) (frequency*65536.0f*65536.0f/SAMPLE_RATE);
}
/*- End of function --------------------------------------------------------*/

float dds_frequencyf(int32_t phase_rate)
{
    return (float) phase_rate*(float) SAMPLE_RATE/(65536.0f*65536.0f);
}
/*- End of function --------------------------------------------------------*/

float dds_scaling_dbm0f(float level)
{
    return powf(10.0f, (level - DBM0_MAX_POWER)/20.0f)*(32767.0f*1.414214f);
}
/*- End of function --------------------------------------------------------*/

float dds_scaling_dbovf(float level)
{
    return powf(10.0f, (level + 3.02f)/20.0f)*(32767.0f*1.414214f);
}
/*- End of function --------------------------------------------------------*/

float ddsf(uint32_t *phase_acc, int32_t phase_rate)
{
    float amp;

    amp = sine_table[*phase_acc >> (32 - SLENK)];
    *phase_acc += phase_rate;
    return amp;
}
/*- End of function --------------------------------------------------------*/

float dds_modf(uint32_t *phase_acc, int32_t phase_rate, float scale, int32_t phase)
{
    float amp;

    amp = sine_table[*(phase_acc + phase) >> (32 - SLENK)]*scale;
    *phase_acc += phase_rate;
    return amp;
}
/*- End of function --------------------------------------------------------*/

/* This is a simple direct digital synthesis (DDS) function to generate complex
   sine waves. */
complex_t dds_complexf(uint32_t *phase_acc, int32_t phase_rate)
{
    complex_t amp;

    amp = complex_set(sine_table[(*phase_acc + (1 << 30)) >> (32 - SLENK)],
                      sine_table[*phase_acc >> (32 - SLENK)]);
    *phase_acc += phase_rate;
    return amp;
}
/*- End of function --------------------------------------------------------*/

/* This is a simple direct digital synthesis (DDS) function to generate complex
   sine waves. */
complex_t dds_complex_modf(uint32_t *phase_acc, int32_t phase_rate, float scale, int32_t phase)
{
    complex_t amp;

    amp = complex_set(sine_table[(*phase_acc + phase + (1 << 30)) >> (32 - SLENK)]*scale,
                      sine_table[(*phase_acc + phase) >> (32 - SLENK)]*scale);
    *phase_acc += phase_rate;
    return amp;
}
/*- End of function --------------------------------------------------------*/
/*- End of file ------------------------------------------------------------*/
