###The only customizable variable is prefix.
###This package IS relocatable (change prefix to relocate).

%define prefix /usr/local


#WARNING!!! This package must be compiled for the the same kernel that will
#run on the target machine. This implies the same kernel version and the
#same kernel configuration. Thus, the binary packages can be provided by
#distribution vendors only for their stock distribution kernels. If you use
#a custom configured kernel, you must rebuild this package. To protect the
#innocent, we define kversion and make the resulting package dependable
#on the specific version of the kernel.

#This spec file is good for stock kernels of RedHat based distributions.
#If you run a stock smp kernel, the package suitable for smp kernel will be
#built.If you run a stock up kernel, the package suitable for up kernel will be
#built.

#Define your kernel version here. 
%define smptag %(uname -r| cut -f2 -d - |sed 's/[0-9]//g')
%define versiontag %(uname -r|sed 's/smp//')
%define kversion %(uname -r)
%define kname kernel%(echo %{smptag}|sed 's/smp/-smp/')

%define name kernel-i2c
%define ver 2.5.0
Summary: Updated i2c drivers
Name: %{name}
Version: %{ver}%{smptag}
Release: 1rh
Group: System Environment/Kernel
Copyright: GPL
Source0: http://www.lm-sensors.nu/lm-sensors/archive/i2c-%{ver}.tar.gz
Buildroot: /var/tmp/%{name}-%{ver}
Docdir: %{prefix}/doc
Url: http://www.netroedge.com/~lm78/
Requires: %{kname} = %{versiontag}
#The new i2c code has been integrated into kernel 2.3.38
Conflicts: kernel >= 2.3.38
#For officially distributed packages, please sign below
Packager: Constantine Gavrilov <const-g@xpert.com>
Distribution: RedHat 6.1

%description
This package contains the new i2c code and several bus drivers (algorithm
and adapter drivers). The chip drivers are not included in this package.
Most of the chip and bus drivers as well as additional basic code
for SMBus emulation over i2c are included in the lm_sensors package.
This package is required if you want to install programs which use the new
i2c implementation. Lm_sensors and video4linux (latest versions of bttv
driver) require the new i2c code.

%prep
%setup -n i2c-%{ver}

%build
#even for non-SMP systems parallel make will build faster
if [ %{smptag} = smp ]; then
 make -j4 MODVER=1 SMP=1
else
 make -j4 MODVER=1 SMP=0
fi

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT LINUX_INCLUDE_DIR=%{prefix}/include/linux \
	MODDIR=/lib/modules/%{kversion}/misc

%post
depmod -a || /bin/true

%postun
depmod -a || /bin/true

%files
%dir /lib/modules/%{kversion}
%dir /lib/modules/%{kversion}/misc
/lib/modules/%{kversion}/misc/*
%dir %{prefix}/include/linux
%{prefix}/include/linux/*.h
%doc doc/* IMPORTANT_CHANGES INSTALL README TODO

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/i2c-%{ver}
