/*
 * Hydrogen
 * Copyright(c) 2002-2005 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://www.hydrogen-music.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: HydrogenPlayer.cpp,v 1.6 2005/06/03 23:53:29 comix Exp $
 *
 */
#include "config.h"

#include <qapplication.h>

#include <iostream>
#include <stdio.h>
#include <string>
using std::string;

#include "lib/Hydrogen.h"
#include "lib/LocalFileMng.h"
#include "lib/Preferences.h"
//#include "lib/EngineListener.h"

using std::cout;
using std::endl;

void usage() {
	cout << "Usage: hydrogenPlayer song.h2song" << endl;
}


int main(int argc, char** argv) {
	if (argc != 2) {
		usage();
		exit(0);
	}
	cout << "Hydrogen player starting..." << endl << endl;
	QApplication a(argc, argv);

	Object::useVerboseLog( true );

	string filename = argv[1];

	Preferences *pPref = Preferences::getInstance();


	Song *song = Song::load(filename);
	if (song == NULL) {
		cout << "Error loading song!" << endl;
		exit(0);
	}

	Hydrogen *engine = Hydrogen::getInstance();
	engine->setSong(song);

	cout << "Press b for rewind from beginning" << endl;
	cout << "Press p for play" << endl;
	cout << "Press s for stop" << endl;
	cout << "Press q for quit" << endl;
	cout << "f = show frames" << endl;

	char pippo;

	while (true) {
		pippo = getchar();
		switch( pippo ) {
			case 'q':
				cout << endl << "HydrogenPlayer shutdown..." << endl;
				engine->stop();

				delete engine;
				delete song;
				delete pPref;
				delete Logger::getInstance();

				std::cout << std::endl << std::endl << Object::getNObjects() << " alive objects" << std::endl << std::endl;
				Object::printObjectMap();

				exit( 0 );
				break;

			case 'p':
				engine->start();
				break;

			case 's':
				engine->stop();
				break;

			case 'b':
				engine->setPatternPos( 0 );
				break;

			case 'f':
				cout << "Frames = " << engine->getTotalFrames() << endl;
				break;

			case 'd':
				cout << "DEBUG" << endl;
				Object::printObjectMap();
				int nObj = Object::getNObjects();
				std::cout << std::endl << std::endl << nObj << " alive objects" << std::endl << std::endl;
				break;
		}
	}

}



