/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: EngineListener.h,v 1.5 2004/04/05 11:54:08 comix Exp $
 *
 */
#ifndef ENGINE_LISTENER
#define ENGINE_LISTENER

#include "Song.h"

#include <string>
using std::string;

class EngineListener 
{
	public:
		virtual void stateChanged(int nState) {}
		
		virtual void patternChanged() {}
		virtual void patternModified() {}
		virtual void selectedPatternChanged() {}
		
		virtual void selectedInstrumentChanged() {}
		
		virtual void noteOn(Note *pNote) {
			delete pNote;	// the note parameter *must* be deleted..
		}
		virtual void engineError( uint nErrorCode ) {}

		virtual void midiActivityEvent() {}

		virtual void xRunEvent(float nTime, float nMaxTime) {}
};


#endif

