/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: hydrogenPlayer.cpp,v 1.7 2004/02/16 10:37:53 comix Exp $
 *
 */
#include "config.h"

#include <iostream>
#include <stdio.h>
#include <string>
using std::string;

#include "../lib/Hydrogen.h"
#include "../lib/LocalFileMng.h"
#include "../lib/PreferencesMng.h"
#include "../lib/EngineListener.h"
#include "../lib/LadspaFX.h"

using std::cout;
using std::endl;

void usage() {
	cout << "Usage: hydrogenPlayer song.h2song" << endl;
}


int main(int argc, char** argv) {
	if (argc != 2) {
		usage();
		exit(0);
	}
	cout << "Hydrogen player starting..." << endl << endl;

	Object::useVerboseLog( true );

	string filename = argv[1];

	Song *song = Song::load(filename);
	if (song == NULL) {
		cout << "Error loading song!" << endl;
		exit(0);
	}

/*
	vector<LadspaFXInfo*> info = LadspaFX::getPluginList();
	for (uint i = 0; i < info.size(); i++) {
		cout << i << " - " << info[i]->sName << " - " << info[i]->sLabel << endl;
		cout << "\t" << "in = " << info[i]->nIAPorts << "\tout = " << info[i]->nOAPorts << endl;
		cout << "\t" << info[i]->sFilename << endl;
	}
*/

	Hydrogen *engine = Hydrogen::getInstance();
	engine->setSong(song);

	cout << "press b for rewind from beginning" << endl;
	cout << "press p for play" << endl;
	cout << "press s for stop" << endl;
	cout << "press q for quit" << endl;
	cout << "f = show frames" << endl;

	char pippo;


	while (true) {
//		cout << "notes = " << engine->getPlayingNotes() << "     \r";
//		cout.flush();
//		usleep(500);

		pippo = getchar();
		switch( pippo ) {
			case 'q':
				{
				cout << endl << "HydrogenPlayer shutdown..." << endl;
				engine->stop();

				delete engine;
				engine = NULL;

				delete song;
				song = NULL;

				PreferencesMng *pref = PreferencesMng::getInstance();
				delete pref;
				pref = NULL;

				// ladspa
			//	for (uint i = 0; i < info.size(); i++) {
			//		delete info[ i ];
			//	}


				int nObj = Object::getNObjects();
				std::cout << std::endl << std::endl << nObj << " alive objects" << std::endl << std::endl;
				Object::printObjectMap();

				return 0;
				}
				break;

			case 'p':
				engine->start();
				break;

			case 's':
				engine->stop();
				break;

			case 'b':
				engine->setPatternPos( 0 );
				break;

			case 'f':
				cout << "Frames = " << engine->getTotalFrames() << endl;
				break;

			case 'd':
				cout << "DEBUG" << endl;
				Object::printObjectMap();
				int nObj = Object::getNObjects();
				std::cout << std::endl << std::endl << nObj << " alive objects" << std::endl << std::endl;
				break;
		}
	}

}



