/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: MixerLine.h,v 1.46 2004/02/10 11:07:30 comix Exp $
 *
 */


#ifndef MIXERLINE_H
#define MIXERLINE_H

#include "qwidget.h"
#include "qlabel.h"
#include "qtooltip.h"


#include "Fader.h"
#include "Button.h"
#include "InstrumentPropertiesDialog.h"
#include "lib/Object.h"




/**
 *
 */
class InstrumentNameWidget : public QWidget, public Object
{
	Q_OBJECT
	public:
		InstrumentNameWidget(QWidget* parent);
		~InstrumentNameWidget();

		void paintEvent(QPaintEvent *ev);

		void setText(QString text);
		QString text();

		void mousePressEvent( QMouseEvent * e );
		void mouseDoubleClickEvent( QMouseEvent * e );

	signals:
		void clicked();
		void doubleClicked();

	private:
		static QPixmap* m_pBackground;
		QPixmap m_temp;
		bool m_bChanged;
		int m_nWidgetWidth;
		int m_nWidgetHeight;
		QString m_sInstrName;
		QFont m_mixerFont;
};




/**
 * A mixer strip
 */
class MixerLine: public QWidget, public Object
{
	Q_OBJECT
	public:
		/** Constructor */
		MixerLine(QWidget* parent);

		/** Destructor */
		~MixerLine();

		void updateMixerLine();

		bool isMuteClicked();
		void setMuteClicked(bool isClicked);

		bool isSoloClicked();
		void setSoloClicked(bool isClicked);

		float getVolume();
		void setVolume(float value);

		void setPeak_L( float peak );
		float getPeak_L();

		void setPeak_R( float peak );
		float getPeak_R();

		void setName(QString name) {     nameWidget->setText( name );        }
		QString getName() {      return nameWidget->text();        }

		int getPan();
		void setPan(int value);

		int getActivity() {	return activity;	}
		void setActivity( uint value ) {	activity = value;	}

		void setPlayClicked( bool clicked );

		void setFXLevel( uint nFX, float fValue );
		float getFXLevel( uint nFX );
		
		void setSelected( bool bIsSelected );

	signals:
		void muteBtnClicked(MixerLine *ref);
		void soloBtnClicked(MixerLine *ref);
		void loadBtnClicked(MixerLine *ref);
		void volumeChanged(MixerLine *ref);
		void instrumentNameClicked(MixerLine *ref);
		void instrumentNameSelected(MixerLine *ref);
		void noteOnClicked(MixerLine *ref);
		void noteOffClicked(MixerLine *ref);
		void panChanged(MixerLine *ref);
		void knobChanged(MixerLine *ref, int nKnob);

	public slots:
		void click(Button *ref);
		void rightClick(Button *ref);
		void faderChanged(Fader *ref);
		void panFaderChanged(PanFader *ref);
		void knobChanged(Knob *ref);
		void nameClicked();
		void nameSelected();

	private:
		uint m_nWidth;
		uint m_nHeight;
		bool m_bIsSelected;
		
		uint activity;
		float maxPeak;
		Fader *fader;
		PanFader *panFader;
		QLabel *volumeLbl;
		InstrumentNameWidget *nameWidget;
		ToggleButton *muteBtn;
		ToggleButton *soloBtn;
		Button *loadBtn;
		Button *playSampleBtn;
		static QPixmap* m_pMixerLineBackground;
		static QPixmap* m_pMixerLineBackground_selected;
		Knob *m_pKnob[MAX_FX];

};




/**
 *
 */
class MasterMixerLine: public QWidget, public Object
{
	Q_OBJECT
	public:
		/** Constructor */
		MasterMixerLine(QWidget* parent);

		/** Destructor */
		~MasterMixerLine();

		void updateMixerLine();

		float getVolume();
		void setVolume(float value);

		void setPeak_L(float peak);
		float getPeak_L();

		void setPeak_R(float peak);
		float getPeak_R();


	signals:
		void volumeChanged(MasterMixerLine *ref);

	public slots:
		void faderChanged(Fader * ref);

	private:
		uint m_nWidth;
		uint m_nHeight;

		float maxPeak;
		QPixmap background;
		Fader *fader;
		QLabel *leftVolumeLbl;

};




/**
 * Mixer strip for FX
 */
class FxMixerLine: public QWidget, public Object
{
	Q_OBJECT
	public:
		/** Constructor */
		FxMixerLine(QWidget* parent);

		/** Destructor */
		~FxMixerLine();

		void updateMixerLine();

		float getVolume();
		void setVolume(float value);

		void setPeak_L(float peak);
		float getPeak_L();

		void setPeak_R(float peak);
		float getPeak_R();

		void setName(QString name) {     nameWidget->setText( name );        }
		QString getName() {      return nameWidget->text();        }

		bool isFxActive();
		void setFxActive( bool active );

	signals:
		void volumeChanged( FxMixerLine *ref );
		void instrumentNameClicked( FxMixerLine *ref );
		void activeBtnClicked( FxMixerLine *ref );

	public slots:
		void click(Button *ref);
		void faderChanged(Fader * ref);

	private:
		uint m_nWidth;
		uint m_nHeight;

		float maxPeak;
		Fader *fader;
		QLabel *volumeLbl;
		InstrumentNameWidget *nameWidget;
		QPixmap mixerLineBackground;
		ToggleButton *activeBtn;

};


class LadspaFXMixerLine : public QWidget, public Object
{
	Q_OBJECT
	public:
		LadspaFXMixerLine(QWidget* parent);

		~LadspaFXMixerLine();

		void setName(QString name) {     m_pNameWidget->setText( name );        }
		QString getName() {      return m_pNameWidget->text();        }

		bool isFxActive();
		void setFxActive( bool active );
		void setPeaks( float fPeak_L, float fPeak_R );
		void getPeaks( float *fPeak_L, float *fPeak_R );

		float getVolume();
		void setVolume(float value);

	public slots:
		void nameClicked();
		void click(Button *ref);
		void faderChanged(Fader * ref);

	signals:
		void activeBtnClicked( LadspaFXMixerLine *ref );
		void editBtnClicked( LadspaFXMixerLine *ref );
		void volumeChanged( LadspaFXMixerLine *ref);
		void ladspaNameClicked( LadspaFXMixerLine *ref);

	private:
		float m_fMaxPeak;
		static QPixmap* m_pMixerLineBackground;
		ToggleButton *m_pActiveBtn;
		ToggleButton *m_pEditBtn;
		InstrumentNameWidget *m_pNameWidget;
		Fader *m_pFader;
};




#endif

