#!/usr/bin/env python
import sys
import os

class ParseHashFile(dict):
    """
    Upon instantiation will return a dictionary object
    containing pairs of key => value holding the directives
    found in the loaded conffile as keys, and each directive's values
    as the values referenced by those keys.
    """
    def __init__(self,FileName):
        f = open(FileName,"r")
        content = f.readlines()
        # remove file remarks
        content = [line for line in content if line[0] != "#"]
        # remove trainling whitespaces
        content = [line.rstrip() for line in content]
        content = [line for line in content if line != ""]
        for line in content:
            self[line.split("=")[0]] = line.split("=")[1]


if __name__ == "__main__":
    try:
        a = ParseHashFile(sys.argv[1])
        for k in a:
            print "%s=%s" % (k,a[k])
    except IndexError:
        print "Please provide a file name to process as an argument."
