package lib::plugin::message;

use strict;

# Constructors

sub new {
  my($class, %init) = @_;

  my $self;

  $self = bless {
    'method' => undef,
    'version' => lib::plugin::Version,
    'headers' => []
  }, $class;

  foreach (keys %init) {
    if(exists $self->{$_}) {
      $self->{$_}=$init{$_};
    }
  }

  return $self;
}

sub as_string {
  my $self = shift;
  my ($str, $kv, @kv);

  my $method=$self->{'method'};
  my $version=$self->{'version'};

  if(defined $method && defined $version) {
    $str="$method $version\n";

    foreach $kv (@{$self->{'headers'}}) {
      @kv=@{$kv};
      $str.=$kv[0].":".lib::plugin::encode($kv[1])."\n";
      }
  }

  return $str;
}

sub add_header {
  my ($self, $key, $val) = @_;

  my @kv=($key, $val);

  push(@{$self->{'headers'}}, \@kv);
}

return 1;
