package lib;

require lib::plugin;

$VERSION="1.0";
sub Version { $VERSION; }

use vars qw (%HTTPUSH_OPTIONS);
use strict;

my $debug_level=0;

sub debug {
  my ($data, $level)=@_;

  if(!$level) {
    $level=1;
  }

  return if ($level > $debug_level);

  open (XLOG,">> httpush.debug");
  flock XLOG, 2;
  print XLOG "($$)# $data\n";
  flock XLOG, 8;
  close XLOG;

  print STDERR "($$)# $data\n";
}

sub announce {
  my($data)=shift;
  print STDERR "=> $data\n";
}

sub get_unique_id {
  my $rand=int(rand()*100000);
  my $id=time().$$.$rand;
  return $id;
}

sub set_debug_level {
  $debug_level=shift;
}

return 1;
