<?php
/**
 * @package Horde_Kolab
 *
 * $Horde: framework/Kolab/Kolab/XML/hprefs.php,v 1.1.2.1 2008/06/05 07:08:14 wrobel Exp $
 */

/**
 * Kolab XML handler for client preferences
 *
 * $Horde: framework/Kolab/Kolab/XML/hprefs.php,v 1.1.2.1 2008/06/05 07:08:14 wrobel Exp $
 *
 * Copyright 2007 The Horde Project (http://www.horde.org/)
 *
 * @author  Gunnar Wrobel <wrobel@pardus.de>
 * @package Horde_Kolab
 */
class Horde_Kolab_XML_hprefs extends Horde_Kolab_XML {
    /**
     * Specific data fields for the prefs object
     *
     * @var Kolab
     */
    var $_fields_specific;

    /**
     * Constructor
     */
    function Horde_Kolab_XML_hprefs()
    {
        $this->_root_name = 'h-prefs';

        /** Specific preferences fields, in kolab format specification order
         */
        $this->_fields_specific = array(
            'pref' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_MULTIPLE,
                'value'   => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
                'array'   => array(
                    'type' => HORDE_KOLAB_XML_TYPE_STRING,
                    'value' => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
                ),
            ),
        );

        parent::Horde_Kolab_XML();
    }
}
