// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// edited by Anirban Biswas <utpal@cal2.vsnl.net.in>
// This file is part of the hk_postgresqlclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.20 $
#include "hk_postgresqltable.h"
#include "hk_postgresqldatabase.h"
#include "hk_postgresqlcolumn.h"
#include <hk_actionquery.h>

typedef signed int int32;                         /* == 32 bits */
#define VARHDRSZ        ((int32) sizeof(int32))

hk_postgresqltable::hk_postgresqltable(hk_postgresqldatabase* db,hk_presentation* p):hk_postgresqldatasource(db,p)

{
//wanna_debug(true);
    p_readonly=false;

}


hk_datasource::enum_datasourcetypes hk_postgresqltable::type() const
{
    return ds_table;
}


bool hk_postgresqltable::driver_specific_name(const hk_string& n)
{
    return true;
}


bool hk_postgresqltable::driver_specific_enable(void)
{
//  p_readonly=false;
    driver_specific_indices();                    //to select if table uses primarykey
    return hk_postgresqldatasource::driver_specific_enable();

}


bool hk_postgresqltable::driver_specific_create_table_now(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_postgresqltable::driver_specific_create_table_now");
#endif
    hk_string csql="CREATE TABLE ";
    primarystring="";
    //csql+=replace_all(" ",name(),"_");
    csql+=p_identifierdelimiter+name()+p_identifierdelimiter;
    csql+=" ( ";
    csql+=internal_new_fields_arguments(false);
    csql+=getprimarystring(false)+" ) ";

// cout <<"hk_postgresqltable::driver_specific_create_table_now CREATE definition: "<<endl<<csql<<endl;
    hk_actionquery* query= p_database->new_actionquery();
    query->set_sql(csql.c_str(),csql.size());
    bool result=query->execute();
// if (result) cout<<"tabelle angelegt"; else cout<<"fehler";cout <<endl;
    delete query;
    return result;
}


hk_string hk_postgresqltable::getprimarystring(bool alter)
{
    if (primarystring.size()==0)return "";
    hk_string key=", ";
    if (alter) key+="ADD ";
    key+="PRIMARY KEY ( ";
    key=key+primarystring+" )";
    return key;

}


hk_string hk_postgresqltable::internal_new_fields_arguments(bool alter)
{
#ifdef HK_DEBUG
    hkdebug("hk_postgresqltable::internal_new_fields_arguments");
#endif
    hk_string csql;
    hk_string line;
    hk_string fields;

    list<hk_column*>::iterator it=p_newcolumns.begin();
    while (it!=p_newcolumns.end())
    {
#ifdef HK_DEBUG
        hkdebug("while START");
#endif
        hk_string n=(*it)->name();
        if (n.size()>0)
        {
            if (line.size()>0)line+=" , ";
            if (alter) fields =" ADD COLUMN "; else fields="";
            fields+=((*it)->name().size()>0?p_identifierdelimiter+(*it)->name()+p_identifierdelimiter:"");
            if (fields.size()==0)
            {
                return "";
            }
            fields+=" ";
            fields+=field2string((*it)->columntype(),longint2string((*it)->size()<256?(*it)->size():255));
#ifdef HK_DEBUG
            hkdebug("nach field2string");
#endif

            if (!alter)
            {
                if ((*it)->columntype()==hk_column::auto_inccolumn||((*it)->is_primary()))
                {
                    if (primarystring.size()>0)primarystring+=" , ";
                    primarystring+=p_identifierdelimiter+(*it)->name()+p_identifierdelimiter;

                }
                if (((*it)->is_notnull()||(*it)->is_primary())&&(*it)->columntype()!=hk_column::auto_inccolumn)
                    fields+=" NOT NULL ";
            }
            line+=fields;
        }
        else
        {
            show_warningmessage(hk_translate("Warning: Column with no name!"));

        }
        it++;
#ifdef HK_DEBUG
        hkdebug("while ENDE");
#endif
    }

    csql=csql+line+p_sql_delimiter;
#ifdef HK_DEBUG
    hkdebug("hk_postgresqltable::internal_new_fields_arguments   ENDE");
#endif
    return csql;
}


bool hk_postgresqltable::is_unallowed_alter(void)
{
    list<class_altercolumns>::iterator it=p_altercolumns.begin();
    while (it!=p_altercolumns.end())
    {
        hk_column* c=column_by_name((*it).name);
        if (c)
        {
//cout <<"FELD ndern: " <<(*it).name<<" typneu "<<(*it).type<<" typalt "<<c->columntype()<<" sizeneu "<<(*it).size<<" sizealt "<<c->size()<<endl;

            if (
                (*it).type!=c->columntype()       //try to alter columntype
                && (*it).type!=hk_column::othercolumn
//try to change size
                || (((*it).size>-1)&&(*it).size!=c->size())
                ||((*it).primary!=c->is_primary())

                ) return true;
        }
        it++;
    }
    return false;

}


hk_string hk_postgresqltable::field2string(hk_column::enum_columntype f,const hk_string& m)
{
#ifdef HK_DEBUG
    hkdebug("hk_postgresqltable::field2string");
#endif
    hk_string fields;
    switch (f)
    {
        case hk_column::auto_inccolumn :    return "SERIAL";
//BIGINT is not supported before pg 7.1
        case hk_column::integercolumn : return "INT8";
        case hk_column::smallintegercolumn :    return "SMALLINT";
        case hk_column::floatingcolumn :    return "FLOAT8";
        case hk_column::smallfloatingcolumn :   return "FLOAT4";
        case hk_column::datecolumn :    return "DATE";
        case hk_column::timestampcolumn :   return "TIMESTAMP";
        case hk_column::timecolumn :    return "TIME";
        case hk_column::binarycolumn :  return "BYTEA";
        case hk_column::memocolumn :    return "TEXT";
        case hk_column::boolcolumn :    return "BOOLEAN";
        case hk_column::textcolumn :    fields ="VARCHAR("+m+") ";
        return fields;
        default :       return "VARCHAR(255)";

    }

}


bool hk_postgresqltable::driver_specific_alter_table_now(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_postgresqltable::driver_specific_alter_table_now");
#endif
    if (p_deletecolumns.size()>0 || is_unallowed_alter() )
    {
        show_warningmessage(hk_translate("Error: Postgres does neither have the ability to modify the \
columntype or the primary key, nor to delete columns!"));
        return false;

    }
    if ( !internal_alter_fields_arguments()) return false;
    hk_string asql="ALTER TABLE ";
    asql+=p_identifierdelimiter+name()+p_identifierdelimiter;
    list<hk_column*>::iterator it=p_newcolumns.begin();
    hk_actionquery* query= p_database->new_actionquery();
    if (!query) return false;
    hk_string n;
    bool result=true;
    while (it!=p_newcolumns.end()&&result)
    {
        result=true;
        if ((*it)->name().size()>0)
        {
            n=p_identifierdelimiter+(*it)->name()+p_identifierdelimiter+" "+field2string((*it)->columntype(),longint2string( ((*it)->size()<256?(*it)->size():255 )));
            if (n.size()>0)
            {
                n=asql+" ADD COLUMN "+n;
                query->set_sql(n.c_str(),n.size());
                result=query->execute();
            }
        }
        it++;
    }
    delete query;
    return result;

}


bool  hk_postgresqltable::internal_alter_fields_arguments(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_postgresqltable::internal_alter_fields_arguments");
#endif
    if (p_altercolumns.size()==0)
    {
        return true;
    }
    hk_string result;
    list<class_altercolumns>::iterator it=p_altercolumns.begin();
    hk_actionquery* query= p_database->new_actionquery();
    if (!query) return false;
    bool r=true;
    while (it!=p_altercolumns.end()&&r)
    {
        hk_column*c =column_by_name((*it).name.c_str());
        if (c!=NULL)
        {
            if ((*it).newname!="HK_NULL"&& (*it).newname!=(*it).name)
            {
                result=" ALTER TABLE ";
                result+=p_identifierdelimiter+name()+p_identifierdelimiter;

                result+=" RENAME COLUMN ";
                result+=(*it).name+" TO "+(*it).newname;
                query->set_sql(result.c_str(),result.size());
                r=query->execute();
                if (!r) show_warningmessage(replace_all("%COLUMN%",hk_translate("Column '%COLUMN%' could not be renamed"),(*it).name));
            }
            if (r && (*it).notnull!=c->is_notnull())
            {
                if ((*it).notnull)
                {
                    result="SELECT * FROM "+p_identifierdelimiter+name()+p_identifierdelimiter+" WHERE "+((*it).newname!="HK_NULL"?(*it).newname:(*it).name)+" IS NULL ";
                    hk_datasource*d =database()->new_resultquery();
                    if (d)
                    {
                        d->set_sql(result);
                        d->enable();
                        if (d->max_rows()>0) r=false;
//d->dump_data();
//cout <<"MAXROWS: "<<d->max_rows();
                        d->disable();
                        delete d;
                    }

                    if (!r) show_warningmessage(replace_all("%COLUMN%",hk_translate("Column '%COLUMN%' has NULL values, so NOTNULL is not possible"),(*it).name));
                }
                if (r)
                {
                    result="UPDATE pg_attribute SET attnotnull=";
                    result+=((*it).notnull?"TRUE":"FALSE");
                    result+=" WHERE attname='";
                    result+=p_identifierdelimiter+(((*it).newname!="HK_NULL"?(*it).newname:(*it).name))+p_identifierdelimiter;
                    result+="' AND attrelid=(SELECT oid FROM pg_class WHERE relname='"+name()+"')";
                    cerr <<"NOT NULL Anpassung: "<<result<<endl;
                    query->set_sql(result.c_str(),result.size());
                    r=query->execute();
                }

            }

        }
        it++;
    }
    delete query;
    return r;
}


bool hk_postgresqltable::is_alteredfield(const hk_string& f)
{
#ifdef HK_DEBUG
    hkdebug("hk_postgresqltable::is_alteredfield");
#endif
    list<class_altercolumns>::iterator it=p_altercolumns.begin();
    while (it!=p_altercolumns.end())
    {
        if ((*it).name==f)return true;
        it++;
    }
    return false;
}


bool hk_postgresqltable::is_deletedfield(const hk_string& f)
{
#ifdef HK_DEBUG
    hkdebug("hk_postgresqltable::is_deletedfield");
#endif
    list<hk_string>::iterator it=p_deletecolumns.begin();
    while (it!=p_deletecolumns.end())
    {
        if ((*it)==f)return true;
        it++;
    }
    return false;
}


list<hk_datasource::indexclass>* hk_postgresqltable::driver_specific_indices(void)
{
//return NULL; //for testing reasons !! remove later

    if (!p_tempdatasource) p_tempdatasource=database()->new_resultquery();
    if (p_tempdatasource==NULL)
    {
        return NULL;
    }
    set_indexquery();
    p_indices.erase(p_indices.begin(),p_indices.end());
    unsigned long m=p_tempdatasource->max_rows();
    hk_column* keyname=p_tempdatasource->column_by_name("indexname");
    hk_column* fieldname=p_tempdatasource->column_by_name("columnname");
    hk_column* uniquefield=p_tempdatasource->column_by_name("is_unique");
    hk_column* primaryfield=p_tempdatasource->column_by_name("is_primary");
    if (keyname==NULL||fieldname==NULL||uniquefield==NULL||primaryfield==NULL)
    {
        p_tempdatasource->disable();
        return NULL;
    }

    indexclass index;                             //cout <<"Anzahl indices: "<<m<<endl;
    hk_string indexname;
    for (unsigned long i=0;i<m;i++)
    {
        hk_string n=keyname->asstring();
        if (n!=indexname&& !primaryfield->asbool())
        {
            indexname=n;
            index.name=n;
            index.unique=uniquefield->asbool();
            p_indices.insert(p_indices.end(),index);
        }
        if (primaryfield->asbool())
        {
            p_primary_key_used=true;

        }
        p_tempdatasource->goto_next();
    }
    p_tempdatasource->goto_first();
    for (unsigned long i=0;i<m;i++)
    {
        hk_string n=keyname->asstring();
        list<hk_datasource::indexclass>::iterator it=findindex(n);
        if (it!=p_indices.end())
        {
            (*it).fields.insert((*it).fields.end(),fieldname->asstring());

        }
        p_tempdatasource->goto_next();
    }

    p_tempdatasource->disable();
    return &p_indices;
}


void hk_postgresqltable::set_indexquery(void)
{
    if (!p_tempdatasource) p_tempdatasource=database()->new_resultquery();
    if (!p_tempdatasource) return;
    hk_string q="select t1.relname as indexname, indisunique as is_unique ,indisprimary as is_primary ,\
 attname as columnname\
 from pg_index,pg_class t1,pg_class t2 ,pg_attribute a\
 where indexrelid=t1.oid and indrelid =t2.oid and a.attrelid=t1.oid and t2.relname ='";
    q+=name()+"'";
    p_tempdatasource->disable();
    p_tempdatasource->set_sql(q,true);
    p_tempdatasource->enable();
// p_tempdatasource->dump_data();

}


list<hk_datasource::indexclass>::iterator hk_postgresqltable::findindex(const hk_string& i)
{

    list<hk_datasource::indexclass>::iterator it=p_indices.begin();
    while (it!=p_indices.end())
    {
        if ((*it).name==i)return it;
        it++;
    }
    return p_indices.end();
}


bool    hk_postgresqltable::driver_specific_drop_index(const hk_string& i)
{
    hk_string s=" DROP INDEX ";
    s+=p_identifierdelimiter+i+p_identifierdelimiter;

    hk_actionquery* query= p_database->new_actionquery();
    if (query==NULL) return false;
    query->set_sql(s.c_str(),s.size());
    bool res =query->execute();
    delete query;

    return res;
}


bool    hk_postgresqltable::driver_specific_create_index(const hk_string& i,bool unique, list<hk_string>& fields)
{
    hk_string s="CREATE ";
    s+=(unique?"UNIQUE ":"");
    s+="INDEX ";
    s+=p_identifierdelimiter+i+p_identifierdelimiter+" ON ";
    s+=p_identifierdelimiter+name()+p_identifierdelimiter;
    s+=" ( ";
    hk_string f;
    list<hk_string>::iterator it=fields.begin();
    while (it!=fields.end())
    {
        if (f.size()>0)f+=" , ";
        f+=p_identifierdelimiter+(*it)+p_identifierdelimiter;
        it++;
    }

    s+=f+" )";
    hk_actionquery* query= p_database->new_actionquery();
    if (query==NULL) return false;
//cout <<"Create Index: "<<s<<endl;
    query->set_sql(s.c_str(),s.size());
    bool res =query->execute();
    delete query;

    return res;
}


bool hk_postgresqltable::driver_specific_create_columns(void)
{
    if (!p_tempdatasource) p_tempdatasource=database()->new_resultquery();
    bool result=hk_postgresqldatasource::driver_specific_create_columns();

    if (!result||!p_columns||name().size()==0)return false;
    hk_string s= "SELECT a.*,typname,adsrc as defaultvalue from pg_class t,pg_type y , pg_attribute a \
   LEFT JOIN pg_attrdef d ON a.attnum=d.adnum and a.attrelid=d.adrelid WHERE  t.oid=a.attrelid \
   and a.attnum>0 and y.oid = a.atttypid and relname='"+name()+"'";
    if (p_tempdatasource==NULL) return false;
    p_tempdatasource->disable();
    p_tempdatasource->set_sql(s);
    p_tempdatasource->enable();
//  p_tempdatasource->dump_data();
    hk_column* namefield=p_tempdatasource->column_by_name("attname");
    hk_column* isnotnullfield=p_tempdatasource->column_by_name("attnotnull");
    hk_column* defaultfield=p_tempdatasource->column_by_name("defaultvalue");
    hk_column* sizefield=p_tempdatasource->column_by_name("atttypmod");
    int z=0;
    while (  (z <p_tempdatasource->max_rows() ) )
    {
        hk_column* colorig= column_by_name(namefield->asstring());
        hk_postgresqlcolumn* col=dynamic_cast<hk_postgresqlcolumn*>(colorig);
        if (col)
        {
            col->set_definitionmode(true);
            col->set_notnull(isnotnullfield->asbool());
            hk_string n="nextval(";
            size_t pos=defaultfield->asstring().find(n);
            if(pos!=hk_string::npos)
            {
                col->set_columntype(hk_column::auto_inccolumn);
                col->p_autoincdefault=defaultfield->asstring();
                col->p_autoincdefault.replace(pos,n.size()-1,"currval");
            }
            if (col->columntype()==hk_column::textcolumn)col->set_size(localestring2int(sizefield->asstring())-VARHDRSZ);
            col->set_definitionmode(false);

        }
        p_tempdatasource->goto_next();z++;
    };                                            //end while

    p_tempdatasource->disable();

// now query for the is_primary values
    set_indexquery();
    if (!p_tempdatasource) return result;

    z=0;
    hk_column* keyname=p_tempdatasource->column_by_name("indexname");
    hk_column* fieldname=p_tempdatasource->column_by_name("columnname");
    hk_column* primaryfield=p_tempdatasource->column_by_name("is_primary");
    while (  (z <p_tempdatasource->max_rows() ) )
    {
        if (primaryfield->asbool())
        {

            p_primary_key_used=true;
            hk_postgresqlcolumn* col= dynamic_cast<hk_postgresqlcolumn*>(column_by_name(fieldname->asstring()));
            if (col)
            {
                col->set_definitionmode(true);
                col->set_primary(true);
                col->set_definitionmode(false);
            }
        }
        p_tempdatasource->goto_next();z++;
    };                                            //end while
    p_tempdatasource->disable();

    return result;

}
