// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.29 $
#include "hk_importcsv.h"
#include "hk_database.h"
#include "hk_column.h"
#include "hk_datasource.h"
hk_importcsv::hk_importcsv(void):hk_dsvisible()
{
#ifdef HK_DEBUG
//wanna_debug(true);
    hkclassname("import");
    hkdebug("hk_importcsv::constructor");
#endif
    p_textdelimiter="";
    p_rowdelimiter="\n";
    p_betweenfields=",";
    p_filestream=NULL;
    p_firstrow_contains_fieldnames=true;
    p_create_new_table=true;
    p_datamode=true;
    p_notcancelimport=true;
    p_overwrite=false;
}


hk_importcsv::~hk_importcsv(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::destructor");
#endif
    if (p_filestream!=NULL)delete p_filestream;
    p_filestream = NULL;
}


bool hk_importcsv::execute(enum_interaction enuminteractive)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::execute");
#endif
    if (datasource()==NULL) return false;
    p_datamode=true;
    if ((p_textdelimiter.size()==0)&&(p_betweenfields.size()==0)
        ||p_filename.size()==0)
    {
        reset();
        return false;
    }

    if (!initialize_table(enuminteractive))
    {
        reset();

        return false;
    }
    hk_string sbuffer;
    int i=1;
    set_columns();
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::execute while");
#endif
    p_notcancelimport=true;
    while (!p_filestream->eof()&&p_notcancelimport)
    {
        getline(*p_filestream,sbuffer);
        create_valuelist(sbuffer);
        unsigned int z=p_columnlist.size();
        if (z>datasource()->columns()->size())z=datasource()->columns()->size();
        datasource()->setmode_insertrow();
//*************************************
//*          store data               *
//*************************************
        vector<colstruct>::iterator col_it=p_columnlist.begin();
        vector<hk_string>::iterator value_it=p_valuelist.begin();
        if ((p_valuelist.size()>0)&&(p_columnlist.size()))
        {

//     for (unsigned int k=0;k<z;k++)
            while (col_it!=p_columnlist.end() && value_it!=p_valuelist.end())
            {
                if ((*col_it).col!=NULL)
                {
                    if (!((*value_it)=="" &&is_numerictype((*col_it).col)))
		    (*col_it).col->set_asstring((*value_it),true,false);
                }
                col_it++;
                value_it++;
            }
        }

        i++;
        datasource()->store_changed_data();
        p_notcancelimport=widget_specific_after_new_row();
    }
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::execute while ENDE");
#endif
    reset();

    return true;
}


bool hk_importcsv::initialize_table(enum_interaction e)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::initialize_table");
#endif
    hk_string sbuffer;
    if (datasource()==NULL)
    {
        show_warningmessage(hk_translate("No datasource defined!"));
        return false;
    }

    if (p_filestream!=NULL) delete p_filestream;
    p_filestream=new ifstream(p_filename.c_str(),ios::in);
    if (!(*p_filestream))
    {
        hk_string w=hk_translate("No such CSV file: ");
        w+=p_filename;
        show_warningmessage(w);
        reset();

        return false;
    }

    if (p_firstrow_contains_fieldnames)
    {
        getline(*p_filestream,sbuffer);           //erste zeile lesen
        if (p_columnlist.size()==0)
        {
            create_valuelist(sbuffer);
            create_automatic_columns();
        }
    }
    if (p_create_new_table)
    {
        if (datasource()->database()->table_exists(datasource()->name()))
        {
            if (runtime_only()||(e==noninteractive && ! p_overwrite))
            {
                show_warningmessage(hk_translate("Table already exists"));
                return false;
            }
            hk_datasource* d=datasource();
            if (!datasource()->database()->delete_table(datasource()->name(),
	        e==interactive?hk_database::interactive:hk_database::noninteractive))
	       return false;
            set_datasource(d);
        }
        datasource()->setmode_createtable();
        hk_column* col=NULL;
        getline(*p_filestream,sbuffer);           //erste Datenzeile einlesen
        if (!p_firstrow_contains_fieldnames &&p_columnlist.size()==0)
        {

            create_valuelist(sbuffer);
            create_automatic_columns();
        }
        p_datamode=false;
	//cerr <<"BEGIN FELDTYP ERMITTLUNG"<<endl;
        create_valuelist(sbuffer);
	//cerr <<"VALUELIST EINLESEN FELDTYP ERMITTLUNG"<<endl;
        p_datamode=true;
#ifdef HK_DEBUG
        hkdebug("hk_importcsv::initialize_table vor while");
#endif

        vector<colstruct>::iterator colit=p_columnlist.begin();
        vector<hk_string>::iterator it=p_valuelist.begin();
        while (it!=p_valuelist.end()&&colit!=p_columnlist.end())
        {
#ifdef HK_DEBUG
            hkdebug("in while begin");
#endif
            col=datasource()->new_column();
            col->set_name((*colit).colname);
#ifdef HK_DEBUG
            hkdebug("angelegte Spalte: ",col->name());
#endif

            int c=interpret_columntype((*it)); //cerr <<"TYP:  ";
            switch (c)
            {
                case 1:col->set_columntype(hk_column::floatingcolumn);//cerr<<"floating";
                break;
                case 2:col->set_columntype(hk_column::integercolumn);//cerr<<"integer";
                break;
                case 3:col->set_columntype(hk_column::boolcolumn);//cerr<<"bool";
                break;
                default:col->set_columntype(hk_column::textcolumn);//cerr<<"text";
            }
//cerr <<endl;
            if ((*it).size()>255)col->set_columntype(hk_column::memocolumn);
            else col->set_size(255);
#ifdef HK_DEBUG
            hkdebug("initialize_table ++");
#endif

            it++;
//         if (colit!=p_columnlist.end())
            colit++;
        }                                         //end while
#ifdef HK_DEBUG
        hkdebug("hk_importcsv::initialize_table NACH while");
//datasource()->wanna_debug(true);
#endif
        if(! datasource()->create_table_now())
        {
#ifdef HK_DEBUG
            hkdebug("Tabelle kann nicht angelegt werden");
#endif
            show_warningmessage("Maybe the column names are not valid!");
            reset();
            return false;
        }

    }                                             //end create table
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::initialize_table nach create table");
#endif
    p_accessmode=datasource()->accessmode();
    if (datasource()->is_enabled()) datasource()->disable();
    datasource()->set_accessmode(hk_datasource::batchwrite);
    if (!datasource()->is_enabled())datasource()->enable();
    if (!datasource()->is_enabled())
    {
        reset();

        show_warningmessage(hk_translate("Datasource could not be enabled"));
        return false;
    }

#ifdef HK_DEBUG
    hkdebug("hk_importcsv::initialize_table nach enable");
#endif

// Datei wieder auf erste Datenzeile stellen
    if (p_filestream!=NULL) delete p_filestream;
    p_filestream=new ifstream(p_filename.c_str(),ios::in);
    if (p_firstrow_contains_fieldnames)
        getline(*p_filestream,sbuffer);           //erste zeile lesen
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::initialize_table vor return");
#endif

    return true;
}


void    hk_importcsv::set_filedefinition(const hk_string& fielddelimiter,const hk_string& betweenfields, const hk_string& rowdelimiter)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::set_filedefinition");
#endif
    p_textdelimiter=fielddelimiter;
    if (betweenfields.size()>0) p_betweenfields=betweenfields;
    p_rowdelimiter=rowdelimiter;
}


void hk_importcsv::set_filename(const hk_string& filename)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::set_filename");
#endif
    p_filename=filename;

}


void hk_importcsv::set_firstrow_contains_fieldnames(bool f)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::set_firstrow_contains_fieldnames");
#endif
    p_firstrow_contains_fieldnames=f;
}


void hk_importcsv::set_append_rows(bool append_rows)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::set_append_rows");
#endif
    p_create_new_table = ! append_rows;
}


/**
 *the parser is based on the KOffice/Kspread import filter <c>1999 David Faure
 */






void hk_importcsv::create_valuelist( hk_string& row)
{
#ifdef HK_DEBUG
//wanna_debug(true);
    hkdebug("hk_importcsv::create_valuelist");
#endif
    hk_string::size_type returnkey = row.find('\r');
    row.append("\n");
    hk_string delimiters=" ";
    if (returnkey<=row.size())  row.replace(returnkey,1,"");

    p_valuelist.erase(p_valuelist.begin(),p_valuelist.end());
    if(row.size()<=p_textdelimiter.size()*2+p_betweenfields.size())
    {
#ifdef HK_DEBUG
        hkdebug("hk_importcsv::create_valuelist return am Beginn der whileschleife");
#endif
        return;
    }
    hk_string::size_type offset=0;
//  hk_string::size_type beginposition=0;
//  hk_string::size_type endposition=0;
    hk_string field;
#ifdef HK_DEBUG
    hkdebug("Zeile: ",row);
    hkdebug("Gesamtlnge: ",(int)row.size());
    hkdebug("Z: ",row);
    hkdebug("Z: 12345678901234567890123456789012345678901234567890123456789012345678901234567890");
    hkdebug("Z: 0        1         2         3         4         5         6         7         8");
#endif

    enum
    {
        S_START,S_QUOTED_FIELD,S_MAYBE_END_OF_QUOTED_FIELD, S_END_OF_QUOTED_FIELD,
        S_NORMAL_FIELD
    } state=S_START;
//cout <<"SUCHSTRING: "<<row<<endl;
    while (offset<=row.size())
    {
        hk_string x(1,row[offset]);               //row[offset];
        ++offset;
        switch (state)
        {
            case S_START :
                if ( p_textdelimiter==x)
                {
                    state = S_QUOTED_FIELD;      // cout <<"S_STARTED set S_QUOTED_FIELD"<<endl;
                    if (!p_datamode) field="X";   //to mark that this is a field of type string
                }
                else if (x == p_betweenfields)
                {
                                                  //cout <<"LEERZEILTE S_START"<<endl;
                    p_valuelist.insert(p_valuelist.end(),"");//cerr <<"FIELD: "<<""<<endl;
                    field="";
                }
                else if(x=="\n")
                    {}
                    else
                {
                    field += x;
                    state = S_NORMAL_FIELD; //cout <<"S_STARTED MAYBE_NORMAL";
                }
                break;


            case S_QUOTED_FIELD :
                if (x == p_textdelimiter)
                {
                                                //  cout <<"S_QUOTED_FIELD set S_MAYBE_END_OF_QUOTED_FIELD"<<endl;
                    state = S_MAYBE_END_OF_QUOTED_FIELD;
                }
                else if (x=="\n")
                {
                                                  //cout <<"S__QUOTED_FIELD "<<field<<endl;
                    p_valuelist.insert(p_valuelist.end(),field);//cerr <<"FIELD: "<<field<<endl;
                    field="";
                }

                else
                {
                    field += x;
                }
                break;

            case S_MAYBE_END_OF_QUOTED_FIELD :
                if (x == p_textdelimiter)
                {
                    field += x;
                    state = S_QUOTED_FIELD;
		   // cerr <<"von S_MAYBE_END_OF_QUOTED_FIELD nach S_QUOTED_FIELD"<<endl;
                }
                else if (x == p_betweenfields || x=="\n" )
                {
                                          //        cout <<"S_MAYBE_END_OF_QUOTED_FIELD "<<field<<endl;
                    p_valuelist.insert(p_valuelist.end(),field);//cerr <<"FIELD: "<<field<<endl;
                    field = "";
                    state = S_START;
                }
                else
                {   //cerr <<"von S_MAYBE_END_OF_QUOTED_FIELD nach S_END_OF_QUOTED_FIELD"<<endl;
                    state = S_END_OF_QUOTED_FIELD;
                }
                break;


	    case S_END_OF_QUOTED_FIELD :
                if (x == p_betweenfields ||x=="\n" )
                {
                                                 // cout <<"S_END_OF_QUOTED_FIELD  nach S_START"<<field<<" x="<<x<<endl;
                    p_valuelist.insert(p_valuelist.end(),field);cerr <<"FIELD: "<<field<<endl;
                    field = "";
                    state = S_START;
                }
                else
                {
		   //cerr <<"ELSE       S_END_OF_QUOTED_FIELD"<<endl;
                    state = S_END_OF_QUOTED_FIELD;
                }
                break;


	    case S_NORMAL_FIELD :
                if (x == p_betweenfields || x == "\n")
                {
                                              //    cout <<"S_NORMAL_FIELD "<<field<<endl;
                    p_valuelist.insert(p_valuelist.end(),field);//cerr <<"FIELD: "<<field<<endl;
                    field = "";
                    state = S_START;
                }
                else
                {
                    field += x;
                }
        }
    }

}


void    hk_importcsv::add_columnname(const hk_string& col)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::add_columnname");
#endif
    colstruct p_col;

// remove leading and trailing spaces
    hk_string::size_type b=col.find_first_not_of(" ");
    hk_string::size_type e=col.find_last_not_of(" ");
    if (e==hk_string::npos) e=col.size();
    if (b!=hk_string::npos) p_col.colname=col.substr(b,e-b+1);

// replace interior spaces with underscores
    p_col.colname=replace_all(" ",p_col.colname,"_");
    p_col.col=NULL;
    p_columnlist.insert(p_columnlist.end(),p_col);
}


void hk_importcsv::clear_columnlist(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::clear_columnlist");
#endif
    p_columnlist.erase(p_columnlist.begin(),p_columnlist.end());
}


void hk_importcsv::set_columns(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::set_columns");
#endif
    if (datasource()==NULL) return;
    vector<colstruct>::iterator it=p_columnlist.begin();
    while (it!=p_columnlist.end())
    {
        (*it).col=datasource()->column_by_name((*it).colname);
//cout <<"Suche nach Column: " << (*it).colname<<" "<< (!(*it).col?"nicht ":"")<<"erfolgreich"<<endl;
        it++;
    }

}


void    hk_importcsv::create_automatic_columns(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::create_automatic_columns");
#endif
    hk_string newfieldname;
    clear_columnlist();
    int zaehler=0;
    const int bsize=60;
    char* buf= new char[bsize];

    vector<hk_string>::iterator it=p_valuelist.begin();
    while(it!=p_valuelist.end())
    {
        snprintf(buf,bsize,"%d",zaehler);
        newfieldname=hk_translate("field_")+buf;
        add_columnname(p_firstrow_contains_fieldnames?(*it):newfieldname);

        it++;++zaehler;
    }
    delete[] buf;

}


bool hk_importcsv::before_columns_deleted(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::before_columns_deleted");
#endif
    vector<colstruct>::iterator it=p_columnlist.begin();
    while (it!=p_columnlist.end())
    {
        (*it).col=NULL;
        it++;
    }
//  clear_columnlist();
    return true;
}


int hk_importcsv::interpret_columntype(hk_string& field)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::interpret_columntype");
#endif
    int num=0;
    int komma=0;
    int alpha=0;
   if (field=="TRUE"||field=="FALSE") return 3;
    for (unsigned int i=0;i<field.size();i++)
    {

        if (isdigit(field[i])) num++;
        else if (field[i]=='.')komma++;
        else alpha++;

    }
//  cout <<"interpretiere feldtyp: "<<field<<endl;
//  cout <<"alpha: "<<alpha<<" komma: "<<komma<<" num: "<<num<<endl;

    if (alpha>0||komma>1)return 0;
    if (num>0) if (komma==1) return 1;
    else return 2;
    return 0;

}


void hk_importcsv::reset(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_importcsv::reset");
#endif
    delete p_filestream;
    p_filestream=NULL;
    clear_columnlist();
}


bool hk_importcsv::widget_specific_after_new_row(void)
{
    return true;
}


void hk_importcsv::set_overwrite_table(bool o)
{
    p_overwrite=o;

}


bool hk_importcsv::overwrite_table(void)
{
    return p_overwrite;
}
