// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include "hk_dsquery.h"
#include "hk_datasource.h"
#include "hk_database.h"
#include "hk_dsgrid.h"
#include "hk_qbe.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#define VERSION UNKNOWN
#endif

#ifdef HAVE_SSTREAM
#include <sstream>
#else
#include <strstream.h>
#endif


class hk_dsqueryprivate
{
public:
hk_dsqueryprivate()
	{
	  p_use_qbe=true;
	}
bool p_use_qbe;

};


hk_dsquery::hk_dsquery(hk_presentation* presentation):hk_dsmodevisible(presentation)
{
  p_private= new hk_dsqueryprivate;
}


hk_dsquery::~hk_dsquery()
{
 delete p_private;
}


void hk_dsquery::set_use_qbe(bool u, bool registerchange)
{
  p_private->p_use_qbe=u;
  has_changed(registerchange);
}

bool hk_dsquery::use_qbe(void) const
{
  return p_private->p_use_qbe;
}




bool hk_dsquery::save_query(const hk_string& n,bool ask)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsquery::save_query");
#endif

    if (datasource()==NULL) 
    {
    cerr <<"hk_dsquery::save_query datasource==0"<<endl;
    return false;
    }
    if (n.size()>0) datasource()->set_name(n);
    if (datasource()->name().size()==0) if (!(datasource()->ask_name()))return false;
     reset_has_changed();
    if (datasource()->database()->storagemode(ft_query)==hk_database::local)
    {
    ofstream* p_save=datasource()->database()->savestream(datasource()->name(),ft_query,ask);
    if (p_save==NULL)
    {
     return false;
    } 
    savedata(*p_save);
    p_save->close();
    delete p_save;
    }
    else
    { // store central
#ifdef HAVE_SSTREAM
       stringstream* p_save;
#else
       strstream*  p_save;
#endif
      p_save=datasource()->database()->savestringstream(ft_query);
      if (p_save==NULL) 
        {
	  cerr <<"savestringstream=0!"<<endl;
	return false;
	}
       savedata(*p_save);
       hk_string s=p_save->str();
       datasource()->database()->save(s,datasource()->name(),ft_query,ask);
       delete p_save;
    }
    reset_has_changed();
    return true;

}




void hk_dsquery::savedata(ostream& s)
{
    start_mastertag(s,"HK_QUERY");
    set_tagvalue(s,"HK_QUERYVERSION",(hk_string)VERSION);
    if (grid())
    	    grid()->savedata(s);
    
    set_tagvalue(s,"USE_QBE",p_private->p_use_qbe);
    if (p_private->p_use_qbe && qbe())
      {
         qbe()->savedata(s);
      }
	    
    end_mastertag(s,"HK_QUERY");

}










bool hk_dsquery::load_query(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsquery::load_query");
#endif
    if (datasource()==NULL) return false;
    widget_specific_before_load_query();
    hk_string res=u2l(datasource()->database()->load(datasource()->name(),ft_query));
    if (res.size()==0)return false;
     loaddata(res);
    widget_specific_after_load_query();
    return true;

}

void hk_dsquery::loaddata(const hk_string& definition)
{
    if (grid())
    {
    hk_string g;
    if (get_tagvalue(definition,"HK_DSGRID",g,1,mastertag))
        grid()->loaddata(g);
// DIE NCHSTEN ZEILEN LSCHEN UM EINDEUTIGES QUERYFORMAT ZU HABEN
    else
        grid()->loaddata(definition);
    grid()->set_font(hk_font::defaultfontname(),hk_font::defaultfontsize());
   } 
    p_private->p_use_qbe=false;
    get_tagvalue(definition,"USE_QBE",p_private->p_use_qbe);
    
    if (p_private->p_use_qbe && qbe())
      {
         hk_string g;
	 get_tagvalue(definition,"QBE",g);
	 qbe()->loaddata(g);
      }

}





void hk_dsquery::widget_specific_before_load_query(void)
{

}

void hk_dsquery::widget_specific_after_load_query(void)
{

}

void hk_dsquery::widget_specific_before_save_query(void)
{

}

void hk_dsquery::widget_specific_after_save_query(void)
{

}
