// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.47 $
#include "hk_dsdatavisible.h"
#include "hk_form.h"
#include "hk_datasource.h"
#include "hk_presentation.h"

int hk_dsdatavisible::p_defaultprecision=2;
bool hk_dsdatavisible::p_defaultthousandsseparator=false;

class hk_dsdatavisibleprivate
{
public:
        hk_string      p_columnname;
        hk_string      p_defaultvalue;
        int  p_precision;
        bool p_use_numberseparator;
        int p_columnoccurance;

};

hk_dsdatavisible::hk_dsdatavisible(hk_presentation* p) :hk_dsvisible(p)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::hk_dsdatavisible");
#endif
p_designdata=new hk_dsdatavisibleprivate;
p_viewdata=new hk_dsdatavisibleprivate;
    p_column=NULL;
    p_designdata->p_columnname="";
    p_viewdata->p_columnname="";
    p_usedefault=false;
    set_numberformat(defaultuse_numberseparator(),defaultprecision(),false,true);
    set_alignment(aligndefault,false);
    p_designdata->p_columnoccurance=1;
    p_viewdata->p_columnoccurance=1;
    p_virginname=true;

}


hk_dsdatavisible::~hk_dsdatavisible()
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::destructor");
#endif
    if (p_column!=NULL) p_column->datavisible_remove(this);
delete p_designdata;
delete p_viewdata;
}


void hk_dsdatavisible::set_datasource(hk_datasource* d)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::set_datasource");
#endif

    hk_dsvisible::set_datasource(d);
    if(d==NULL)
    {
        if (p_column!=NULL) p_column->datavisible_remove(this);
        p_column=NULL;
        return;
    }
    if ((d->is_enabled())&&(p_designdata->p_columnname!="")) column();
}


hk_datasource* hk_dsdatavisible::datasource(void)
{
    return hk_dsvisible::datasource();
}


void hk_dsdatavisible::set_columnname(const hk_string& c,bool registerchange)
{
    set_columnname(c,1,registerchange);
}


void hk_dsdatavisible::set_columnname(const hk_string& c, bool registerchange, int coloccurance)
{
#ifdef HK_DEBUG
    hkclassname(c);
    hkdebug("hk_dsdatavisible::set_columnname(hk_string&)");
    debug_p_columnname=c;
#endif
    p_designdata->p_columnname=c;
    p_designdata->p_columnoccurance=(coloccurance<1?1:coloccurance);
    if (label().size()==0) set_label(c,registerchange);
    has_changed(registerchange);

    if (datasource()!=NULL)
    {
        if ((datasource()->is_enabled())&&(p_designdata->p_columnname!=""))
        {
            set_column();
            row_change();
        }
#ifdef HK_DEBUG
        else
        {
//cout <<"columnname: "<<p_columnname<<endl<<"datasource-enabled() "<<(datasource()->is_enabled()?"ja":"nein")<<endl;
        }
    }else
    {
        hkdebug("hk_dsdatavisible::set_columnname(hk_string&) datasource==NULL");
#endif
    }
    widget_specific_enable_disable();
    widget_specific_set_column();

}


hk_column* hk_dsdatavisible::column()
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::column");
    hkdebug("columname= ",p_designdata->p_columnname);
#endif
/*        if (datasource()!=NULL)
            if (datasource()->depending_on()!=NULL) p_column=NULL;
    */
    if (p_column!=NULL)
    {
#ifdef HK_DEBUG
        hkdebug("p_colum!=NULL=>return");
#endif
        return p_column;
    };
    if (p_designdata->p_columnname!="")
    {

        if (p_datasource!=NULL)
        {
#ifdef HK_DEBUG
            hkdebug("p_colum=NULL");
#endif
            if (p_datasource->is_enabled())
                set_column();
//	     cout <<"p_column: "<<p_column<<endl;
        }
    }
    return p_column;
}


bool hk_dsdatavisible::datasource_disable(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::datasource_disable");
#endif
    if (p_column!=NULL) p_column->datavisible_remove(this);
    p_column=NULL;
    hk_dsvisible::datasource_disable();
//widget_specific_enable_disable();
    return true;
}


bool hk_dsdatavisible::datasource_enable(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::datasource_enable");
#endif

    if (p_column!=NULL) p_column->datavisible_remove(this);
    p_column=NULL;
    column();
    hk_dsvisible::datasource_enable();
//widget_specific_enable_disable();
    return true;
}


void hk_dsdatavisible::datasource_delete(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::datasource_delete");
#endif

    if (p_column!=NULL) p_column->datavisible_remove(this);
    p_column=NULL;
    p_datasource=NULL;
    widget_specific_enable_disable();
}


bool hk_dsdatavisible::before_columns_deleted(void)
{
    if (p_column!=NULL) p_column->datavisible_remove(this);
    p_column=NULL;
    return true;
}


void hk_dsdatavisible::savedata(ostream& s )
{
    hk_string tag="HK_DSDATAVISIBLE";
    start_mastertag(s,tag);
    hk_dsvisible::savedata(s);
    set_tagvalue(s,"COLUMN",p_designdata->p_columnname);
    set_tagvalue(s,"COLUMNOCCURANCE",p_designdata->p_columnoccurance);
    set_tagvalue(s,"DEFAULTVALUE",p_designdata->p_defaultvalue);
    set_tagvalue(s,"USE_DEFAULTVALUE",p_usedefault);
    set_tagvalue(s,"NUMBERSEPARATOR",p_designdata->p_use_numberseparator);
    set_tagvalue(s,"COMMADIGITS",(long int)p_designdata->p_precision);

    end_mastertag(s,tag);
}


void hk_dsdatavisible::loaddata(const hk_string& definition)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::loaddata");
#endif
    hk_string buffer;
    get_tagvalue(definition,"HK_DSVISIBLE",buffer);

    hk_dsvisible::loaddata(buffer);
    p_virginname=false;
    get_tagvalue(definition,"COLUMN",p_designdata->p_columnname);
    get_tagvalue(definition,"COLUMNOCCURANCE",p_designdata->p_columnoccurance);

#ifdef HK_DEBUG
    hkclassname(p_designdata->p_columnname);
#endif
    hk_string b;
    if (get_tagvalue(definition,"DEFAULTVALUE",b))p_designdata->p_defaultvalue=b;
    bool bb;
    if (get_tagvalue(definition,"USE_DEFAULTVALUE",bb))p_usedefault=bb;
    get_tagvalue(definition,"NUMBERSEPARATOR",p_designdata->p_use_numberseparator);
    get_tagvalue(definition,"COMMADIGITS",p_designdata->p_precision);
    set_numberformat(p_designdata->p_use_numberseparator,p_designdata->p_precision,false,true);
//compatibility code version 0.5.5 : now has moved to hk_visible. remove this code in version 1.0
    hk_string align;
    get_tagvalue(definition,"ALIGN",align);
    alignmenttype a=alignleft;
    if (align=="RIGHT") a=alignright;
    else if (align=="CENTER")a=aligncenter;
    set_alignment(a,false);
//end compatibility code

}


hk_string hk_dsdatavisible::columnname(void)
{
    return p_designdata->p_columnname;
}


void hk_dsdatavisible::widget_specific_set_column(void)
{

}


void hk_dsdatavisible::set_column(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::set_column");
#endif
    if (p_column!=NULL)
    {
        p_column->datavisible_remove(this);
        p_column=NULL;
    }
    if(datasource()!=NULL) p_column=datasource()->column_by_name(p_designdata->p_columnname,p_designdata->p_columnoccurance);
    if (p_column!=NULL)
    {
        p_column->datavisible_add(this);
        p_column->set_dateformat(dateformat());
        p_column->set_timeformat(timeformat());
        p_column->set_datetimeformat(datetimeformat());
        if (!use_defaultvalue()&&p_virginname)
        {

            switch (p_column->columntype())
            {
                case hk_column::smallintegercolumn : ;
                case hk_column::integercolumn : set_defaultvalue(format_number(0,use_numberseparator(),precision(),locale()),false);break;
                case hk_column::smallfloatingcolumn :;
                case hk_column::floatingcolumn : ; set_defaultvalue(format_number(0.0,use_numberseparator(),precision(),locale()),false);break;
                case hk_column::datecolumn : ;
                case hk_column::timecolumn :;
                case hk_column::timestampcolumn:;
                case hk_column::datetimecolumn  :; set_defaultvalue("%NOW%",false);break;
                case hk_column::boolcolumn : ; set_defaultvalue("%FALSE%",false);break;
                default:;
            }
        }
//	    cout <<"col: "<<p_column->name()<<" type: "<<p_column->columntype_name()<<" is_numeric: "<<(is_numerictype(p_column)?"ja":"nein")<<endl;
        if (alignment()==hk_visible::aligndefault)
        {
            if (is_numerictype(p_column))set_alignment(defaultnumberalignment(),false);
            else set_alignment(defaulttextalignment(),false);
        }
        new_column_pointer_created();
	p_virginname=false;
    }

}


bool    hk_dsdatavisible::use_defaultvalue(void)
{
    if (p_column!=NULL)
        if (p_column->columntype()==hk_column::auto_inccolumn)
            return true;
//if (p_defaultvalue.size()==0)return false;
    return p_usedefault;
}


void    hk_dsdatavisible::set_defaultvalue(const hk_string& def,bool registerchange)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::set_defaultvalue");
#endif
    p_usedefault=true;
    p_designdata->p_defaultvalue=def;

    has_changed(registerchange);

}


hk_string  hk_dsdatavisible::raw_defaultvalue(void)
{

    return p_designdata->p_defaultvalue;
}


hk_string  hk_dsdatavisible::defaultvalue(void)
{

    if (p_column==NULL) return "";
    hk_string dt;

    switch  (p_column->columntype())
    {
        case hk_column::auto_inccolumn :  return hk_translate("[Auto]");
        case hk_column::datecolumn :  dt=p_date.date_asstring();break;
        case hk_column::timecolumn :  dt=p_date.time_asstring();break;
        case hk_column::datetimecolumn :;
        case hk_column::timestampcolumn:;
        default:dt=p_date.datetime_asstring();
    }
    hk_string p_res=replace_all("%NOW%",p_designdata->p_defaultvalue,dt);
    p_res=replace_all("%NOWTIME%",p_res,p_date.time_asstring());
    p_res=replace_all("%NOWDATE%",p_res,p_date.date_asstring());
    p_res=replace_all("%TRUE%",p_res,"TRUE");
    p_res=replace_all("%FALSE%",p_res,"FALSE");

    return p_res;
}


void    hk_dsdatavisible::reset_default(bool registerchange)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::reset_default");
#endif

    p_usedefault=false;
    p_designdata->p_defaultvalue="";
    has_changed(registerchange);
}


void hk_dsdatavisible::before_insert_row(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::before_insert_row");
#endif
    if (datasource()==NULL||p_column==NULL||!p_usedefault) return;
    if (!p_column->has_changed()&&use_defaultvalue()&&defaultvalue().size()>0)
    {
        p_column->set_asstring(defaultvalue(),true,true);
    }

}


void    hk_dsdatavisible::set_numberformat(bool use_numberseparator, int commadigits,bool registerchange)
{
   set_numberformat(use_numberseparator,commadigits,registerchange,false);
}


void    hk_dsdatavisible::set_numberformat(bool use_numberseparator, int commadigits,bool registerchange,bool force_setting)
{

    if (allow_datachanging(force_setting))
    {
    p_designdata->p_use_numberseparator=use_numberseparator;
    p_designdata->p_precision=(commadigits<0?-1:commadigits);

    }
    p_viewdata->p_use_numberseparator=use_numberseparator;
    p_viewdata->p_precision=(commadigits<0?-1:commadigits);
    widget_specific_numberformat();
    has_changed(registerchange);
}


bool    hk_dsdatavisible::use_numberseparator(void)
{
if (p_presentation && p_presentation->mode()==hk_presentation::viewmode)
    return p_viewdata->p_use_numberseparator;
    return p_designdata->p_use_numberseparator;

}


int     hk_dsdatavisible::commadigits(void)
{
    return precision();
}


int     hk_dsdatavisible::precision(void)
{
    
if (p_presentation && p_presentation->mode()==hk_presentation::viewmode)
    return p_viewdata->p_precision;
    return p_designdata->p_precision;
    
}


void hk_dsdatavisible::set_defaultnumberformat(bool use_thousandsseparator,int precision)
{
    p_defaultthousandsseparator=use_thousandsseparator;
    p_defaultprecision=precision;

}


bool hk_dsdatavisible::defaultuse_numberseparator(void)
{
    return p_defaultthousandsseparator;

}


int hk_dsdatavisible::defaultprecision(void)
{
    return p_defaultprecision;
}


void hk_dsdatavisible::widget_specific_numberformat(void)
{

}


hk_string hk_dsdatavisible::value_at(unsigned long at)
{
#ifdef HK_DEBUG
    hkdebug("hk_dsdatavisible::value_at");
#endif
    if (!column()) return "";
    hk_string value;
    if (p_column->has_changed() &&
        ((datasource()->row_position()==at&&datasource()->mode()!=hk_datasource::mode_insertrow)
        ||(datasource()->row_position()==datasource()->max_rows()&&datasource()->mode()==hk_datasource::mode_insertrow))

        )
        value=p_column->changed_data_asstring();
    else
    if (datasource()->mode()==hk_datasource::mode_insertrow&& at>= datasource()->max_rows()&& use_defaultvalue())
        value=defaultvalue();
    else
        value=p_column->asstring_at(at,true);

    if (is_numerictype(p_column)&&p_column->columntype()!=hk_column::auto_inccolumn&&value.length()>0
        || (p_column->columntype()==hk_column::auto_inccolumn
        && (datasource()->mode()!=hk_datasource::mode_insertrow||at<datasource()->max_rows())))
    {
        value=format_number(value,true,use_numberseparator(),commadigits(),locale());
    }

    return value;

}

hk_string hk_dsdatavisible::value(void)
{
hk_datasource* ds=datasource();
if (ds)
   {
     return value_at(ds->row_position());
   }
   else return "";
}




void hk_dsdatavisible::new_column_pointer_created(void)
{

}


void hk_dsdatavisible::set_value(const hk_string& v)
{
 hk_column* c=column();
 if (c)c->set_asstring(v);
}

unsigned int hk_dsdatavisible::find(unsigned int from,unsigned int to,const hk_string& searchtext,bool wholephrase,bool casesensitive,bool backwards)
{
 hk_column* c=column();
 if (c)return c->find(from,to,searchtext,wholephrase,casesensitive,backwards);
 else return (unsigned int) -1;
}


unsigned int hk_dsdatavisible::find(const hk_string& searchtext,bool wholephrase,bool casesensitive, bool backwards)
{
 hk_column* c=column();
 if (c)return c->find(searchtext,wholephrase,casesensitive,backwards);
 else return (unsigned int) -1;
}


void     hk_dsdatavisible::presentationmode_changed(void)
{
    if (p_column!=NULL) p_column->datavisible_remove(this);
    p_column=NULL;
   hk_dsvisible::presentationmode_changed();
     if (!p_presentation) return;
}