dnl    This file is part of the hk_classes libraries/packages
dnl    Copyright (C) 2001-2003 Horst Knorr (hk_classes@knoda.org)

dnl    This file is free software; you can redistribute it and/or
dnl    modify it under the terms of the GNU Library General Public
dnl    License as published by the Free Software Foundation;
dnl    version 2 of the License.

dnl    This library is distributed in the hope that it will be useful,
dnl    but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl    Library General Public License for more details.

dnl    You should have received a copy of the GNU Library General Public License
dnl    along with this library; see the file COPYING.LIB.  If not, write to
dnl    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
dnl    Boston, MA 02111-1307, USA.

dnl 	$Id: acinclude.m4,v 1.24 2004/07/04 10:03:28 knorr Exp $






AC_DEFUN(HK_CLASSESINIT,
[
AC_MSG_CHECKING([HK_CLASSES INIT])

if test "$prefix" = "NONE"; then
 HK_CLASSESDIR=/usr/lib/hk_classes
 HK_CLASSESINCDIR=/usr/include/hk_classes
else
 HK_CLASSESDIR=$libdir/hk_classes
 HK_CLASSESINCDIR=$includedir/hk_classes
fi
if test "$with_hk_classes_incdir" != ""; then
HK_CLASSESINCDIR=$with_hk_classes_incdir
fi
HKPYTHONDIR=""
UTILITIESDIR=""
AC_SUBST(HK_CLASSESDIR)
AC_SUBST(HK_CLASSESINCDIR)
NODRIVER=true
POSSIBLE_DRIVERS="MYSQL,ODBC, POSTGRESQL"
dnl AC_DEFINE_UNQUOTED(HKCLASSES, "$HK_CLASSESDIR",[PREPROCESSOR DEFINITION])
AC_MSG_RESULT(OK)
])




AC_DEFUN(HK_MYSQLTEST,
[
AC_MSG_CHECKING([whether MYSQL is available])
if test "$with_mysql_dir" = ""; then
   MYSQLLIBDIR=/usr/lib/mysql
   MYSQLINCDIR=/usr/include/mysql
else MYSQLLIBDIR=$with_mysql_dir/lib
MYSQLINCDIR=$with_mysql_dir/include
fi

if test "x$with_mysql_incdir" != "x"; then
 MYSQLINCDIR=$with_mysql_incdir
fi

if test "x$with_mysql_libdir" != "x"; then
 MYSQLLIBDIR=$with_mysql_libdir
fi


ac_save_LIBS="$LIBS"
ac_save_CPPFLAGS="$CPPFLAGS"
ac_save_CXXLIBS="$CXXLIBS"

CXXLIBS="$ac_save_CXXLIBS -L${MYSQLLIBDIR} -lmysqlclient"
LIBS="$ac_save_LIBS -L${MYSQLLIBDIR} -lmysqlclient"
CPPFLAGS="$ac_save_CPPFLAGS -I$MYSQLINCDIR"

AC_TRY_LINK([#include <mysql.h>],[;],[mysql_lib=yes],[mysql_lib=no])

AC_MSG_RESULT($mysql_lib)
if test $mysql_lib = yes ; then
NODRIVER=false
DRIVERSDIR="$DRIVERSDIR hk_mysqlclasses"
AC_SUBST(MYSQLLIBDIR)
AC_SUBST(MYSQLINCDIR)
MYSQLREALESCAPE
fi


LIBS="$ac_save_LIBS"
CPPFLAGS="$ac_save_CPPFLAGS"
CXXLIBS="$ac_save_CXXLIBS"


])

AC_DEFUN(MYSQLREALESCAPE,
[

AC_MSG_CHECKING([MYSQL has mysql_real_escape_string function])


AC_TRY_LINK([#include <mysql.h>],[
MYSQL* m;
char* to;
 mysql_real_escape_string(m,to,"test",4);
],[mysql_real=yes],[mysql_real=no])

AC_MSG_RESULT($mysql_real)
if test $mysql_real = yes ; then
AC_DEFINE(HAVE_MYSQL_REAL_ESCAPE_STRING,1,Defines if Mysql has the mysql_real_escape_string function)
fi


])




AC_DEFUN(HK_POSTGRESTEST,
[
AC_MSG_CHECKING([whether POSTGRES is available])
if test "$with_postgres_dir" = ""; then
   POSTGRESLIBDIR=/usr/local/pgsql/lib
   POSTGRESINCDIR=/usr/include/pgsql
else
   POSTGRESLIBDIR=$with_postgres_dir/lib
   POSTGRESINCDIR=$with_postgres_dir/include
fi

if test "x$with_postgres_incdir" != "x"; then
 POSTGRESINCDIR=$with_postgres_incdir
fi

if test "x$with_postgres_libdir" != "x"; then
 POSTGRESLIBDIR=$with_postgres_libdir
fi


ac_save_LIBS="$LIBS"
ac_save_CPPFLAGS="$CPPFLAGS"
ac_save_CXXLIBS="$CXXLIBS"

CXXLIBS="$ac_save_CXXLIBS -L${POSTGRESLIBDIR} -lpq"
LIBS="$ac_save_LIBS -L${POSTGRESLIBDIR} -lpq"
CPPFLAGS="$ac_save_CPPFLAGS -I$POSTGRESINCDIR"

AC_TRY_LINK([#include <libpq-fe.h>],[;],[postgres_lib=yes],[postgres_lib=no])

AC_MSG_RESULT($postgres_lib)
if test $postgres_lib = yes ; then
NODRIVER=false
DRIVERSDIR="$DRIVERSDIR hk_postgresclasses"
AC_SUBST(POSTGRESLIBDIR)
AC_SUBST(POSTGRESINCDIR)
fi


LIBS="$ac_save_LIBS"
CPPFLAGS="$ac_save_CPPFLAGS"
CXXLIBS="$ac_save_CXXLIBS"


])








AC_DEFUN(HK_ODBCTEST,
[
AC_MSG_CHECKING([whether ODBC is available])
if test "$ODBCDIR" = ""; then
   ODBCLIBDIR=/usr/local/lib
   ODBCINCDIR=/usr/local/include
else ODBCLIBDIR=$ODBCDIR/lib
ODBCLINCDIR=$ODBCDIR/include
fi
ac_save_LIBS="$LIBS"
ac_save_CPPFLAGS="$CPPFLAGS"
ac_save_CXXLIBS="$CXXLIBS"

CXXLIBS="$ac_save_CXXLIBS -L${ODBCLIBDIR} -lodbc"
LIBS="$ac_save_LIBS -L${ODBCLIBDIR} -lodbc"
CPPFLAGS="$ac_save_CPPFLAGS -I$ODBCINCDIR"

AC_TRY_LINK([#include <sql.h>],[;],[odbc_lib=yes],[odbc_lib=no])
if test x$odbc_lib = xno ; then
if test "$ODBCDIR" = ""; then
   ODBCLIBDIR=/usr/local/lib
   ODBCINCDIR=/usr/include/
fi
LIBS="$ac_save_LIBS -L${ODBCLIBDIR} -lodbc"
CPPFLAGS="$ac_save_CPPFLAGS -I$ODBCINCDIR"
AC_TRY_LINK([#include <sql.h>],[;],[odbc_lib=yes],[odbc_lib=no])
fi
if test x$odbc_lib = xyes ; then
ODBCLIBRARY="odbc"
else
LIBS="$ac_save_LIBS -L${ODBCLIBDIR} -liodbc"
CPPFLAGS="$ac_save_CPPFLAGS -I$ODBCINCDIR"
 AC_TRY_LINK([#include <sql.h>],[;],[odbc_lib=yes],[odbc_lib=no])
 if test x$odbc_lib = xyes ; then
 ODBCLIBRARY="iodbc"
 fi
fi

AC_MSG_RESULT($odbc_lib)
if test x$odbc_lib = xyes ; then
NODRIVER=false
DRIVERSDIR="$DRIVERSDIR hk_odbcclasses"
AC_SUBST(ODBCLIBDIR)
AC_SUBST(ODBCINCDIR)
AC_SUBST(ODBCLIBRARY)
AC_DEFINE_UNQUOTED(ODBCLIBRARY,"$ODBCLIBRARY",[DEFINES THE NAME OF THE ODBC LIBRARY])
dnl else
dnl  AC_MSG_ERROR( ODBC not found )

fi
LIBS="$ac_save_LIBS"
CPPFLAGS="$ac_save_CPPFLAGS"
CXXLIBS="$ac_save_CXXLIBS"


])







AC_DEFUN(HK_DEFINEDRIVERS,
[
AC_SUBST(DRIVERSDIR)
AC_SUBST(NODRIVER)
AC_SUBST(POSSIBLE_DRIVERS)
AC_SUBST(HKPYTHONDIR)

])

AC_DEFUN(AC_SSTREAM_EXISTS,
[

AC_MSG_CHECKING([whether <sstream> exists])
AC_TRY_LINK([#include <sstream>],[;],[sstream_exists=yes],[sstream_exists=no])
AC_MSG_RESULT($sstream_exists)
if test $sstream_exists = yes ; then
AC_DEFINE(HAVE_SSTREAM,1,Defines if stdc++ library contains a sstream implementation)
fi

])

AC_DEFUN(AC_IOSTREAM_EXISTS,
[

AC_MSG_CHECKING([whether <iostream> exists])
AC_TRY_LINK([#include <iostream>],[;],[iostream_exists=yes],[iostream_exists=no])
AC_MSG_RESULT($iostream_exists)
if test $iostream_exists = yes ; then
AC_DEFINE(HAVE_IOSTREAM,1,Defines if stdc++ library contains a <iostream> implementation)
else
AC_DEFINE(NO_IOSTREAM,1,Defines that stdc++ library does not have a new <iostream> implementation)

fi

])


AC_DEFUN(HK_CLEARENV_EXISTS,
[
AC_MSG_CHECKING([whether clearenv() is available])
AC_TRY_LINK([#include <stdlib.h>],[clearenv();],[ac_clearenv=yes],[ac_clearenv=no])
if test $ac_clearenv = yes ; then
AC_DEFINE(HAVE_CLEARENV,1,Defines if stdlib has function clearenv)
fi
AC_MSG_RESULT($ac_clearenv)
])


AC_DEFUN(HK_CHECK_ARGP_EXISTS,
[
dnl argp.h is not available on FreeBSD !
AC_MSG_CHECKING([whether argp.h is available])
AC_TRY_LINK([#include <argp.h>],[;],[ac_argp=yes],[ac_argp=no])
if test $ac_argp = yes ; then
AC_DEFINE(HAVE_ARGP,1,Defines whether argp.h exists)
 UTILITIESDIR="utilities"

fi
AC_SUBST(UTILITIESDIR)
AC_MSG_RESULT($ac_argp)

])


dnl the following makro has been taken from GNU gettext
dnl and modified to fit for HK_CLASSES
dnl 17.02.2002 Horst Knorr


dnl Copyright (C) 2000-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.

AC_DEFUN([AM_ICONV_LINK],
[
  dnl Some systems have iconv in libc, some have it in libiconv (OSF/1 and
  dnl those with the standalone portable GNU libiconv installed).

  dnl Prerequisites of AC_LIB_LINKFLAGS_BODY.
  dnl AC_REQUIRE([AC_LIB_PREPARE_PREFIX])
  dnl AC_REQUIRE([AC_LIB_RPATH])

  dnl Search for libiconv and define LIBICONV, LTLIBICONV and INCICONV
  dnl accordingly.
  dnl AC_LIB_LINKFLAGS_BODY([iconv])

  AC_MSG_CHECKING([if libiconv is present])
  ac_save_LIBS="$LIBS"
  LIBS="$ac_save_LIBS -liconv"
  AC_TRY_LINK(,
    [;],
    LIBICONV="-liconv"
    ac_liconv="yes",
    LIBS="$ac_save_LIBS"
    ac_liconv="no")
  AC_MSG_RESULT($ac_liconv)
  dnl Add $INCICONV to CPPFLAGS before performing the following checks,
  dnl because if the user has installed libiconv and not disabled its use
  dnl via --without-libiconv-prefix, he wants to use it. The first
  dnl AC_TRY_LINK will then fail, the second AC_TRY_LINK will succeed.
  am_save_CPPFLAGS="$CPPFLAGS"
  dnl AC_LIB_APPENDTOVAR([CPPFLAGS], [$INCICONV])

  AC_CACHE_CHECK(for iconv, am_cv_func_iconv, [
    am_cv_func_iconv="no, consider installing GNU libiconv"
    am_cv_lib_iconv=no
    AC_TRY_LINK([#include <stdlib.h>
#include <iconv.h>],
      [iconv_t cd = iconv_open("","");
       iconv(cd,NULL,NULL,NULL,NULL);
       iconv_close(cd);],
      am_cv_func_iconv=yes)
    if test "$am_cv_func_iconv" != yes; then
      am_save_LIBS="$LIBS"
      LIBS="$LIBS $LIBICONV"
      AC_TRY_LINK([#include <stdlib.h>
#include <iconv.h>],
        [iconv_t cd = iconv_open("","");
         iconv(cd,NULL,NULL,NULL,NULL);
         iconv_close(cd);],
        am_cv_lib_iconv=yes
        am_cv_func_iconv=yes)
      LIBS="$am_save_LIBS"
    fi
  ])
  if test "$am_cv_func_iconv" = yes; then
    AC_DEFINE(HAVE_ICONV, 1, [Define if you have the iconv() function.])
  fi
  if test "$am_cv_lib_iconv" = yes; then
    AC_MSG_CHECKING([how to link with libiconv])
    AC_MSG_RESULT([$LIBICONV])
  else
    dnl If $LIBICONV didn't lead to a usable library, we don't need $INCICONV
    dnl either.
    CPPFLAGS="$am_save_CPPFLAGS"
    LIBICONV=
    LTLIBICONV=
  fi
  if test "$am_cv_func_iconv" != "yes" ; then
   if  test "$am_cv_lib_iconv" != "yes" ; then
      AC_MSG_ERROR(
        No iconv installation found. Either you have a very old libc or a system that doesn't support
        this function. Perhaps you should install the library libiconv from Bruno Haible.
       )
   fi
  fi



  AC_SUBST(LIBICONV)
  AC_SUBST(LTLIBICONV)
])

AC_DEFUN([AM_ICONV],
[
  AC_REQUIRE([AM_ICONV_LINK])
  if test "$am_cv_func_iconv" = yes; then
    AC_MSG_CHECKING([for iconv declaration])
    AC_CACHE_VAL(am_cv_proto_iconv, [
      AC_TRY_COMPILE([
#include <stdlib.h>
#include <iconv.h>
extern
#ifdef __cplusplus
"C"
#endif
#if defined(__STDC__) || defined(__cplusplus)
size_t iconv (iconv_t cd, char * *inbuf, size_t *inbytesleft, char * *outbuf, size_t *outbytesleft);
#else
size_t iconv();
#endif
], [], am_cv_proto_iconv_arg1="", am_cv_proto_iconv_arg1="const")
      am_cv_proto_iconv="extern size_t iconv (iconv_t cd, $am_cv_proto_iconv_arg1 char * *inbuf, size_t *inbytesleft, char * *outbuf, size_t *outbytesleft);"])
    am_cv_proto_iconv=`echo "[$]am_cv_proto_iconv" | tr -s ' ' | sed -e 's/( /(/'`
    AC_MSG_RESULT([$]{ac_t:-
         }[$]am_cv_proto_iconv)
    AC_DEFINE_UNQUOTED(ICONV_CONST, $am_cv_proto_iconv_arg1,
      [Define as const if the declaration of iconv() needs const.])
  fi
])

























dnl the whole CHECK_PYTHON functions are based on the KDE configure script


AC_DEFUN(AC_FIND_FILE,
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    echo "configure: __oline__: $i/$j" >&AC_FD_CC
    if test -r "$i/$j"; then
      echo "taking that" >&AC_FD_CC
      $3=$i
      break 2
    fi
  done
done
])




AC_DEFUN(HK_CHECK_LIBDL,
[
AC_CHECK_LIB(dl, dlopen, [
LIBDL="-ldl"
ac_cv_have_dlfcn=yes
])

AC_CHECK_LIB(dld, shl_unload, [
LIBDL="-ldld"
ac_cv_have_shload=yes
])

AC_SUBST(LIBDL)
])





AC_DEFUN(HK_CHECK_LIBPTHREAD,
[
AC_CHECK_LIB(pthread, pthread_create, [LIBPTHREAD="-lpthread"] )
AC_SUBST(LIBPTHREAD)
])






AC_DEFUN(HK_TRY_LINK_PYTHON,
[
if test "$kde_python_link_found" = no; then

if test "$1" = normal; then
  AC_MSG_CHECKING(if a Python application links)
else
  AC_MSG_CHECKING(if Python depends on $2)
fi

AC_CACHE_VAL(kde_cv_try_link_python_$1,
[
AC_LANG_SAVE
AC_LANG_C
kde_save_cflags="$CFLAGS"
CFLAGS="$CFLAGS $PYTHONINC"
kde_save_libs="$LIBS"
LIBS="$LIBS $LIBPYTHON $2 $LIBDL $LIBSOCKET"
kde_save_ldflags="$LDFLAGS"
LDFLAGS="$LDFLAGS $PYTHONLIB"

AC_TRY_LINK(
[
#include <Python.h>
],[
	PySys_SetArgv(1, 0);
],
	[kde_cv_try_link_python_$1=yes],
	[kde_cv_try_link_python_$1=no]
)
CFLAGS="$kde_save_cflags"
LIBS="$kde_save_libs"
LDFLAGS="$kde_save_ldflags"
])

if test "$kde_cv_try_link_python_$1" = "yes"; then
  AC_MSG_RESULT(yes)
  kde_python_link_found=yes
  if test ! "$1" = normal; then
    LIBPYTHON="$LIBPYTHON $2"
  fi
  $3
else
  AC_MSG_RESULT(no)
  $4
fi
AC_LANG_RESTORE

fi

])

AC_DEFUN(HK_CHECK_PYTHON_DIR,
[
AC_MSG_CHECKING([for Python directory])

AC_CACHE_VAL(kde_cv_pythondir,
[
  if test -z "$PYTHONDIR"; then
    kde_cv_pythondir=/usr/local
  else
    kde_cv_pythondir="$PYTHONDIR"
  fi
])




AC_ARG_WITH(pythondir,
[  --with-pythondir=pythondir   use python installed in pythondir ],
[
  ac_python_dir=$withval
], ac_python_dir=$kde_cv_pythondir
)







AC_MSG_RESULT($ac_python_dir)
])

AC_DEFUN(HK_CHECK_PYTHON_INTERN,
[
AC_REQUIRE([HK_CHECK_LIBDL])
AC_REQUIRE([HK_CHECK_LIBPTHREAD])
AC_REQUIRE([HK_CHECK_PYTHON_DIR])

if test -z "$1"; then
  version="1.5"
else
  version="$1"
fi

AC_MSG_CHECKING([for Python$version])

python_incdirs="$ac_python_dir/include /usr/include /usr/local/include/ $kde_extra_includes"
AC_FIND_FILE(Python.h, $python_incdirs, python_incdir)
if test ! -r $python_incdir/Python.h; then
  AC_FIND_FILE(python$version/Python.h, $python_incdirs, python_incdir)
  python_incdir=$python_incdir/python$version
  if test ! -r $python_incdir/Python.h; then
    python_incdir=no
  fi
fi

PYTHONINC=-I$python_incdir

python_libdirs="$ac_python_dir/lib /usr/lib /usr/local /usr/lib $kde_extra_libs"
AC_FIND_FILE(libpython$version.a, $python_libdirs, python_libdir)
if test ! -r $python_libdir/libpython$version.a; then
  AC_FIND_FILE(python$version/config/libpython$version.a, $python_libdirs, python_libdir)
  python_libdir=$python_libdir/python$version/config
  if test ! -r $python_libdir/libpython$version.a; then
    python_libdir=no
  fi
fi

PYTHONLIB=-L$python_libdir
kde_orig_LIBPYTHON=$LIBPYTHON
if test -z "$LIBPYTHON"; then
  LIBPYTHON=-lpython$version
fi

python_libdirs="$ac_python_dir/lib /usr/lib /usr/local /usr/lib $kde_extra_libs"
AC_FIND_FILE(python$version/copy.py, $python_libdirs, python_moddir)
python_moddir=$python_moddir/python$version
if test ! -r $python_moddir/copy.py; then
  python_moddir=no
fi

PYTHONMODDIR=$python_moddir

AC_MSG_RESULT(header $python_incdir library $python_libdir modules $python_moddir)

if test x$python_incdir = xno ||  test x$python_libdir = xno ||  test x$python_moddir = xno; then
   LIBPYTHON=$kde_orig_LIBPYTHON
   test "x$PYTHONLIB" = "x-Lno" && PYTHONLIB=""
   test "x$PYTHONINC" = "x-Ino" && PYTHONINC=""
   $2
else
  dnl Note: this test is very weak
  kde_python_link_found=no
  HK_TRY_LINK_PYTHON(normal)
  HK_TRY_LINK_PYTHON(m, -lm)
  HK_TRY_LINK_PYTHON(pthread, $LIBPTHREAD)
  HK_TRY_LINK_PYTHON(tcl, -ltcl)
  HK_TRY_LINK_PYTHON(db2, -ldb2)
  HK_TRY_LINK_PYTHON(m_and_thread, [$LIBPTHREAD -lm])
  HK_TRY_LINK_PYTHON(m_and_thread_and_util, [$LIBPTHREAD -lm -lutil])
  HK_TRY_LINK_PYTHON(m_and_thread_and_db3, [$LIBPTHREAD -lm -ldb-3 -lutil])
  HK_TRY_LINK_PYTHON(pthread_and_db3, [$LIBPTHREAD -ldb-3])
  HK_TRY_LINK_PYTHON(m_and_thread_and_db, [$LIBPTHREAD -lm -ldb -ltermcap -lutil])
  HK_TRY_LINK_PYTHON(pthread_and_dl, [$LIBPTHREAD $LIBDL -lutil -lreadline -lncurses -lm])
  HK_TRY_LINK_PYTHON(m_and_thread_and_db_special, [$LIBPTHREAD -lm -ldb -lutil], [],
	[AC_MSG_ERROR([it seems, Python depends on another library.
    Pleae set LIBPYTHON to '-lpython$version -lotherlib' before calling configure to fix this
    and contact the authors to let them know about this problem])
	])

  LIBPYTHON="$LIBPYTHON $LIBDL $LIBSOCKET"
  AC_SUBST(PYTHONINC)
  AC_SUBST(PYTHONLIB)
  AC_SUBST(LIBPYTHON)
  AC_SUBST(PYTHONMODDIR)
HKPYTHONDIR="python"
  AC_DEFINE(HAVE_PYTHON, 1, [Define if you have the development files for python])
fi

])


AC_DEFUN(HK_CHECK_PYTHON,
[
  HK_CHECK_PYTHON_INTERN("2.3",
    [HK_CHECK_PYTHON_INTERN("2.2",
    [HK_CHECK_PYTHON_INTERN("2.1",
      [HK_CHECK_PYTHON_INTERN("2.0", [ HK_CHECK_PYTHON_INTERN($1, $2) ])
  ])])])
])



AC_DEFUN(HK_SQLITE2TEST,
[
AC_MSG_CHECKING([whether SQLITE2 is available])
if test "$with_sqlite_dir" = ""; then
   SQLITELIBDIR=/usr/local/lib
   SQLITEINCDIR=/usr/local/include
else SQLITELIBDIR=$with_sqlite_dir/lib
SQLITEINCDIR=$with_sqlite_dir/include
fi

if test "x$with_sqlite_incdir" != "x"; then
 SQLITEINCDIR=$with_mysql_incdir
fi

if test "x$with_sqlite_libdir" != "x"; then
 SQLITELIBDIR=$with_sqlite_libdir
fi


ac_save_LIBS="$LIBS"
ac_save_CPPFLAGS="$CPPFLAGS"
ac_save_CXXLIBS="$CXXLIBS"

CXXLIBS="$ac_save_CXXLIBS -L${SQLITELIBDIR} -lsqlite"
LIBS="$ac_save_LIBS -L${SQLITELIBDIR} -lsqlite"
CPPFLAGS="$ac_save_CPPFLAGS -I$SQLITEINCDIR"

AC_TRY_LINK([#include <sqlite.h>],[char* errormsg=0;
sqlite* mydb=sqlite_open("",0,&errormsg);
sqlite_vm *vm=0;
int result =sqlite_compile(mydb,"",0,&vm,&errormsg);
;],[sqlite_lib=yes],[sqlite_lib=no])

AC_MSG_RESULT($sqlite_lib)
if test $sqlite_lib = yes ; then
NODRIVER=false
DRIVERSDIR="$DRIVERSDIR hk_sqliteclasses"
AC_SUBST(SQLITELIBDIR)
AC_SUBST(SQLITEINCDIR)
fi


LIBS="$ac_save_LIBS"
CPPFLAGS="$ac_save_CPPFLAGS"
CXXLIBS="$ac_save_CXXLIBS"


])



