#ifndef __pluginh__
  #include "../plugin.h"
#endif
#ifndef __htmlh__
  #include "../html.h"
#endif
#ifndef __parammaph__
  #include "../parammap.h"
#endif
#ifndef __hitopcommandsh__
  #include "../hitopcommands.h"
#endif
#ifndef __errorh__
  #include "../error.h"
#endif

#include <iostream>
#include <ctime>
#include <vector>

class dsoSchedMod :public Plugin{
public:
  dsoSchedMod();
  virtual void Init();
  static HTMLStream::iterator CLEAR(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag);
  static HTMLStream::iterator ADDTASK(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag);
  static HTMLStream::iterator OUTPUT(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag);
private:
  class SchedEntry {
  public:
    string task;
    int duration;
    bool firstslot;
    SchedEntry(const string& t,int d,bool start) : task(t), duration(d), firstslot(start) {};
    SchedEntry(): task(),duration(-1),firstslot(true) {};
    operator bool () {return duration>=0;};
  };
  static vector<vector<dsoSchedMod::SchedEntry> > sched;
  static int concurrencies;
  static int start;
  static int end;
  static void resize(int width);
  static bool test(int x, int y, int d);
};

static dsoSchedMod initmodule;
int dsoSchedMod::concurrencies;
int dsoSchedMod::start;
int dsoSchedMod::end;
vector<vector<dsoSchedMod::SchedEntry> > dsoSchedMod::sched;



dsoSchedMod::dsoSchedMod() {
  RegisterPlugin("scheduler",1);
};

void dsoSchedMod::Init() {
  SetNamespace("SCHEDULER");
  RegisterCommand("CLEAR",&CLEAR);
  RegisterCommand("ADDTASK",&ADDTASK);
  RegisterCommand("OUTPUT",&OUTPUT);
  concurrencies=-1;
  start=8;
  end=18;
  sched.resize(11);
}

HTMLStream::iterator dsoSchedMod::CLEAR(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag) {
  sched.clear();
  concurrencies=-1;
  string param;
  if (paramMap.Retrieve("START",param)) {
    start = atoi(param.c_str());
  } else {
    start = 8;
  }
  if (paramMap.Retrieve("END",param)) {
    end=atoi(param.c_str());
  } else {
    end = 18;
  }
  if (end<start) {
    Error(*Cur,"Scheduler initialised with start slot after end slot");
  }
  sched.resize(end-start+1);
  HTMLStream::iterator Next =Cur;
  ++Next;
  stream.m_stream.erase(Cur);
  return Next;
}

bool dsoSchedMod::test(int x, int y, int d) {
  if (x>concurrencies) {
    resize(x+1);
    concurrencies=x;
    return true;
  }
  for (int i=y-start;i<=d-start;++i) {
    if (sched[i][x]) return false;
  }
  return true;
}

void dsoSchedMod::resize(int width) {
  for (int i=0; i<=(end-start); ++i) {
    sched[i].resize(width);
  }
}

HTMLStream::iterator dsoSchedMod::ADDTASK(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag) {
  string param;
  int sstart=0,send;
  if (paramMap.Retrieve("START",param)) {
    sstart=atoi(param.c_str());
  } else {
    Error(*Cur,"No start position given");
  }
  if (paramMap.Retrieve("DURATION",param)) {
    send=sstart+atoi(param.c_str())-1;
  } else {
    send=sstart;
  }
  if (!paramMap.Retrieve("TASK",param)) {
    Error(*Cur,"No TASK value given");
  }
  if (send>end) send=end;
  if (sstart<start) sstart=start;
  int x=0;
  while (!test(x,sstart,send)) ++x;
  for (int i=sstart; i<=send; ++i) {
    sched[i-start][x]=SchedEntry(param,send-i,(i==sstart));
  }
  HTMLStream::iterator Next =Cur;
  ++Next;
  stream.m_stream.erase(Cur);
  return Next;
}

HTMLStream::iterator dsoSchedMod::OUTPUT(HTMLStream& stream,HTMLStream::iterator Cur,const ParamMap& paramMap,const string& tag){
  string prerow,postrow,empty,filled,tstart,tend;
  bool stretch = paramMap.Retrieve("STRETCH",prerow);
  paramMap.Retrieve("PREROW",prerow);
  paramMap.Retrieve("POSTROW",postrow);
  paramMap.Retrieve("FREETIME",empty);
  paramMap.Retrieve("BUSYTIME",filled);
  paramMap.Retrieve("PRETABLE",tstart);
  paramMap.Retrieve("POSTTABLE",tend);
  ParamMap rowmap=paramMap;
  ParamMap cellmap=paramMap;
  ParamMap tblmap=paramMap;
  tblmap["WIDTH"]=IToS(concurrencies+1);
  if (!tstart.empty()) HitopCommands::UserEngine(stream,Cur,tblmap,tstart);
  for (int y=0; y<=end-start; ++y) {
    rowmap["ROW"]=IToS(y+start);
    cellmap["ROW"]=IToS(y+start);
    int freetime=0;
    if (!prerow.empty())     HitopCommands::UserEngine(stream,Cur,rowmap,prerow);
    
    for (int x=0; x<=concurrencies; ++x) {
      if (sched[y][x]) {
        if ((freetime>0)&&(!empty.empty())) {
	        cellmap["WIDTH"]=IToS(freetime);
		      cellmap["DURATION"]="1";
		      HitopCommands::UserEngine(stream,Cur,cellmap,empty);
	      }
	      freetime=0;
	      if ((sched[y][x].firstslot)&&(!filled.empty())) {
	        int k=x;
		      while ((stretch)&&(k<concurrencies)&&(test(++k,y+start,y+sched[y][x].duration+start)));
  	      cellmap["WIDTH"]=IToS(1+k-x);
	        cellmap["TASK"]=sched[y][x].task;
		      cellmap["DURATION"]=IToS(sched[y][x].duration+1);
 		      HitopCommands::UserEngine(stream,Cur,cellmap,filled);
		      x=k;
		    }
      } else {
        ++freetime;
      }
    }
    if ((freetime>0)&&(!empty.empty())) {
      cellmap["WIDTH"]=IToS(freetime);
	    cellmap["DURATION"]="1";
	    HitopCommands::UserEngine(stream,Cur,cellmap,empty);
    }
    
    if (!postrow.empty())    HitopCommands::UserEngine(stream,Cur,rowmap,postrow);
  }
  if (!tend.empty()) HitopCommands::UserEngine(stream,Cur,tblmap,tend);
  HTMLStream::iterator Next =Cur;
  ++Next;
  stream.m_stream.erase(Cur);
  return Next;
}

