#ifndef __pluginh__
  #include "../plugin.h"
#endif
#ifndef __errorh__
  #include "../error.h"
#endif
#ifndef __polytypeh__
  #include "../polytype.h"
#endif

#include <string>
#include <vector>
#include <cstdio>
#include <cmath>

class dsoMathMod :public Plugin{
public:
  dsoMathMod();
  virtual void Init();
private:
  static void SIN(__HITOPFUNC__);
  static void COS(__HITOPFUNC__);
  static void TAN(__HITOPFUNC__);
  static void RADIANS(__HITOPFUNC__);
};

static dsoMathMod initmodule;

dsoMathMod::dsoMathMod() {
  RegisterPlugin(string("math"),1);
}

void dsoMathMod::Init(){
  RegisterFunction("SIN",SIN);
  RegisterFunction("COS",COS);
  RegisterFunction("TAN",TAN);
  RegisterFunction("RADIANS",RADIANS);
}

void dsoMathMod::SIN(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"SIN",e_ParamNone);
  data=sin(data.AsDouble());
}

void dsoMathMod::COS(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"COS",e_ParamNone);
  data=cos(data.AsDouble());
}

void dsoMathMod::TAN(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"TAN",e_ParamNone);
  data=tan(data.AsDouble());
}

void dsoMathMod::RADIANS(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"RADIANS",e_ParamNone);
  data=data.AsDouble()*0.017453292519943295769236907684886;
}
