#ifndef __pluginh__
  #include "../plugin.h"
#endif
#ifndef __errorh__
  #include "../error.h"
#endif
#ifndef __polytypeh__
  #include "../polytype.h"
#endif

#include <string>
#include <vector>
#include <cstdio>

class dsoDeutschMod :public Plugin{
public:
  dsoDeutschMod();
  virtual void Init();
private:
  static void DAYNAME(__HITOPFUNC__);
  static void MONTHNAME(__HITOPFUNC__);
  static void DAYSHORTNAME(__HITOPFUNC__);
  static void MONTHSHORTNAME(__HITOPFUNC__);
  static void DAYABBREV(__HITOPFUNC__);
  static void MONTHABBREV(__HITOPFUNC__);
};

static dsoDeutschMod initmodule;

static const string daynames[]={"Sonntag","Montag","Dienstag","Mittwoch",
  "Donnerstag","Freitag","Samstag"};
static const string monthnames[]={"Januar","Februar","M&auml;rz","April",
  "Mai","Juni","Juli","August","September","Oktober","November","Dezember"};
static const string dayshortnames[]={"Son","Mon","Die","Mit","Don","Fre",
  "Sam"};
static const string monthshortnames[]={"Jan","Feb","M&auml;r","Apr","Mai",
  "Jun","Jul","Aug","Sep","Okt","Nov","Dez"};
static const string dayabbrevs[]={"So","Mo","Di","Mi","Do","F","Sa"};
static const string monthabbrevs[]={"Jan","Feb","M&auml;r","Apr","Mai",
  "Jun","Jul","Aug","Sep","Okt","Nov","Dez"};

dsoDeutschMod::dsoDeutschMod() {
  RegisterPlugin(string("deutsch"),1);
}

void dsoDeutschMod::Init(){
  SetNamespace("DEUTSCH");
  RegisterFunction("DAYNAME",&DAYNAME);
  RegisterFunction("MONTHNAME",&MONTHNAME);
  RegisterFunction("DAYSHORTNAME",&DAYSHORTNAME);
  RegisterFunction("MONTHSHORTNAME",&MONTHSHORTNAME);
  RegisterFunction("DAYABBREV",&DAYABBREV);
  RegisterFunction("MONTHABBREV",&MONTHABBREV);
}

void dsoDeutschMod::DAYNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"DAYNAME",e_ParamNone);
  data=daynames[data.AsInt()%7];
}

void dsoDeutschMod::MONTHNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"MONTHNAME",e_ParamNone);
  data=monthnames[(data.AsInt()-1)%12];
}

void dsoDeutschMod::DAYSHORTNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"DAYSHORTNAME",e_ParamNone);
  data=dayshortnames[data.AsInt()%7];
}

void dsoDeutschMod::MONTHSHORTNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"DAYABBREV",e_ParamNone);
  data=monthshortnames[(data.AsInt()-1)%12];
}

void dsoDeutschMod::DAYABBREV(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=dayabbrevs[data.AsInt()%7];
}

void dsoDeutschMod::MONTHABBREV(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=monthabbrevs[(data.AsInt()-1)%12];
}
