{- This module was generated from data in the Kate syntax
   highlighting file objectivec.xml, version 1.07, by  -}

module Text.Highlighting.Kate.Syntax.Objectivec
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Objective-C"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.m;*.h"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Objective-C","Default")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Objective-C","Default") -> return ()
      ("Objective-C","String") -> (popContext) >> pEndLine
      ("Objective-C","SingleLineComment") -> (popContext) >> pEndLine
      ("Objective-C","MultiLineComment") -> return ()
      ("Objective-C","Preprocessor") -> pushContext ("Objective-C","Default") >> return ()
      ("Objective-C","MultiLineCommentPrep") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "break case continue default do else enum extern for goto if return sizeof struct switch typedef union while @class @defs @encode @end @implementation @interface @private @protected @protocol @public @selector self super"
list_types = Set.fromList $ words $ "auto char const double float int long register short signed static unsigned void volatile"

regex_'23 = compileRegex "#"

parseRules ("Objective-C","Default") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   (withChildren (pFloat >>= withAttribute FloatTok) ((pAnyChar "fF" >>= withAttribute FloatTok)))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   (withChildren (pInt >>= withAttribute DecValTok) (((pString False "ULL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LUL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LLU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "UL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "U" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "L" >>= withAttribute DecValTok))))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Objective-C","String"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C","SingleLineComment"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C","MultiLineComment"))
   <|>
   ((pAnyChar ":!%&()+,-/.*<=>?[]|~^;" >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'23 >>= withAttribute OtherTok) >>~ pushContext ("Objective-C","Preprocessor"))
   <|>
   ((pDetect2Chars False '@' '"' >>= withAttribute StringTok) >>~ pushContext ("Objective-C","String"))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C","Default")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Objective-C","String") =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Objective-C","SingleLineComment") =
  (currentContext >>= \x -> guard (x == ("Objective-C","SingleLineComment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("Objective-C","MultiLineComment") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C","MultiLineComment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Objective-C","Preprocessor") =
  (((pLineContinue >>= withAttribute OtherTok))
   <|>
   ((pRangeDetect '"' '"' >>= withAttribute OtherTok))
   <|>
   ((pRangeDetect '<' '>' >>= withAttribute OtherTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression >>= ((withAttribute OtherTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C","SingleLineComment"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Objective-C","MultiLineCommentPrep"))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C","Preprocessor")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Objective-C","MultiLineCommentPrep") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Objective-C","MultiLineCommentPrep")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Doxygen", _) = Text.Highlighting.Kate.Syntax.Doxygen.parseExpression

parseRules x = parseRules ("Objective-C","Default") <|> fail ("Unknown context" ++ show x)
