{- This module was generated from data in the Kate syntax
   highlighting file email.xml, version 1.00, by Carl A Joslin (carl.joslin@joslin.dyndns.org) -}

module Text.Highlighting.Kate.Syntax.Email
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "Email"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.eml"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Email","headder")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = False, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Email","headder") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'5bTt'5do'3a'2e'2a'24 = compileRegex "[Tt]o:.*$"
regex_'5bFf'5drom'3a'2e'2a'24 = compileRegex "[Ff]rom:.*$"
regex_'5bCc'5d'5bCc'5d'3a'2e'2a'24 = compileRegex "[Cc][Cc]:.*$"
regex_'5bBb'5d'5bCc'5d'5bCc'5d'3a'2e'2a'24 = compileRegex "[Bb][Cc][Cc]:.*$"
regex_'5bSs'5dubject'3a'2e'2a'24 = compileRegex "[Ss]ubject:.*$"
regex_'5bDd'5date'3a'2e'2a'24 = compileRegex "[Dd]ate:.*$"
regex_'5bSs'5dender'3a = compileRegex "[Ss]ender:"
regex_'5bRr'5deply'2d'5bTt'5do'3a = compileRegex "[Rr]eply-[Tt]o:"
regex_'5bMm'5dessage'2d'5bIi'5d'5bDd'5d'3a = compileRegex "[Mm]essage-[Ii][Dd]:"
regex_'5bIi'5dn'2d'5bRr'5deply'2d'5bTt'5do'3a = compileRegex "[Ii]n-[Rr]eply-[Tt]o:"
regex_'5bRr'5deferences'3a = compileRegex "[Rr]eferences:"
regex_'5bCc'5domments'3a = compileRegex "[Cc]omments:"
regex_'5bKk'5deywors'3a = compileRegex "[Kk]eywors:"
regex_'5bRr'5desent'2d'5bDd'5date'3a = compileRegex "[Rr]esent-[Dd]ate:"
regex_'5bRr'5desent'2d'5bFf'5drom'3a = compileRegex "[Rr]esent-[Ff]rom:"
regex_'5bRr'5desent'2d'5bSs'5dender'3a = compileRegex "[Rr]esent-[Ss]ender:"
regex_'5bRr'5desent'2d'5bTt'5do'3a = compileRegex "[Rr]esent-[Tt]o:"
regex_'5bRr'5desent'2d'5bCc'5d'5bCc'5d'3a = compileRegex "[Rr]esent-[Cc][Cc]:"
regex_'5bRr'5desent'2d'5bBb'5d'5bCc'5d'5bCc'5d'3a = compileRegex "[Rr]esent-[Bb][Cc][Cc]:"
regex_'5bRr'5desent'2d'5bMm'5dessage'2d'5bIi'5d'5bDd'5d'3a = compileRegex "[Rr]esent-[Mm]essage-[Ii][Dd]:"
regex_'5bRr'5desent'2d'5bRr'5deply'2d'5bTt'5do'3a = compileRegex "[Rr]esent-[Rr]eply-[Tt]o:"
regex_'5bRr'5deturn'2d'5bPp'5dath'3a = compileRegex "[Rr]eturn-[Pp]ath:"
regex_'5bRr'5deceived'3a = compileRegex "[Rr]eceived:"
regex_'5bXx'5d'2d'5bMm'5dozilla'2d'5bSs'5dtatus'3a = compileRegex "[Xx]-[Mm]ozilla-[Ss]tatus:"
regex_'5bXx'5d'2d'5bMm'5dozilla'2d'5bSs'5dtatus2'3a = compileRegex "[Xx]-[Mm]ozilla-[Ss]tatus2:"
regex_'5bEe'5dnverlope'2d'5bTt'5do'3a = compileRegex "[Ee]nverlope-[Tt]o:"
regex_'5bDd'5delivery'2d'5bDd'5date'3a = compileRegex "[Dd]elivery-[Dd]ate:"
regex_'5bXx'5d'2d'5bOo'5driginating'2d'5bIi'5d'5bPp'5d'3a = compileRegex "[Xx]-[Oo]riginating-[Ii][Pp]:"
regex_'5bXx'5d'2d'5bOo'5driginating'2d'5bEe'5dmail'3a = compileRegex "[Xx]-[Oo]riginating-[Ee]mail:"
regex_'5bXx'5d'2d'5bSs'5dender'3a = compileRegex "[Xx]-[Ss]ender:"
regex_'5bMm'5dime'2d'5bVv'5dersion'3a = compileRegex "[Mm]ime-[Vv]ersion:"
regex_'5bCc'5dontent'2d'5bTt'5dype'3a = compileRegex "[Cc]ontent-[Tt]ype:"
regex_'5bXx'5d'2d'5bMm'5dailing'2d'5bLl'5dist'3a = compileRegex "[Xx]-[Mm]ailing-[Ll]ist:"
regex_'5bXx'5d'2d'5bLl'5doop'3a = compileRegex "[Xx]-[Ll]oop:"
regex_'5bLl'5dist'2d'5bPp'5dost'3a = compileRegex "[Ll]ist-[Pp]ost:"
regex_'5bLl'5dist'2d'5bHh'5delp'3a = compileRegex "[Ll]ist-[Hh]elp:"
regex_'5bLl'5dist'2d'5bUu'5dnsubscribe'3a = compileRegex "[Ll]ist-[Uu]nsubscribe:"
regex_'5bPp'5drecedence'3a = compileRegex "[Pp]recedence:"
regex_'5bCc'5dontent'2d'5bTt'5dransfer'2d'5bEe'5dncoding'3a = compileRegex "[Cc]ontent-[Tt]ransfer-[Ee]ncoding:"
regex_'5bXx'5d'2d'5bBb'5dulkmail'3a = compileRegex "[Xx]-[Bb]ulkmail:"
regex_'5bCc'5dontent'2d'5bDd'5disposition'3a = compileRegex "[Cc]ontent-[Dd]isposition:"
regex_'5b0'2d9a'2dzA'2dZ'2d'2e'5d'2b'3a = compileRegex "[0-9a-zA-Z-.]+:"
regex_'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'5c'40'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b = compileRegex "[a-zA-Z0-9.\\-]+\\@[a-zA-Z0-9.\\-]+"
regex_'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2a'5cs'2a'3c'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'5c'40'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'3e = compileRegex "[a-zA-Z0-9.\\-]*\\s*<[a-zA-Z0-9.\\-]+\\@[a-zA-Z0-9.\\-]+>"
regex_'22'5ba'2dzA'2dZ0'2d9'2e_'5c'2d'5d'2b'22'5cs'2a'3c'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'5c'40'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'3e = compileRegex "\"[a-zA-Z0-9. \\-]+\"\\s*<[a-zA-Z0-9.\\-]+\\@[a-zA-Z0-9.\\-]+>"
regex_'22'2e'2a'22 = compileRegex "\".*\""
regex_'27'2e'2a'27 = compileRegex "'.*'"
regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a = compileRegex "[|>]\\s*[|>]\\s*[|>]\\s*[|>]\\s*[|>]\\s*[|>].*"
regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a = compileRegex "[|>]\\s*[|>]\\s*[|>]\\s*[|>]\\s*[|>].*"
regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a = compileRegex "[|>]\\s*[|>]\\s*[|>]\\s*[|>].*"
regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a = compileRegex "[|>]\\s*[|>]\\s*[|>].*"
regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a = compileRegex "[|>]\\s*[|>].*"
regex_'5b'7c'3e'5d'2e'2a = compileRegex "[|>].*"
regex_'28'5bA'2dZa'2dz0'2d9'2b'2f'5d'5bA'2dZa'2dz0'2d9'2b'2f'5d'5bA'2dZa'2dz0'2d9'2b'2f'5d'5bA'2dZa'2dz0'2d9'2b'2f'5d'29'7b10'2c20'7d'24 = compileRegex "([A-Za-z0-9+/][A-Za-z0-9+/][A-Za-z0-9+/][A-Za-z0-9+/]){10,20}$"
regex_'5bA'2dZa'2dz0'2d9'2b'3d'2f'5d'2b'3d'24 = compileRegex "[A-Za-z0-9+=/]+=$"
regex_'28'2d_'29'3f'2d'2d'28'2d'2d'2e'2a'29'3f = compileRegex "(- )?--(--.*)?"

parseRules ("Email","headder") =
  (((pColumn 0 >> pRegExpr regex_'5bTt'5do'3a'2e'2a'24 >>= withAttribute AlertTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bFf'5drom'3a'2e'2a'24 >>= withAttribute AlertTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bCc'5d'5bCc'5d'3a'2e'2a'24 >>= withAttribute AlertTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bBb'5d'5bCc'5d'5bCc'5d'3a'2e'2a'24 >>= withAttribute AlertTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bSs'5dubject'3a'2e'2a'24 >>= withAttribute AlertTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bDd'5date'3a'2e'2a'24 >>= withAttribute AlertTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bSs'5dender'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bRr'5deply'2d'5bTt'5do'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bMm'5dessage'2d'5bIi'5d'5bDd'5d'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bIi'5dn'2d'5bRr'5deply'2d'5bTt'5do'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bRr'5deferences'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bCc'5domments'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bKk'5deywors'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bDd'5date'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bFf'5drom'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bSs'5dender'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bTt'5do'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bCc'5d'5bCc'5d'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bBb'5d'5bCc'5d'5bCc'5d'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bMm'5dessage'2d'5bIi'5d'5bDd'5d'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bRr'5deply'2d'5bTt'5do'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bRr'5deturn'2d'5bPp'5dath'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bRr'5deceived'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bMm'5dozilla'2d'5bSs'5dtatus'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bMm'5dozilla'2d'5bSs'5dtatus2'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bEe'5dnverlope'2d'5bTt'5do'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bDd'5delivery'2d'5bDd'5date'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bOo'5driginating'2d'5bIi'5d'5bPp'5d'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bOo'5driginating'2d'5bEe'5dmail'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bSs'5dender'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bMm'5dime'2d'5bVv'5dersion'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bCc'5dontent'2d'5bTt'5dype'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bMm'5dailing'2d'5bLl'5dist'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bLl'5doop'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bLl'5dist'2d'5bPp'5dost'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bLl'5dist'2d'5bHh'5delp'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bLl'5dist'2d'5bUu'5dnsubscribe'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bPp'5drecedence'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bCc'5dontent'2d'5bTt'5dransfer'2d'5bEe'5dncoding'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bCc'5dontent'2d'5bTt'5dype'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bBb'5dulkmail'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bPp'5drecedence'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bCc'5dontent'2d'5bDd'5disposition'3a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5b0'2d9a'2dzA'2dZ'2d'2e'5d'2b'3a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'5c'40'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2a'5cs'2a'3c'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'5c'40'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'3e >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'22'5ba'2dzA'2dZ0'2d9'2e_'5c'2d'5d'2b'22'5cs'2a'3c'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'5c'40'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'3e >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'22'2e'2a'22 >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'27'2e'2a'27 >>= withAttribute StringTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5b'7c'3e'5d'2e'2a >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'28'5bA'2dZa'2dz0'2d9'2b'2f'5d'5bA'2dZa'2dz0'2d9'2b'2f'5d'5bA'2dZa'2dz0'2d9'2b'2f'5d'5bA'2dZa'2dz0'2d9'2b'2f'5d'29'7b10'2c20'7d'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5bA'2dZa'2dz0'2d9'2b'3d'2f'5d'2b'3d'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'28'2d_'29'3f'2d'2d'28'2d'2d'2e'2a'29'3f >>= withAttribute AlertTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Email","headder")) >> pDefault >>= withAttribute NormalTok))


parseRules x = parseRules ("Email","headder") <|> fail ("Unknown context" ++ show x)
