#!/usr/bin/perl
#
# Simple CGI script to show use of highlight on web servers 
# 
# Setup (for Apache WebServer) :
# - Copy this script into  your cgi-bin directory
# - apply "chmod 755" to it
# - make a directory "code" in htdocs
# - copy your source files to htdocs/code
# - copy a CSS file "highlight.css" generated by highlight
#   to htdocs/code
# - start your webserver (httpd), open your browser and type
#   "http://localhost/highlight.cgi?file=yourfile",
#   where "yourfile" is a source file located in htdocs/code.
#   Example: 
#   http://localhost/cgi-bin/highlight.cgi?file=main.cpp
#
#------------------------------------------------------------------------
#
# Einfaches CGI-Skript zur Demonstration von highlight auf
# einem Webserver
#
# Installation (mit Apache WebServer)
# - Kopiere dieses Skript in dein cgi-bin Verzeichnis
# - fhre "chmod 755" auf das Skript aus
# - lege ein Verzeichnis "code" in htdocs an
# - Kopiere den gewnschten Sourcecode in htdocs/code
# - Kopiere eine CSS-Datei "highlight.css", die zB. zuvor von
#   highlight generiert wurde, in htdocs/code
# - Starte Apache mit httpd, und ffne
#   "http://localhost/highlight.cgi?file=yourfile"
#   in einem Webbrowser, wobei "yourfile" der Name einer
#   Source-Datei in htdocs/code ist.
#   Beispiel: 
#   http://localhost/cgi-bin/highlight.cgi?file=main.cpp
#
#
#-------------------------------------------
#  Andr Simon, <andre.simon1@gmx.de>
#  Januar 2003



# Hash for Form Data
my %entries = ();
my $key;

%entries = &Parse;
&InsertHeader($entries{"file"});

#foreach $key (%entries)
#  {
#  print "entry\{\"$key\"\} = $entries{$key}<BR>\n";
#  }

&executeHighlight($entries{"file"});
&InsertTrailer;



sub executeHighlight
  {
  my ($sourcefile) = @_;
  open (INP, "| /usr/bin/highlight -If ../htdocs/code/$sourcefile");
  while (<INP>)
    {
      chop $_;
      print "$_\n";
    }
    close (INP);
  }

#get form parameters
sub Parse
  {
  my (@pairs, $pair, $value, $name, $in, %entry);
  if ($ENV{'REQUEST_METHOD'} eq "GET")
    { $in = $ENV{'QUERY_STRING'}; }
  elsif ($ENV{'REQUEST_METHOD'} eq "POST")
    { read(STDIN, $in, $ENV{'CONTENT_LENGTH'}+1); }

  @pairs = split(/&/, $in);
  foreach $pair (@pairs)
    {
    # do the special character conversion (%xx)
    $pair =~ tr/+/ /;
    $pair =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack("C",hex($1))/ge;
    # prevent from SSI
    $pair =~ s/<!--(.|\n)*-->//g;
    ($name, $value) = split(/=/, $pair);
    if (defined($entry{$name}))
      { $entry{$name} .= ":" . $value; }
    else
      { $entry{$name} = $value; }
    }
    return %entry;
  }

sub InsertHeader
  {
  my ($htmltitle) = @_;
  print "Content-type: text/html\n\n";
  print "<HTML>\n<HEAD>\n";
  print "<TITLE> $htmltitle </TITLE>\n";

  print "   <link rel=\"stylesheet\" type=\"text/css\""
  print " href=\"http://localhost/code/highlight.css\">\n";
  print "</head>\n";
  print "<BODY>\n";
  print "<pre>\n" ;
  }

sub InsertTrailer
  {
    print "</pre>\n</BODY>\n</HTML>\n";
  }
