/***************************************************************************
                          stringtools.cpp  -  description
                             -------------------
    begin                : Mon Dec 10 2001
    copyright            : (C) 2001 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "stringtools.h"

using namespace std;

namespace StringTools
  {
// Make a lowercase copy of s:
// (C) Bruce Eckel, Thinking in C++ Vol 2

string lowerCase(const string& s)
{
  char* buf = new char[s.length()];
  s.copy(buf, s.length());
  for(unsigned int i = 0; i < s.length(); i++)
    buf[i] = tolower(buf[i]);
  string r(buf, s.length());
  delete buf;
  return r;
}

/** wandelt String s in Integer um */
int str2int(string s)
{
  istringstream os(s);
  int intVal;
  os >> intVal;  
  return intVal;
}

 /** gibt True zurueck, falls c ein Buchstabe/Underscore ist */
 bool isAlpha(unsigned char c)
 {
   return (isalpha(c) || c == '_');
 }

string trimRight(const string &value)
 {
  string::size_type where = value.find_last_not_of(" \t");
  
  if (where == string::npos)
   // string has nothing but space
   return string();
   
  if (where == (value.length() - 1))
   // string has no trailing space, don't copy its contents
   return value;
   
  return value.substr(0, where + 1);
 }

/** gibt naechsten Character der Zeile zurueck, der kein Whitespace ist */
unsigned char getNextNonWs(const string &line, int index)
{
  unsigned char c;  
  do
    {
      c=line[index++];
    }
  while (isspace(c));
  return c;
}

/*unsigned int getNextNonWsPos(const string &line, int index){
  return line.find_first_not_of(WS_CHARS, index);
}*/

}
