/***************************************************************************
                          rtfcode.cpp  -  description
                             -------------------
    begin                : Die Jul 9 2002
    copyright            : (C) 2002 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rtfcode.h"

using namespace std;

namespace highlight {

string  RtfCode::formatStyleAttributes( const ElementStyle & col)
{
  stringstream s;
  s  << "\\red"<< col.getColour().getRTFRedValue()
     << "\\green"<<col.getColour().getRTFGreenValue()
     << "\\blue"<<col.getColour().getRTFBlueValue()
     << ";";

  return s.str();
}

string  RtfCode::getOpenTag(int styleNumber,const ElementStyle & elem)
{
  stringstream s;
  s << "{\\cf"<<(styleNumber+1)<<"{";  
  s << ( elem.isBold() ?"\\b " :"" )
    << ( elem.isItalic() ?"\\i " :"" )
    << ( elem.isUnderline() ?"\\ul " :"" );  
  return  s.str();
}

string  RtfCode::getCloseTag(const ElementStyle &elem)
{
  stringstream s;
  s << ( elem.isBold() ?"\\b0 " :"" )
    << ( elem.isItalic() ?"\\i0 " :"" )
    << ( elem.isUnderline() ?"\\ul0 " :"" )
    << "}}";
  return  s.str();
}

RtfCode::RtfCode(const string &colourTheme,
                 bool printLineNumbers, bool fragment, int numSpaces, 
                 WrapMode wrapStyle)
    : CodeParser(printLineNumbers, colourTheme, numSpaces,
                 wrapStyle, fragment)
{
  styleTagOpen[STANDARD] =getOpenTag(STANDARD, docStyle.getDefaultStyle());
  styleTagOpen[KEYWORD] =getOpenTag(KEYWORD, docStyle.getKeywordStyle());
  styleTagOpen[TYPE] =getOpenTag(TYPE, docStyle.getTypeStyle());
  styleTagOpen[STRING] =getOpenTag(STRING, docStyle.getStringStyle());
  styleTagOpen[NUMBER] =getOpenTag(NUMBER, docStyle.getNumberStyle());
  styleTagOpen[SINGLE_LINE_COMMENT] =getOpenTag(SINGLE_LINE_COMMENT, 
                                                docStyle.getCommentStyle());
  styleTagOpen[MULTI_LINE_COMMENT_BEGIN] =getOpenTag(MULTI_LINE_COMMENT_BEGIN, 
                                                     docStyle.getCommentStyle());
  styleTagOpen[ESC_CHAR] =getOpenTag(ESC_CHAR, docStyle.getEscapeCharStyle());
  styleTagOpen[DIRECTIVE_LINE] =getOpenTag(DIRECTIVE_LINE, 
                                           docStyle.getDirectiveStyle());
  styleTagOpen[DIRECTIVE_STRING] =getOpenTag(DIRECTIVE_STRING, 
                                             docStyle.getDirectiveStringStyle());
  styleTagOpen[LINENUMBER] =getOpenTag(LINENUMBER, docStyle.getLineStyle());
  styleTagOpen[SYMBOL] =getOpenTag(SYMBOL, docStyle.getSymbolStyle());

  styleTagClose[STANDARD] =getCloseTag(docStyle.getDefaultStyle());
  styleTagClose[KEYWORD] =getCloseTag(docStyle.getKeywordStyle());
  styleTagClose[TYPE] =getCloseTag(docStyle.getTypeStyle());
  styleTagClose[STRING] =getCloseTag(docStyle.getStringStyle());
  styleTagClose[NUMBER] =getCloseTag(docStyle.getNumberStyle());
  styleTagClose[SINGLE_LINE_COMMENT] =getCloseTag(docStyle.getCommentStyle());
  styleTagClose[MULTI_LINE_COMMENT_BEGIN] =getCloseTag(docStyle.getCommentStyle());
  styleTagClose[ESC_CHAR] =getCloseTag(docStyle.getEscapeCharStyle());
  styleTagClose[DIRECTIVE_LINE] =getCloseTag(docStyle.getDirectiveStyle());
  styleTagClose[DIRECTIVE_STRING] =getCloseTag(docStyle.getDirectiveStringStyle());
  styleTagClose[LINENUMBER]=getCloseTag(docStyle.getLineStyle());
  styleTagClose[SYMBOL]=getCloseTag(docStyle.getSymbolStyle());

  stringstream s;
  s << formatStyleAttributes(docStyle.getDefaultStyle());
  s << formatStyleAttributes( docStyle.getKeywordStyle());
  s << formatStyleAttributes(docStyle.getTypeStyle());

  s << formatStyleAttributes(docStyle.getStringStyle());
  s << formatStyleAttributes(docStyle.getNumberStyle());
  s << formatStyleAttributes(docStyle.getCommentStyle());

  s << formatStyleAttributes(docStyle.getCommentStyle());
  s << formatStyleAttributes(docStyle.getEscapeCharStyle());
  s << formatStyleAttributes(docStyle.getDirectiveStyle());
  
  s << formatStyleAttributes(docStyle.getDirectiveStringStyle());
  s << formatStyleAttributes(docStyle.getLineStyle());
  s << formatStyleAttributes(docStyle.getSymbolStyle());
  styleDefinition = s.str();
  newLineTag = "\\par\\pard\n";
  spacer = " ";
}

RtfCode::RtfCode()
{}
RtfCode::~RtfCode()
{}

string RtfCode::getHeader(const string & title)
{
  return "";
}

/** gibt RTF-Text aus */
void RtfCode::printBody()
{
 *out << "{\\rtf1\\ansi\\uc0 \\deff1"
       << "{\\fonttbl{\\f1\\fmodern\\fprq1\\fcharset0 Courier New;}}"
       << "{\\colortbl;";
  *out <<  styleDefinition;
  *out << "}\n{\\info }\\paperw11900\\paperh16820\\margl560\\margr560\\margt840"
       << "\\margb840\\widowctrl\\ftnbj\\aenddoc\\formshade \\fet0\\sectd"
       << "\\linex0\\endnhere\\plain\\f1\\fs20\n\\pard ";
  processStandardState();
  *out << "}}"<<endl;
}


string RtfCode::getFooter()
{  
 return "";
}

/** Gibt RTF-Code der Sonderzeichen zurueck */
string RtfCode::maskCharacter(unsigned char c)
{
  string m;
  switch (c)
    {
    case '}' :      
    case '{' :      
    case '\\' :      
      m="\\";
      m+=c;      
      return m;
      break;
    case '0':      
    case '1':      
    case '2':      
    case '3':      
    case '4':      
    case '5':      
    case '6':      
    case '7':      
    case '8':      
    case '9':
      m="{";
      m+=c;
      m+="}";
      return m;
      break;
    case AUML_LC:
      return "\\'e4";
      break;
    case OUML_LC:
      return "\\'f6";
      break;
    case UUML_LC:
      return "\\'fc";
      break;
    case AUML_UC:
      return "\\'c4";
      break;
    case OUML_UC:
      return "\\'d6";
      break;
    case UUML_UC:
      return "\\'dc";
      break;
      
    case AACUTE_LC:
      return "\\'e1";
      break;
    case EACUTE_LC:
      return "\\'e9";
      break;    
    case OACUTE_LC:
      return "\\'f3";
      break;
    case UACUTE_LC:
      return "\\'fa";
      break;
      
    case AGRAVE_LC:
      return "\\'e0";
      break;
    case EGRAVE_LC:
      return "\\'e8";
      break;    
    case OGRAVE_LC:
      return "\\'f2";
      break;
    case UGRAVE_LC:
      return "\\'f9";
      break;
      
    case AACUTE_UC:
      return "\\'c1";
      break;
    case EACUTE_UC:
      return "\\'c9";
      break;
    case OACUTE_UC:
      return "\\'d3";
      break;
    case UACUTE_UC:
      return "\\'da";
      break;
    case AGRAVE_UC:
      return "\\'c0";
      break;
    case EGRAVE_UC:
      return "\\'c8";
      break;    
    case OGRAVE_UC:
      return "\\'d2";
      break;
    case UGRAVE_UC:
      return "\\'d9";
      break;
      
    case SZLIG:
      return "\\'df";
      break;
   // skip  first byte of multibyte chracters
    #ifndef _WIN32
    case 195:
      return string("");
      break; 
    #endif

    default :
      m += c;
      return m;
    }
}

}
