/***************************************************************************
                          LatexCode.cpp  -  description
                             -------------------
    begin                : Mit Jul 24 2002
    copyright            : (C) 2002 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "latexcode.h"

namespace highlight {

LatexCode::LatexCode(const string &colourTheme,
                     bool printLineNumbers,   bool fragment,
                     int numSpaces,  WrapMode wrapStyle,
                     bool replQuotes)
    : CodeParser(printLineNumbers, colourTheme, numSpaces, wrapStyle, fragment),
      replaceQuotes(replQuotes)
{ 
  styleTagOpen[STANDARD] = "\\hlstd{";
  styleTagOpen[KEYWORD] = "\\hlkey{";
  styleTagOpen[TYPE] = "\\hltyp{";
  styleTagOpen[STRING] = "\\hlstr{";
  styleTagOpen[NUMBER] = "\\hlnum{";
  styleTagOpen[SINGLE_LINE_COMMENT] = "\\hlcom{";
  styleTagOpen[MULTI_LINE_COMMENT_BEGIN] = "\\hlcom{";
  styleTagOpen[ESC_CHAR] = "\\hlesc{";
  styleTagOpen[DIRECTIVE_LINE] = "\\hldir{";
  styleTagOpen[DIRECTIVE_STRING] = "\\hldstr{";
  styleTagOpen[LINENUMBER] = "\\hlline{";
  styleTagOpen[SYMBOL] = "\\hlsym{";

  for (int i=0;i<NUMBER_OF_STYLES; i++)
    {
      styleTagClose[i] = "}";
    }

  newLineTag = "\\\\\n";
  spacer = "\\ ";

  maskWs=true;
  //excludeWs=true;        
  maskWsBegin = "\\hlstd{";
  maskWsEnd = "}";
  
  stringstream s;
  s << formatStyleAttributes("std", docStyle.getDefaultStyle());
  s << formatStyleAttributes("key", docStyle.getKeywordStyle());
  s << formatStyleAttributes("num", docStyle.getNumberStyle());
  s << formatStyleAttributes("typ", docStyle.getTypeStyle());
  s << formatStyleAttributes("esc", docStyle.getEscapeCharStyle());
  s << formatStyleAttributes("str", docStyle.getStringStyle());
  s << formatStyleAttributes("dstr", docStyle.getDirectiveStringStyle());
  s << formatStyleAttributes("com", docStyle.getCommentStyle());
  s << formatStyleAttributes("dir", docStyle.getDirectiveStyle());
  s << formatStyleAttributes("sym", docStyle.getSymbolStyle());
  s << formatStyleAttributes("line", docStyle.getLineStyle());
  styleDefinition = s.str();
}

LatexCode::LatexCode()
{}
LatexCode::~LatexCode()
{}

string  LatexCode::formatStyleAttributes(const string & elemName,const ElementStyle &elem)
{
  ostringstream s;
  s  << "\\newcommand{\\hl"
     << elemName
     << "}[1]{\\textcolor[rgb]{"
     << elem.getColour().getLatexRedValue() << ","
     << elem.getColour().getLatexGreenValue() << ","
     << elem.getColour().getLatexBlueValue()
     << "}{";
  
  if (elem.isBold())
    s << "\\bf{";
  if (elem.isItalic())
    s << "\\it{";
  
  s  <<"#1";
  
  if (elem.isBold())
    s << "}";
  if (elem.isItalic())
    s << "}";
  
  s  <<"}}\n";
  return s.str();
}

void LatexCode::printBody()
{
  *out << "\\noindent\n"
       << "\\ttfamily\n";

  processStandardState();

  *out << "\\mbox{}\\\\"
       << "\n\\normalfont\n";
}

string LatexCode::getHeader(const string & title)
{
  if (headerCache.empty()){
    ostringstream os;
    os << "\\documentclass{article}\n"
       << "\\usepackage{color}\n"
       << "\\usepackage{alltt}\n";
    os << styleDefinition;  
    os << "\n\\title{"<<title<<"}\n";
    os << "\\oddsidemargin -3mm\n\\textwidth 165,2truemm\n";
    os << "\\topmargin 0truept\n\\headheight 0truept\n";
    os << "\\headsep 0truept\n\\textheight 230truemm\n\n";
    os << "\\begin{document}\n"
       << "\\definecolor{bgcolor}{rgb}{"; 
    os << docStyle.getBgColour().getLatexRedValue() << ","
       << docStyle.getBgColour().getLatexGreenValue() << ","
       << docStyle.getBgColour().getLatexBlueValue()
       << "}\n\\pagecolor{bgcolor}"
       << endl;
     headerCache=os.str();
  }
  return headerCache;
}

string LatexCode::getFooter()
{
  if (footerCache.empty()){
    ostringstream os;
    os << "\\end {document}\n"
       << "(* LaTeX generated by highlight "
       << HIGHLIGHT_VERSION
       << ", "
       << HIGHLIGHT_URL
       << " *)"
       << endl;
    footerCache=os.str();
  }
  return footerCache;
}

string LatexCode::getNewLine(){
  return (line.length() || showLineNumbers)?newLineTag:"\\mbox{}"+newLineTag;
}

string LatexCode::maskCharacter(unsigned char c)
{
  string m;
  switch (c)
    {
    case '<' :
      return "$<$";
      break;
    case '>' :
      return "$>$";
      break;
    case '{':
    case '}':
    case '&':
    case '$':
    case '#':
    case '%':
      m +="\\";
      m += c;
      return m;
      break;
    case '\"':      
      return (fragmentOutput && replaceQuotes)?"\\dq":"\"";
      break; 
    case '_':
      return "\\textunderscore ";
      break;
    case '^':
      return "\\textasciicircum ";
      break;
    case '\\':
      return "$\\backslash$";
      break;
    case '~':
      return "$\\sim$";
      break;
    case '|':
      return "\\textbar ";
      break;
    case ' ':
      return spacer;
      break;
    case AUML_LC:
      return "\\\"a";
      break;
    case OUML_LC:
      return "\\\"o";
      break;
    case UUML_LC:
      return "\\\"u";
      break;
    case AUML_UC:
      return "\\\"A";
      break;
    case OUML_UC:
      return "\\\"O";
      break;
    case UUML_UC:
      return "\\\"U";
      break;
    case AACUTE_LC:
      return "\\'a";
      break;
    case EACUTE_LC:
      return "\\'e";
      break;    
    case OACUTE_LC:
      return "\\'o";
      break;
    case UACUTE_LC:
      return "\\'u";
      break;
    case AGRAVE_LC:
      return "\\`a";
      break;
    case EGRAVE_LC:
      return "\\`e";
      break;    
    case OGRAVE_LC:
      return "\\`o";
      break;
    case UGRAVE_LC:
      return "\\`u";
      break;
    case AACUTE_UC:
      return "\\'A";
      break;
    case EACUTE_UC:
      return "\\'E";
      break;    
    case OACUTE_UC:
      return "\\'O";
      break;
    case UACUTE_UC:
      return "\\'U";
      break;
    case AGRAVE_UC:
      return "\\`A";
      break;
    case EGRAVE_UC:
      return "\\`E";
      break;    
    case UGRAVE_UC:
      return "\\`O";
      break;
    case OGRAVE_UC:
      return "\\`U";
      break;
    case SZLIG:
      return "\\ss ";
      break;
     #ifndef _WIN32
 // skip  first byte of multibyte chracters
    case 195:
      return string("");
      break;    
     #endif
     
    default :
      m += c;
      return m;
    }
}

}
