/***************************************************************************
                          languagedefinition.h  -  description
                             -------------------
    begin                : Wed Nov 28 2001
    copyright            : (C) 2001 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LANGUAGEDEFINITION_H
#define LANGUAGEDEFINITION_H

#include <string>
#include <set>
#include <map>
#include <iostream>
#include <fstream>
#include <iterator>
#include <sstream>

#include "configurationreader.h"
#include "stringtools.h"
#include "enums.h"


namespace highlight {

/**Contains specific data of the programming language
   being processed. 
   @author Andre Simon
*/

class LanguageDefinition  {

  public:
        
    LanguageDefinition();

    /**Print list of keywords*/
    void printKeys();
    /**Print list of types*/ 
    void printTypes();

    /**\return Symbol string, containg all known symbols with the referencing state ids*/
    string &getSymbolString()
    {
      return symbolString;
    }

    /** \return Prefix of raw strings */
    char getRawStringPrefix(){
      return rawStringPrefix;
    }

   /** \return Continuation Character */
    char getContinuationChar(){
      return continuationChar;
    }

    /** \return List of characters allowed within identifiers */
    string &getAllowedChars()
    {
      return allowedChars;
    }
    bool getSyntaxHighlight()
    {
      return !disableHighlighting;
    }
    /** \return True if language is case sensitive */
    bool isCaseSensitive()
    {
      return caseSensitive;
    }
   /** \return True if escape characters may occour outside of strings */
    bool escCharsOutsideStrings()
    {
      return escCharsAllowedOutsideStrings;
    }
    
    /**  \param open Open string delimiter
         \param close Close string delimiter
         \return True if closing string delimiter matches open string delimiter
         */
    bool isMatchingStringDelim(const string &open,const string &close);
    /** \param s String
         \return true if s is member of keyword list */
    bool isKeyword(const string &s);
    /** \param s String
         \return true if s is member of type list */
    bool isType(const string &s);

    /** \return true if c is member of prefix list*/
    bool isPrefix (unsigned char c);
    /** \return true if c is number prefix */
    bool isNumberPrefix (unsigned char c);

    /** Load new language definition 
        \param langDefPath Path of language definition
        \param clear Test if former data should be deleted
        \return True if successfull  */
    bool load(const string& langDefPath, bool clear=true);

    /** \return  True if programming lanhuage is Forth */
    bool isForth();
    /** \return True if multi line comments my be nested */
    bool allowNestedMLComments();
    /** \return True if highlighting is disabled */
    bool highlightingDisabled();

    /** \return True if type identifiers should be highlighted within strings */
    bool typesWithinStringsEnabled();

    bool isFullLineComment();
    
    bool needsReload(const string &langDefPath); 
   
  private:   
    // String, der aus Symbolen und den zugehoerigen Symbolkonstnanten
    // zusammengesetzt ist
    string symbolString;

    // String mit Charactern, die in Keywords/Typbezeichnern erlaubt sind
    string allowedChars;
  
    //Pfad zur aktuell geladenen Definition
    string currentPath;

    // Mengen der Schluesselwoerter bzw. Typbezeichnungen
    set<string> keys;
    set<string> types;
    multimap<string, string> stringCloseDelim;

    bool caseSensitive,
    disableHighlighting,
    escCharsAllowedOutsideStrings,
    // flag, um den Forth Delimiter ")" bei Strings und Kommentaren korrekt zu erkennen
    thisIs4th,
    // Flag, um mehrzeilige Kommentare nicht verschachtelt zu parsen:
    allowNestedMultiLineComments,
    
    enableTypesWithinStrings,
    // Flag, das bestimmt, ob einzeilige Kommentare in der ersten Zeile beginnen (Fortran 77)
    fullLineComment;
    
    // Character, die eine Variable bzw. ein Keyword kennzeichnen
    char variablePrefix,
         keywordPrefix,
         numberPrefix,
         rawStringPrefix,
         continuationChar;

    /** setzt Membervariablen auf Defaultwerte */
    void reset();

    void fill(set<string>& s, const string &paramValues);
    void addSimpleSymbol(stringstream& symbolStream, State state, const string& paramValues );
    void addDelimiterSymbol(stringstream& symbolStream, State stateBegin, State stateEnd, 
                            const string& paramValues );

    bool getFlag( string& paramValue);
    unsigned char getSymbol(const string& paramValue);
  };

}
#endif
