/***************************************************************************
                          elementstyle.h  -  description
                             -------------------
    begin                : Son Nov 10 2002
    copyright            : (C) 2002 by André Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ELEMENTSTYLE_H
#define ELEMENTSTYLE_H

#include <sstream>

#include "stylecolour.h"

using namespace std;

namespace highlight {

/** Contains style attributes
  * @author Andre Simon
  */

class ElementStyle {
  public:

    /** Constructor 
        \param col Style colour 
        \param b Bold flag
        \param i Italic flag
        \param u Underline flag */
    ElementStyle(StyleColour col, bool b, bool i, bool u);

   /** Constuctor 
        \param elementStyleString String with fotmatting information */
    ElementStyle(const string & elementStyleString);
    ElementStyle();
    ~ElementStyle();

   void set(const string & elementStyleString);
 
   /** \return True if italic */   
    bool isItalic() const;

   /** \return True if bold */       
   bool isBold() const;

   /** \return True if underline */   
   bool isUnderline() const;
    
   /** \return Element colour */   
   StyleColour getColour() const;

 private:
    StyleColour colour;
    bool bold, italic, underline;
  };

}

#endif
