/***************************************************************************
                          cmdlineoptions.cpp  -  description
                             -------------------
    begin                : Sun Nov 25 2001
    copyright            : (C) 2001 by Andr�é Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cmdlineoptions.h"

using namespace std;

/* Siehe man getopt (3)
   Konstruktor legt Optionen und Argumente fest
*/
CmdLineOptions::CmdLineOptions(int argc, char *argv[]):
    numberSpaces(0),
    wrappingStyle(highlight::WRAP_DISABLED),
    formatStyle(highlight::FORMAT_DISABLED),
    cssOutFilename("highlight.css"),            
    opt_language (false),
    opt_include_css (false),
    opt_help (false),
    opt_version (false),
    opt_verbose (false),
    opt_linenumbers (false),
    opt_css_style (false),    
    opt_xhtml_output (false),
    opt_batch_mode (false),
    opt_batch_recursive(false),
    opt_rtf_output (false),
    opt_tex_output (false),
    opt_latex_output (false),
    opt_xslfo_output (false),
    opt_fragment (false) ,
    opt_attach_line_anchors (false),
    opt_show_themes (false),
    opt_show_langdefs (false),    
    opt_asformat_output(false),    
    opt_printindex(false),
    opt_quiet(false),
    opt_xslfo_fop(false),
    opt_replacequotes(false),
    opt_print_progress(false),
    configFileRead(false),
    helpLang("en")
{
  #if defined (USE_PORTABLE_CMDLINE_PARSER) && (_WIN32) 
  appPath= string(argv[0]);  
  string::size_type Pos = appPath.find_last_of('\\');
  appPath = appPath.substr(0, Pos+1);
  #endif

  loadConfigurationFile();

#ifndef USE_PORTABLE_CMDLINE_PARSER
  int c, option_index = 0;
  static struct option long_options[] =
      {
        {OPT_OUT, 1, 0, S_OPT_OUT},
        {OPT_IN, 1, 0, S_OPT_IN},
        {OPT_SYNTAX, 1, 0, S_OPT_SYNTAX},
        {OPT_VERBOSE, 0, 0, S_OPT_VERBOSE},
        {OPT_INCLUDECSS, 0, 0, S_OPT_INCLUDECSS},
        {OPT_HELP, 0, 0, S_OPT_HELP},
        {OPT_HELPINT, 1, 0, S_OPT_HELPINT},
        {OPT_LINENO,0,0,S_OPT_LINENO},
        {OPT_STYLE, 1,0,S_OPT_STYLE},
        {OPT_CSSOUT, 1, 0,S_OPT_CSSOUT},
        {OPT_CSSIN, 1, 0,S_OPT_CSSIN},
        {OPT_DELTABS,1,0,S_OPT_DELTABS},        
        {OPT_XHTML, 0,0,S_OPT_XHTML},
        {OPT_RTF, 0,0,S_OPT_RTF},
        {OPT_TEX,0, 0,S_OPT_TEX},
        {OPT_LATEX,0, 0,S_OPT_LATEX},
        {OPT_XSLFO,0, 0,S_OPT_XSLFO},
        {OPT_BATCH,1,0,S_OPT_BATCH},
        {OPT_BATCHREC,1,0,S_OPT_BATCHREC},        
        {OPT_FRAGMENT,0,0,S_OPT_FRAGMENT},
        {OPT_ANCHORS, 0,0,S_OPT_ANCHORS },
        {OPT_LISTTHEMES, 0,0,S_OPT_LISTTHEMES },
        {OPT_LISTLANGS, 0,0,S_OPT_LISTLANGS },
        {OPT_OUTDIR,1,0,S_OPT_OUTDIR},
        {OPT_VERSION,0,0,0},
        {OPT_FORMATSTYLE,1,0,S_OPT_FORMATSTYLE},
        {OPT_DATADIR,1,0,S_OPT_DATADIR},
        {OPT_ADDDATADIR,1,0,S_OPT_ADDDATADIR},
        {OPT_INDEXFILE,0,0,S_OPT_INDEXFILE},
        {OPT_WRAP,0,0,S_OPT_WRAP},
        {OPT_WRAPSIMPLE,0,0,S_OPT_WRAPSIMPLE},
        {OPT_QUIET,0,0,S_OPT_QUIET},
        //remove as soon as APAche fixes the bug in FOP (0.20.5)
        {OPT_FOP,0,0,S_OPT_FOP}, 
        {OPT_REPLACE_QUOTES,0,0,S_OPT_REPLACE_QUOTES},
        {OPT_PROGRESSBAR,0,0,S_OPT_PROGRESSBAR},
        {0, 0, 0, 0}
      };
#else
    CommandLineParser p;
    p.addSwitchOption(S_OPT_VERBOSE, OPT_VERBOSE);	
    p.addSwitchOption(S_OPT_QUIET, OPT_QUIET);
    p.addSwitchOption(S_OPT_INCLUDECSS, OPT_INCLUDECSS);
    p.addSwitchOption(S_OPT_HELP, OPT_HELP);    
    p.addSwitchOption(S_OPT_LINENO, OPT_LINENO);
    p.addSwitchOption(S_OPT_XHTML, OPT_XHTML);
    p.addSwitchOption(S_OPT_RTF, OPT_RTF);      
    p.addSwitchOption(S_OPT_TEX, OPT_TEX);      
    p.addSwitchOption(S_OPT_LATEX, OPT_LATEX);      
    p.addSwitchOption(S_OPT_XSLFO, OPT_XSLFO);
    p.addSwitchOption(S_OPT_FRAGMENT, OPT_FRAGMENT);        
    p.addSwitchOption(S_OPT_ANCHORS, OPT_ANCHORS);      
    p.addSwitchOption(S_OPT_LISTTHEMES, OPT_LISTTHEMES);
    p.addSwitchOption(S_OPT_LISTLANGS, OPT_LISTLANGS);      
    p.addSwitchOption(S_OPT_VERSION, OPT_VERSION);      
    p.addSwitchOption(S_OPT_INDEXFILE, OPT_INDEXFILE);
    p.addStringOption(S_OPT_IN, OPT_IN);
    p.addStringOption(S_OPT_OUT, OPT_OUT);
    p.addStringOption(S_OPT_SYNTAX, OPT_SYNTAX);
    p.addStringOption(S_OPT_STYLE, OPT_STYLE);
    p.addStringOption(S_OPT_CSSOUT, OPT_CSSOUT);
    p.addStringOption(S_OPT_CSSIN, OPT_CSSIN);
    p.addIntOption(S_OPT_DELTABS, OPT_DELTABS);
    p.addStringOption(S_OPT_BATCH, OPT_BATCH);
    p.addStringOption(S_OPT_BATCHREC, OPT_BATCHREC);
    p.addStringOption(S_OPT_OUTDIR, OPT_OUTDIR);
    p.addStringOption(S_OPT_FORMATSTYLE, OPT_FORMATSTYLE);
    p.addStringOption(S_OPT_DATADIR, OPT_DATADIR);
    p.addStringOption(S_OPT_ADDDATADIR, OPT_ADDDATADIR);
    p.addStringOption(S_OPT_HELPINT, OPT_HELPINT);
    p.addSwitchOption(S_OPT_WRAP, OPT_WRAP);
    p.addSwitchOption(S_OPT_WRAPSIMPLE, OPT_WRAPSIMPLE);
    //remove as son as APAche fixed the bug in FOP (0.20.5)
    p.addSwitchOption(S_OPT_FOP, OPT_FOP);
    p.addSwitchOption(S_OPT_REPLACE_QUOTES, OPT_REPLACE_QUOTES);
    p.addSwitchOption(S_OPT_PROGRESSBAR, OPT_PROGRESSBAR);
    try
    {
        p.parse(argc, argv);	
    }
    // you need to enable exceptions within your compiler settings
    catch (ArgumentParseException& ex)
    {
        cerr << ex.what() << endl;
    }
#endif      

#ifndef USE_PORTABLE_CMDLINE_PARSER
  while (1)
    {
      c = getopt_long (argc, argv,
                       "o:i:S:b:B:O:s:c:e:t:F:D:H:E:afhlvwpqrACILYRTXVWP",
                       long_options, &option_index);
      if (c == -1)
        break;

      switch (c)
        {
        case 0:   //nur long options
          if (long_options[option_index].name==OPT_VERSION)
            {
              opt_version = true;
            }
          break;
        case S_OPT_OUT:
          outFilename=string(optarg);          
          break;
        case S_OPT_IN:                    
          inputFileNames.push_back(string(optarg));  
          break;
        case S_OPT_CSSOUT:
          cssOutFilename=string(optarg);          
          break;
        case S_OPT_CSSIN:
          cssInFilename=string(optarg);          
          break;
        case S_OPT_VERBOSE:
          opt_verbose = true;
          break;
        case S_OPT_QUIET:
          opt_quiet = true;
          break;
        case S_OPT_INCLUDECSS:
          opt_include_css = true;
          break;        
        case S_OPT_HELPINT:
          helpLang=string(optarg);
        case S_OPT_HELP:        
          opt_help = true;
          break;
        case S_OPT_LINENO:
          opt_linenumbers = true;
          break;
        case '?':
          opt_help = true;
          break;
        case S_OPT_STYLE:
          styleName=string(optarg);
          opt_css_style = true;
          break;
        case S_OPT_SYNTAX:
          language=string(optarg);
          opt_language = true;
          break;
        case S_OPT_DELTABS:         
          numberSpaces = StringTools::str2int (string(optarg));
          break;
        case S_OPT_XHTML:
          opt_xhtml_output = true;
          break;
        case S_OPT_RTF:
          opt_rtf_output = true;
          break;
        case S_OPT_TEX:
          opt_tex_output = true;
          break;
        case S_OPT_LATEX:
          opt_latex_output = true;
          break;
        case S_OPT_XSLFO:
          opt_xslfo_output = true;
          break;
        case S_OPT_BATCHREC:
          opt_batch_recursive = true;  
        case S_OPT_BATCH:          
          opt_batch_mode = true;
          readDirectory(string(optarg), opt_batch_recursive);
          break;
        case S_OPT_FRAGMENT:
          opt_fragment = true;
          break;
        case S_OPT_ANCHORS:
          opt_attach_line_anchors = true;
          break;
        case S_OPT_LISTTHEMES:
          opt_show_themes = true;
          break;
        case S_OPT_LISTLANGS:
          opt_show_langdefs = true;
          break;
        case S_OPT_OUTDIR:
          outDirectory = validateDirPath(string(optarg));                    
          break;
        case S_OPT_FORMATSTYLE:
          setFormatStyle(optarg);
          break;
        case S_OPT_DATADIR:
          dataDir=validateDirPath(string(optarg));                    
          break;
        case S_OPT_ADDDATADIR:
          additionalDataDir=validateDirPath(string(optarg));                    
          break;
         case S_OPT_INDEXFILE:
          opt_printindex=true;
          break;
         case S_OPT_WRAPSIMPLE:
          wrappingStyle = highlight::WRAP_SIMPLE;
          break;
         case S_OPT_WRAP:
          wrappingStyle = highlight::WRAP_DEFAULT;
          break;
         case S_OPT_FOP:
          opt_xslfo_fop=true;
          break;
         case S_OPT_REPLACE_QUOTES:
          opt_replacequotes=true;
          break;
         case S_OPT_PROGRESSBAR:
          opt_print_progress=true;
          break; 
        default:
          cerr <<"higlight: Unknown option " <<c<< endl;
        }
    }
#else

   if (p.hasOption(S_OPT_OUT)){
          outFilename=p[OPT_OUT].toString();          
   }
   if (p.hasOption(S_OPT_IN)){          
          inputFileNames.push_back(p[OPT_IN].toString());  
   }
   if (p.hasOption(S_OPT_CSSOUT)){
          cssOutFilename=p[OPT_CSSOUT].toString();          
   }
   if (p.hasOption(S_OPT_CSSIN)){
          cssInFilename=p[OPT_CSSIN].toString();          
   }      
   if (p.hasOption(S_OPT_HELPINT)){
          helpLang=p[OPT_HELPINT].toString();
          opt_help = true;
   }
   if (p.hasOption(S_OPT_STYLE)){
          styleName=p[OPT_STYLE].toString();
          opt_css_style = true;
   }
   if (p.hasOption(S_OPT_SYNTAX)){
          language=p[OPT_SYNTAX].toString();
          opt_language = true;
   }
   if (p.hasOption(S_OPT_DELTABS)){        
          numberSpaces = p[OPT_DELTABS].toInt();
   }   
   if (p.hasOption(S_OPT_BATCHREC)){
      opt_batch_recursive = true;
      string batchwildcard = (string)p[OPT_BATCHREC];
      opt_batch_mode = true;
      readDirectory(batchwildcard, opt_batch_recursive);
   }
   if (p.hasOption(S_OPT_BATCH)){
      string batchwildcard = (string)p[OPT_BATCH];
      opt_batch_mode = true;
      readDirectory(batchwildcard, opt_batch_recursive);
   }
   if (p.hasOption(S_OPT_OUTDIR)){
        outDirectory = validateDirPath(p[OPT_OUTDIR].toString());                
   }           
   if (p.hasOption(S_OPT_FORMATSTYLE)){
      string f=p[OPT_FORMATSTYLE].toString();
      setFormatStyle(f.c_str());
   }    
   if (p.hasOption(S_OPT_DATADIR)){
      dataDir= validateDirPath(p[OPT_DATADIR].toString());              
   }
   if (p.hasOption(S_OPT_ADDDATADIR)){
      additionalDataDir= validateDirPath(p[OPT_ADDDATADIR].toString());              
   }
   if (p[S_OPT_WRAPSIMPLE]){
     wrappingStyle = highlight::WRAP_SIMPLE;
   }
   if (p[S_OPT_WRAP]){
      wrappingStyle = highlight::WRAP_DEFAULT;
   }

   opt_show_themes = p[S_OPT_LISTTHEMES];
   opt_show_langdefs = p[S_OPT_LISTLANGS];
   opt_help = (bool)p[S_OPT_HELP];
   opt_version = p[S_OPT_VERSION];
   if (p.hasOption(S_OPT_FRAGMENT)) opt_fragment = true;
   if (p.hasOption(S_OPT_ANCHORS)) opt_attach_line_anchors =true;   
   if (p.hasOption(S_OPT_INDEXFILE)) opt_printindex=true;
   if (p.hasOption(S_OPT_LINENO)) opt_linenumbers = true;
   if (p.hasOption(S_OPT_VERBOSE)) opt_verbose = true;
   if (p.hasOption(S_OPT_QUIET)) opt_quiet = true;
   if (p.hasOption(S_OPT_INCLUDECSS)) opt_include_css = true;
   if (p.hasOption(S_OPT_XHTML)) opt_xhtml_output = true;
   if (p.hasOption(S_OPT_RTF)) opt_rtf_output = true;
   if (p.hasOption(S_OPT_TEX)) opt_tex_output = true;
   if (p.hasOption(S_OPT_LATEX)) opt_latex_output = true;
   if (p.hasOption(S_OPT_XSLFO)) opt_xslfo_output = true;
   if (p.hasOption(S_OPT_FOP)) opt_xslfo_fop = true;
   if (p.hasOption(S_OPT_REPLACE_QUOTES)) opt_replacequotes=true;
   if (p.hasOption(S_OPT_PROGRESSBAR)) opt_print_progress=true;
#endif    

  #ifndef USE_PORTABLE_CMDLINE_PARSER
  if (optind < argc)   //still args left
  #else
  if (argc > 1)
  #endif
    {
      //Inputfile noch unbekannt ?
      if  (inputFileNames.empty())
        {
           #ifndef USE_PORTABLE_CMDLINE_PARSER          
           while (optind < argc){
            inputFileNames.push_back(string(argv[optind++]));  
           }
           #else           
           int argIndex=0;               
           while (++argIndex < argc){
            inputFileNames.push_back(string(argv[argIndex]));  
          }          
          #endif                            
        }      
    } else if (inputFileNames.empty()){
      // Leerstring einfügen, falls keine Eingabedateien angegeben wurden
      inputFileNames.push_back("");
    }
  if (printDebugInfo() && configFileRead) {
    cout << "Configuration file was read.\n";
  }      
}

CmdLineOptions::~CmdLineOptions(){
}

void CmdLineOptions::setFormatStyle(const char * style)
{
  string arg (style);
  opt_asformat_output =  true;

if ( arg =="ansi")
    {
        formatStyle =highlight::FORMAT_ANSI;
    }
  else if ( arg =="gnu")
    {
        formatStyle = highlight::FORMAT_GNU;
    }
  else if ( arg =="java")
    {
        formatStyle = highlight::FORMAT_JAVA;
    }
  else if ( arg =="kr")
    {
        formatStyle = highlight::FORMAT_KR;
    }
  else if ( arg =="linux")
    {
        formatStyle = highlight::FORMAT_LINUX;
    }
  else
    {
      opt_asformat_output =  false;
      cerr << "highlight: Unknown reformatting argument (-F): "
           << arg
           << "." << endl;
    }  
}

const string &CmdLineOptions::getSingleOutFilename() 
  {
   if (!inputFileNames.empty() && !outDirectory.empty()){
      int delim;
      delim = getSingleInFilename().find_last_of(PATH_SEPARATOR_CHAR);
      
      if (outFilename.empty()) {
        outFilename = outDirectory;
        outFilename += getSingleInFilename().substr((delim>-1)?delim:0) 
                       + getOutFileSuffix();
      } else {
         outFilename = outDirectory+outFilename;  
      }
   }
   return outFilename;
  }

const string CmdLineOptions::getSingleInFilename()  const
  {
    //return (inputFileNames.size())?inputFileNames[0]:"";
  return inputFileNames[0];
  }

const string &CmdLineOptions::getOutDirectory()const
  {
    return outDirectory;
  }

const string &CmdLineOptions::getCssOutFilename() const
  {
    return cssOutFilename;
  }
const string &CmdLineOptions::getCssInFilename() const
  {
    return cssInFilename;
  }
int CmdLineOptions::getNumberSpaces() const
  {
    return numberSpaces;  
  }
bool CmdLineOptions::printVersion()const
  {
    return opt_version;
  }
bool CmdLineOptions::printHelp()const
  {
    return opt_help;
  }
bool CmdLineOptions::printDebugInfo()const
  {
    return opt_verbose;
  }
bool CmdLineOptions::quietMode()const
  {
    return opt_quiet;
  }
bool CmdLineOptions::includeCssDefinition()const
  {
    return opt_include_css;
  }
bool CmdLineOptions::printLineNumbers()const
  {
    return opt_linenumbers;
  }
bool CmdLineOptions::xhtmlFormat()const
  {
    return opt_xhtml_output;
  }
bool CmdLineOptions::xslfoFormat()const
  {
    return opt_xslfo_output;
  }
bool CmdLineOptions::htmlFormat()const
  {
    return !(opt_rtf_output||opt_xhtml_output||opt_latex_output
             || opt_tex_output);
  }
bool CmdLineOptions::rtfFormat()const
  {
    return opt_rtf_output;
  }
bool CmdLineOptions::texFormat()const
  {
    return  opt_tex_output;
  }
bool CmdLineOptions::latexFormat()const
  {
    return opt_latex_output;
  }
string CmdLineOptions::getStyleName()const
  {
    return ( ( opt_css_style) ? styleName+".style" : "kwrite.style" );
  }
bool CmdLineOptions::enableBatchMode()const{
    return inputFileNames.size()>1 || opt_batch_mode;
}
bool CmdLineOptions::fragmentOutput()const{
    return opt_fragment;
}
string CmdLineOptions::getOutFileSuffix()const{
    if (opt_xhtml_output)
      return ".xhtml";
    if (opt_rtf_output)
      return ".rtf";    
    if (opt_tex_output || opt_latex_output)
      return ".tex";
    if (opt_xslfo_output)
      return ".fo";
    return ".html";
}
bool CmdLineOptions::attachLineAnchors()const{
    return opt_attach_line_anchors;
}
bool CmdLineOptions::showThemes()const{
    return opt_show_themes;
}
bool CmdLineOptions::showLangdefs()const{
    return opt_show_langdefs;
}
bool CmdLineOptions::outDirGiven()const{
    return !outFilename.empty();
}
bool CmdLineOptions::fopCompatible() const {
   return opt_xslfo_fop;
}
bool CmdLineOptions::replaceQuotes() const {
   return opt_replacequotes;
}
bool CmdLineOptions::getFlag( const string& paramVal){
   return StringTools::lowerCase(paramVal)=="true";
}
bool CmdLineOptions::formattingEnabled(){
    return opt_asformat_output;
}
bool CmdLineOptions::dataDirGiven()const {
  return !dataDir.empty();  
}
bool CmdLineOptions::additionalDataDirGiven()const {
  return !additionalDataDir.empty();  
}
string  CmdLineOptions::getDataDir() const {
 return dataDir;
}
string CmdLineOptions::getAdditionalDataDir()const{
 return additionalDataDir;
}
string  CmdLineOptions::getLanguage()  {
 return language;
}
bool CmdLineOptions::batchRecursive() const{
 return opt_batch_recursive;
}
bool CmdLineOptions::printIndexFile() const{
 return opt_printindex && (htmlFormat() || xhtmlFormat());
}
bool CmdLineOptions::printProgress() const{
 return opt_print_progress;
}
bool CmdLineOptions::syntaxGiven() const{
  return opt_language;
}
highlight::FormatStyle CmdLineOptions::getFormatStyle(){
  return formatStyle;
}
const string  CmdLineOptions::getHelpLang()const{
  return helpLang+".help";
}
highlight::WrapMode CmdLineOptions::getWrappingStyle() const {
  return wrappingStyle;
}
const vector <string> & CmdLineOptions::getInputFileNames() const{
  return inputFileNames;
}
void CmdLineOptions::readDirectory(const string & wildcard, bool recursive){
  bool directoryOK=DirectoryReader::getEntries (inputFileNames,
                                                wildcard,
                                                recursive);
  if (!directoryOK)
    {
       cerr << "highlight: No files matched the pattern "
            << wildcard << "."<< endl;      
    }      
}
void CmdLineOptions::loadConfigurationFile()
{
 string paramVal;
  #ifndef _WIN32
  string path=string(getenv("HOME"))+"/.highlightrc";    
  #else
  string path = appPath + "highlight.conf";      
  #endif  
  ConfigurationReader presets(path, false);
  
  if (presets.found())
    { 
      configFileRead=true;          
      paramVal = presets.getParameter(OPT_CSSOUT);
      if (!paramVal.empty())
        {
          cssOutFilename=paramVal;          
        }
      paramVal = presets.getParameter(OPT_CSSIN);
      if (!paramVal.empty())
        {
          cssInFilename=paramVal;          
        }      
      paramVal = presets.getParameter(OPT_STYLE);
      if (!paramVal.empty())
        {
          styleName=paramVal;
          opt_css_style = true;         
        }
      paramVal = presets.getParameter(OPT_DELTABS);
      if (!paramVal.empty())
        {          
          numberSpaces = StringTools::str2int(paramVal);         
        }          
      paramVal = presets.getParameter(OPT_FORMATSTYLE);
      if (!paramVal.empty())
        {
          setFormatStyle(paramVal.c_str());         
        }
      paramVal = presets.getParameter(OPT_DATADIR);
      if (!paramVal.empty()) 
        {
          dataDir=validateDirPath(paramVal);          
        }  
      paramVal = presets.getParameter(OPT_ADDDATADIR);
      if (!paramVal.empty()) 
        {
          additionalDataDir=validateDirPath(paramVal);          
        }  
      paramVal = presets.getParameter(OPT_OUTDIR);
      if (!paramVal.empty()) 
        {
          outDirectory=validateDirPath(paramVal);          
        }  

      opt_include_css=getFlag(presets.getParameter(OPT_INCLUDECSS));          
      opt_verbose=getFlag(presets.getParameter(OPT_VERBOSE));
      opt_linenumbers=getFlag(presets.getParameter(OPT_LINENO));
      opt_xhtml_output=getFlag(presets.getParameter(OPT_XHTML));     
      opt_rtf_output=getFlag(presets.getParameter(OPT_RTF));
      opt_tex_output=getFlag(presets.getParameter(OPT_TEX));
      opt_latex_output=getFlag(presets.getParameter(OPT_LATEX));
      opt_xslfo_output=getFlag(presets.getParameter(OPT_XSLFO));
      opt_fragment=getFlag(presets.getParameter(OPT_FRAGMENT));
      opt_attach_line_anchors=getFlag(presets.getParameter(OPT_ANCHORS));                
      opt_printindex=getFlag(presets.getParameter(OPT_INDEXFILE));
      opt_quiet=getFlag(presets.getParameter(OPT_QUIET));
      opt_xslfo_fop=getFlag(presets.getParameter(OPT_FOP));
      opt_replacequotes=getFlag(presets.getParameter(OPT_REPLACE_QUOTES));
      opt_print_progress=getFlag(presets.getParameter(OPT_PROGRESSBAR));
      
      if (getFlag(presets.getParameter(OPT_WRAP)))
        {
          wrappingStyle=highlight::WRAP_DEFAULT;
        }      
      if (getFlag(presets.getParameter(OPT_WRAPSIMPLE)))
        {
          wrappingStyle=highlight::WRAP_SIMPLE;
        }      
    }
}

string CmdLineOptions::validateDirPath(const string & path){
   return (path[path.length()-1] !=PATH_SEPARATOR_CHAR)?
              path+PATH_SEPARATOR_CHAR : path;          
}
